/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yamcs.xtce.Argument;
import org.yamcs.xtce.ArgumentAssignment;
import org.yamcs.xtce.CommandVerifier;
import org.yamcs.xtce.MetaCommandContainer;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.Significance;
import org.yamcs.xtce.TransmissionConstraint;

public class MetaCommand
extends NameDescription {
    private static final long serialVersionUID = 5L;
    List<Argument> argumentList = new ArrayList<Argument>();
    MetaCommandContainer commandContainer;
    MetaCommand baseMetaCommand;
    List<ArgumentAssignment> argumentAssignmentList;
    private Significance defaultSignificance = null;
    boolean abstractCmd = false;
    List<TransmissionConstraint> transmissionContstraintList = new ArrayList<TransmissionConstraint>();
    private List<CommandVerifier> verifierList = new ArrayList<CommandVerifier>();

    public MetaCommand(String name) {
        super(name);
    }

    public void setAbstract(boolean a) {
        this.abstractCmd = a;
    }

    public boolean isAbstract() {
        return this.abstractCmd;
    }

    public void setMetaCommandContainer(MetaCommandContainer mcc) {
        this.commandContainer = mcc;
    }

    public MetaCommandContainer getCommandContainer() {
        return this.commandContainer;
    }

    public void setBaseMetaCommand(MetaCommand mc) {
        this.baseMetaCommand = mc;
    }

    public MetaCommand getBaseMetaCommand() {
        return this.baseMetaCommand;
    }

    public List<ArgumentAssignment> getArgumentAssignmentList() {
        if (this.argumentAssignmentList == null) {
            return null;
        }
        return Collections.unmodifiableList(this.argumentAssignmentList);
    }

    public List<Argument> getArgumentList() {
        if (this.argumentList == null) {
            return null;
        }
        return Collections.unmodifiableList(this.argumentList);
    }

    public Argument getArgument(String argumentName) {
        for (Argument a : this.argumentList) {
            if (!a.getName().equals(argumentName)) continue;
            return a;
        }
        return null;
    }

    public void addArgument(Argument arg) {
        this.argumentList.add(arg);
    }

    public void addTransmissionConstrain(TransmissionConstraint constraint) {
        this.transmissionContstraintList.add(constraint);
    }

    public List<TransmissionConstraint> getTransmissionConstraintList() {
        return this.transmissionContstraintList;
    }

    public void addArgumentAssignment(ArgumentAssignment aa) {
        if (this.argumentAssignmentList == null) {
            this.argumentAssignmentList = new ArrayList<ArgumentAssignment>();
        }
        this.argumentAssignmentList.add(aa);
    }

    public boolean hasTransmissionConstraints() {
        return !this.transmissionContstraintList.isEmpty();
    }

    public Significance getDefaultSignificance() {
        return this.defaultSignificance;
    }

    public void setDefaultSignificance(Significance defaultSignificance) {
        this.defaultSignificance = defaultSignificance;
    }

    public void addVerifier(CommandVerifier cmdVerifier) {
        this.verifierList.add(cmdVerifier);
    }

    public boolean hasCommandVerifiers() {
        return !this.verifierList.isEmpty() || this.baseMetaCommand != null && this.baseMetaCommand.hasCommandVerifiers();
    }

    public List<CommandVerifier> getCommandVerifiers() {
        return Collections.unmodifiableList(this.verifierList);
    }

    public void print(PrintStream out) {
        out.print("MetaCommand name: " + this.name + " abstract:" + this.abstractCmd);
        if (this.getAliasSet() != null) {
            out.print(", aliases: " + this.getAliasSet());
        }
        if (!this.transmissionContstraintList.isEmpty()) {
            out.print(", TransmissionConstraints: ");
            out.print(this.transmissionContstraintList.toString());
        }
        if (this.defaultSignificance != null) {
            out.print(", defaultSignificance: ");
            out.print(this.defaultSignificance.toString());
        }
        if (!this.verifierList.isEmpty()) {
            out.print(", Verifiers: ");
            out.print(this.verifierList.toString());
        }
        out.println();
        if (this.baseMetaCommand != null) {
            out.println("\t baseMetaCommand: " + this.baseMetaCommand.getName() + " with argument assignment:" + this.argumentAssignmentList);
        }
        this.commandContainer.print(out);
    }
}

