/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.PrintStream;
import java.util.ArrayList;
import org.yamcs.xtce.Container;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.SequenceEntry;

public class SequenceContainer
extends Container {
    private static final long serialVersionUID = 3L;
    ArrayList<SequenceEntry> entryList = new ArrayList();
    SequenceContainer baseContainer;
    MatchCriteria restrictionCriteria;
    private boolean useAsArchivePartition;

    public SequenceContainer(String name) {
        super(name);
    }

    public SequenceContainer getBaseContainer() {
        return this.baseContainer;
    }

    public void setBaseContainer(SequenceContainer baseContainer) {
        this.baseContainer = baseContainer;
    }

    public MatchCriteria getRestrictionCriteria() {
        return this.restrictionCriteria;
    }

    public void addEntry(SequenceEntry entry) {
        this.getEntryList().add(entry);
        entry.setIndex(this.getEntryList().size() - 1);
    }

    public void setRestrictionCriteria(MatchCriteria restrictionCriteria) {
        this.restrictionCriteria = restrictionCriteria;
    }

    public void print(PrintStream out) {
        out.print("SequenceContainer name: " + this.name + (this.sizeInBits > -1 ? ", sizeInBits: " + this.sizeInBits : ""));
        if (this.getAliasSet() != null) {
            out.print(", aliases: " + this.getAliasSet());
        }
        out.print(", useAsArchivePartition:" + this.useAsArchivePartition);
        out.println();
        if (this.baseContainer != null) {
            out.print("\tbaseContainer: '" + this.baseContainer.getQualifiedName());
            out.println("', restrictionCriteria: " + this.restrictionCriteria);
        }
        for (SequenceEntry se : this.getEntryList()) {
            out.println("\t\t" + se);
        }
    }

    public void setEntryList(ArrayList<SequenceEntry> entryList) {
        this.entryList = entryList;
    }

    public ArrayList<SequenceEntry> getEntryList() {
        return this.entryList;
    }

    public String toString() {
        return "SequenceContainer(name=" + this.name + ")";
    }

    public boolean useAsArchivePartition() {
        return this.useAsArchivePartition;
    }

    public void useAsArchivePartition(boolean useAsArchivePartition) {
        this.useAsArchivePartition = useAsArchivePartition;
    }
}

