/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.Arrays;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.SplinePoint;

public class SplineCalibrator
extends Calibrator {
    private static final long serialVersionUID = 200706050819L;
    SplinePoint[] points;

    public SplineCalibrator(ArrayList<SplinePoint> points) {
        this.points = points.toArray(new SplinePoint[0]);
        Arrays.sort(this.points);
    }

    @Override
    public Double calibrate(double d) {
        double val = 0.0;
        int i = 0;
        int j = 0;
        for (i = 0; i < this.points.length && !(this.points[i].raw >= d); ++i) {
        }
        if (i == 0) {
            j = 0;
            i = 1;
        } else if (i == this.points.length) {
            j = this.points.length - 2;
            i = this.points.length - 1;
        } else {
            j = i - 1;
        }
        double a1 = this.points[i].raw;
        double b1 = this.points[i].calibrated;
        double a2 = this.points[j].raw;
        double b2 = this.points[j].calibrated;
        val = ((b1 - b2) * d + (a1 * b2 - b1 * a2)) / (a1 - a2);
        return val;
    }

    public String toString() {
        return "SplineCalibrator" + Arrays.toString(this.points);
    }
}

