/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.DataEncoding;

public class StringDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 200805131551L;
    private SizeType sizeType;
    private byte terminationChar = 0;
    int sizeInBitsOfSizeTag = 16;

    public StringDataEncoding() {
        super(-1);
    }

    public StringDataEncoding(String name, SizeType sizeType) {
        super(-1);
        this.sizeType = sizeType;
    }

    public void setSizeType(SizeType sizeType) {
        this.sizeType = sizeType;
    }

    public SizeType getSizeType() {
        return this.sizeType;
    }

    public int getSizeInBitsOfSizeTag() {
        return this.sizeInBitsOfSizeTag;
    }

    public void setSizeInBitsOfSizeTag(int sizeInBits) {
        this.sizeInBitsOfSizeTag = sizeInBits;
    }

    public byte getTerminationChar() {
        return this.terminationChar;
    }

    public void setTerminationChar(byte tc) {
        this.terminationChar = tc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StringDataEncoding size: ");
        sb.append((Object)this.getSizeType()).append("(");
        switch (this.sizeType) {
            case Fixed: {
                sb.append("fixedSizeInBits=" + this.getSizeInBits());
                break;
            }
            case LeadingSize: {
                sb.append("sizeInBitsOfSizeTag=" + this.sizeInBitsOfSizeTag);
                if (this.getSizeInBits() == -1) break;
                sb.append(", minSizeInBits=" + this.getSizeInBits());
                break;
            }
            case TerminationChar: {
                sb.append("terminationChar=" + this.terminationChar);
                if (this.getSizeInBits() == -1) break;
                sb.append(", minSizeInBits=" + this.getSizeInBits());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Object parseString(String stringValue) {
        return stringValue;
    }

    public static enum SizeType {
        Fixed,
        TerminationChar,
        LeadingSize;

    }
}

