/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.service;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.XtceDb;
import org.yamcs.xtce.service.MissionDatabaseDescriptor;
import org.yamcs.xtce.xml.XtceStaxReader;

public class MissionDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(MissionDatabaseService.class);
    private static final String XTCE_PROPERTIES_FILENAME = "xtce.properties";
    private static MissionDatabaseService instance = null;
    private Map<String, XtceDb> xtceDbMap;
    private Map<String, MissionDatabaseDescriptor> xtceDescMap;

    public static synchronized MissionDatabaseService getInstance() throws IOException {
        if (instance == null) {
            instance = new MissionDatabaseService();
        }
        return instance;
    }

    private MissionDatabaseService() throws IOException {
        this.initialize();
    }

    private void initialize() throws IOException {
        logger.info("Initializing instance");
        this.xtceDbMap = new HashMap<String, XtceDb>();
        this.xtceDescMap = new HashMap<String, MissionDatabaseDescriptor>();
        Properties properties = new Properties();
        properties.load(ClassLoader.getSystemClassLoader().getResourceAsStream(XTCE_PROPERTIES_FILENAME));
        String databases = properties.getProperty("mdb.databases");
        String[] dbs = null;
        if (databases != null) {
            dbs = databases.split(" ");
        }
        MissionDatabaseDescriptor mdbDescriptor = null;
        for (String database : dbs) {
            mdbDescriptor = new MissionDatabaseDescriptor(properties.getProperty("mdb." + database + ".name"), properties.getProperty("mdb." + database + ".validity.start"), properties.getProperty("mdb." + database + ".validity.end"), properties.getProperty("mdb." + database + ".path"));
            try {
                XtceStaxReader reader = new XtceStaxReader();
                SpaceSystem ss = reader.readXmlDocument(mdbDescriptor.getFilename());
                XtceDb xtceDb = new XtceDb(ss);
                this.xtceDbMap.put(mdbDescriptor.getName(), xtceDb);
                this.xtceDescMap.put(mdbDescriptor.getName(), mdbDescriptor);
                logger.info("Mdb loaded: " + mdbDescriptor.getFilename());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public XtceDb getXtceDb(String mdbName) {
        return this.xtceDbMap.get(mdbName);
    }

    public MissionDatabaseDescriptor getXtceDescriptor(String mdbName) {
        return this.xtceDescMap.get(mdbName);
    }

    public Set<String> getAvailableDatabases() {
        return Collections.unmodifiableSet(this.xtceDbMap.keySet());
    }
}

