/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.yamcs.xtce.InputParameter;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.OutputParameter;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.TriggerSetType;

public abstract class Algorithm
extends NameDescription {
    private static final long serialVersionUID = 6L;
    private TriggerSetType triggerSet;
    private ArrayList<InputParameter> inputSet = new ArrayList();
    private ArrayList<OutputParameter> outputSet = new ArrayList();
    private Scope scope = Scope.GLOBAL;

    public Algorithm(String name) {
        super(name);
    }

    public TriggerSetType getTriggerSet() {
        return this.triggerSet;
    }

    public void setTriggerSet(TriggerSetType triggerSet) {
        this.triggerSet = triggerSet;
    }

    public void addInput(InputParameter inputParameter) {
        this.inputSet.add(inputParameter);
    }

    public void addOutput(OutputParameter outputParameter) {
        this.outputSet.add(outputParameter);
    }

    public List<InputParameter> getInputSet() {
        return this.inputSet;
    }

    public List<OutputParameter> getOutputSet() {
        return this.outputSet;
    }

    public boolean canProvide(Parameter parameter) {
        for (OutputParameter p : this.outputSet) {
            if (p.getParameter() != parameter) continue;
            return true;
        }
        return false;
    }

    public void print(PrintStream out) {
        out.print("Algorithm name: " + this.name);
        if (this.scope != Scope.GLOBAL) {
            out.print(", scope: " + (Object)((Object)this.scope));
        }
        if (this.getAliasSet() != null) {
            out.print(", aliases: " + this.getAliasSet());
        }
        out.println();
        for (InputParameter inputParameter : this.inputSet) {
            out.println("\t\tInputParameter " + inputParameter);
        }
        for (OutputParameter outputParameter : this.outputSet) {
            out.println("\t\tOutputParameter " + outputParameter);
        }
        out.println("\t\tTriggers " + this.triggerSet);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public static enum Scope {
        GLOBAL,
        COMMAND_VERIFICATION,
        CONTAINER_PROCESSING;

    }
}

