/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.BinaryDataType;
import org.yamcs.xtce.DataEncoding;

public class BinaryDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 2L;
    int sizeInBitsOfSizeTag = 16;
    private Type type;

    public BinaryDataEncoding(Type type) {
        super(-1);
        this.type = type;
    }

    public BinaryDataEncoding(int sizeInBits) {
        super(sizeInBits);
        this.type = Type.FIXED_SIZE;
    }

    public void setSizeType(Type sizeType) {
        this.type = sizeType;
    }

    public Type getType() {
        return this.type;
    }

    public int getSizeInBitsOfSizeTag() {
        return this.sizeInBitsOfSizeTag;
    }

    public void setSizeInBitsOfSizeTag(int sizeInBits) {
        this.sizeInBitsOfSizeTag = sizeInBits;
    }

    public String toString() {
        return "BinaryDataEncoding(sizeInBits:" + this.sizeInBits + ")";
    }

    @Override
    public Object parseString(String stringValue) {
        return BinaryDataType.hexStringToArray(stringValue);
    }

    public static enum Type {
        FIXED_SIZE,
        LEADING_SIZE,
        CUSTOM;

    }
}

