/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.xtce.BooleanExpression;
import org.yamcs.xtce.CriteriaEvaluator;
import org.yamcs.xtce.OperatorType;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterType;

public class Condition
implements BooleanExpression {
    private static final long serialVersionUID = 1L;
    ParameterInstanceRef lValueRef = null;
    Object rValueRef = null;
    OperatorType comparisonOperator;
    String stringValue = null;
    static transient Logger LOG = LoggerFactory.getLogger((String)Condition.class.getName());

    public Condition(OperatorType comparisonOperator, ParameterInstanceRef lValueRef, ParameterInstanceRef rValueRef) {
        this.lValueRef = lValueRef;
        this.comparisonOperator = comparisonOperator;
        this.rValueRef = rValueRef;
        this.stringValue = null;
    }

    public Condition(OperatorType comparisonOperator, ParameterInstanceRef lValueRef, String stringValue) {
        this.lValueRef = lValueRef;
        this.comparisonOperator = comparisonOperator;
        this.stringValue = stringValue;
        this.rValueRef = null;
    }

    public void resolveValueType() {
        if (!(this.rValueRef != null && this.rValueRef instanceof ParameterInstanceRef || this.stringValue == null)) {
            boolean useCalibratedValue = this.lValueRef.useCalibratedValue();
            ParameterType ptype = this.lValueRef.getParameter().getParameterType();
            this.rValueRef = useCalibratedValue ? ptype.parseString(this.stringValue) : ptype.parseStringForRawValue(this.stringValue);
        } else {
            LOG.error("Cannot resolveValueType, inconsistent state");
        }
    }

    @Override
    public boolean isMet(CriteriaEvaluator evaluator) {
        return evaluator.evaluate(this.comparisonOperator, this.lValueRef, this.rValueRef);
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        HashSet<Parameter> pset = new HashSet<Parameter>();
        pset.add(this.lValueRef.getParameter());
        if (this.rValueRef instanceof ParameterInstanceRef) {
            pset.add(((ParameterInstanceRef)this.rValueRef).getParameter());
        }
        return pset;
    }

    public String toString() {
        String rValue = this.stringValue;
        if (this.stringValue == null) {
            rValue = ((ParameterInstanceRef)this.rValueRef).getParameter() == null ? "paraName(unresolved)" : "paramName(" + ((ParameterInstanceRef)this.rValueRef).getParameter().getName() + ")";
        }
        String lValue = "paraName(unresolved)";
        if (this.lValueRef.getParameter() != null) {
            lValue = "paraName(" + this.lValueRef.getParameter().getName() + ")";
        }
        return "Condition: " + lValue + OperatorType.operatorToString(this.comparisonOperator) + rValue;
    }

    public ParameterInstanceRef getlValueRef() {
        return this.lValueRef;
    }

    public Object getrValueRef() {
        return this.rValueRef;
    }

    public OperatorType getComparisonOperator() {
        return this.comparisonOperator;
    }
}

