/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import org.yamcs.xtce.Algorithm;

public abstract class DataEncoding
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected int sizeInBits;
    transient ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private Algorithm fromBinaryTransformAlgorithm;

    DataEncoding(int sizeInBits) {
        this.sizeInBits = sizeInBits;
    }

    DataEncoding(int sizeInBits, ByteOrder byteOrder) {
        this(sizeInBits);
        this.byteOrder = byteOrder;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public void setSizeInBits(int sizeInBits) {
        this.sizeInBits = sizeInBits;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder order) {
        this.byteOrder = order;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int o = in.readInt();
        this.byteOrder = o == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public abstract Object parseString(String var1);

    public Algorithm getFromBinaryTransformAlgorithm() {
        return this.fromBinaryTransformAlgorithm;
    }

    public void setFromBinaryTransformAlgorithm(Algorithm fromBinaryTransformAlgorithm) {
        this.fromBinaryTransformAlgorithm = fromBinaryTransformAlgorithm;
    }
}

