/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.EnumeratedDataType;
import org.yamcs.xtce.EnumerationAlarm;
import org.yamcs.xtce.EnumerationContextAlarm;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.ValueEnumeration;
import org.yamcs.xtce.ValueEnumerationRange;

public class EnumeratedParameterType
extends EnumeratedDataType
implements ParameterType {
    private static final long serialVersionUID = 200805301432L;
    private EnumerationAlarm defaultAlarm = null;
    private List<EnumerationContextAlarm> contextAlarmList = null;

    public EnumeratedParameterType(String name) {
        super(name);
    }

    public EnumeratedParameterType(EnumeratedParameterType t) {
        super(t);
        this.defaultAlarm = t.defaultAlarm;
        this.contextAlarmList = t.contextAlarmList;
    }

    @Override
    public boolean hasAlarm() {
        return this.defaultAlarm != null || this.contextAlarmList != null && !this.contextAlarmList.isEmpty();
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        if (this.contextAlarmList == null) {
            return null;
        }
        HashSet<Parameter> dependentParameters = new HashSet<Parameter>();
        for (EnumerationContextAlarm eca : this.contextAlarmList) {
            dependentParameters.addAll(eca.getContextMatch().getDependentParameters());
        }
        return dependentParameters;
    }

    public EnumerationAlarm getDefaultAlarm() {
        return this.defaultAlarm;
    }

    public void setDefaultAlarm(EnumerationAlarm enumerationAlarm) {
        this.defaultAlarm = enumerationAlarm;
    }

    public void addContextAlarm(EnumerationContextAlarm nca) {
        if (this.contextAlarmList == null) {
            this.contextAlarmList = new ArrayList<EnumerationContextAlarm>();
        }
        this.contextAlarmList.add(nca);
    }

    public EnumerationContextAlarm getContextAlarm(MatchCriteria contextMatch) {
        if (this.contextAlarmList == null) {
            return null;
        }
        for (EnumerationContextAlarm eca : this.contextAlarmList) {
            if (!eca.getContextMatch().equals(contextMatch)) continue;
            return eca;
        }
        return null;
    }

    public void addAlarm(MatchCriteria contextMatch, String enumLabel, AlarmLevels level) {
        this.createOrGetAlarm(contextMatch).addAlarm(enumLabel, level);
    }

    public EnumerationAlarm createOrGetAlarm(MatchCriteria contextMatch) {
        if (contextMatch == null) {
            if (this.defaultAlarm == null) {
                this.defaultAlarm = new EnumerationAlarm();
            }
            return this.defaultAlarm;
        }
        EnumerationContextAlarm eca = this.getContextAlarm(contextMatch);
        if (eca == null) {
            eca = new EnumerationContextAlarm();
            eca.setContextMatch(contextMatch);
            this.addContextAlarm(eca);
        }
        return eca;
    }

    public List<EnumerationContextAlarm> getContextAlarmList() {
        return this.contextAlarmList;
    }

    public String calibrate(long raw) {
        ValueEnumeration v = (ValueEnumeration)this.enumeration.get(raw);
        if (v != null) {
            return v.label;
        }
        if (this.ranges != null) {
            for (ValueEnumerationRange range : this.ranges) {
                if (!range.isValueInRange(raw)) continue;
                return range.label;
            }
        }
        return "UNDEF";
    }

    public String getCalibrationDescription() {
        return "EnumeratedParameterType: " + this.enumeration;
    }

    @Override
    public String getTypeAsString() {
        return "enumeration";
    }

    public String toString() {
        return "EnumeratedParameterType: " + this.enumerationList + " encoding:" + this.encoding + (this.defaultAlarm != null ? this.defaultAlarm : "") + (this.contextAlarmList != null ? this.contextAlarmList : "");
    }

    public void setContextAlarmList(List<EnumerationContextAlarm> contextAlarmList) {
        this.contextAlarmList = contextAlarmList;
    }
}

