/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yamcs.xtce.AncillaryData;
import org.yamcs.xtce.xml.XtceAliasSet;

public class NameDescription
implements Serializable {
    private static final long serialVersionUID = 200706050619L;
    protected String name = null;
    public static char PATH_SEPARATOR = (char)47;
    protected String qualifiedName = null;
    protected XtceAliasSet xtceAliasSet = null;
    private Map<String, AncillaryData> ancillaryDataSet = null;
    String shortDescription;
    String longDescription;

    NameDescription(String name) {
        this.name = name;
    }

    protected NameDescription(NameDescription t) {
        this.ancillaryDataSet = t.ancillaryDataSet;
        this.longDescription = t.longDescription;
        this.shortDescription = t.shortDescription;
        this.name = t.name;
        this.qualifiedName = t.qualifiedName;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias(String namespace) {
        if (this.xtceAliasSet == null) {
            return null;
        }
        return this.xtceAliasSet.getAlias(namespace);
    }

    public void setQualifiedName(String qname) {
        if (!qname.endsWith(this.name)) {
            throw new IllegalArgumentException("qualified name '" + qname + "' +must end with '" + this.name + "'");
        }
        this.qualifiedName = qname;
        String ssName = NameDescription.getSubsystemName(qname);
        this.addAlias(ssName, this.name);
    }

    public AncillaryData getAncillaryData(String name) {
        if (this.ancillaryDataSet == null) {
            return null;
        }
        return this.ancillaryDataSet.get(name);
    }

    public void addAncillaryData(AncillaryData data) {
        if (this.ancillaryDataSet == null) {
            this.ancillaryDataSet = new LinkedHashMap<String, AncillaryData>();
        }
        this.ancillaryDataSet.put(data.getName(), data);
    }

    public Collection<AncillaryData> getAncillaryDataSet() {
        return this.ancillaryDataSet.values();
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setAliasSet(XtceAliasSet aliasSet) {
        this.xtceAliasSet = aliasSet;
    }

    public XtceAliasSet getAliasSet() {
        return this.xtceAliasSet;
    }

    public void addAliases(XtceAliasSet newAliases) {
        if (this.xtceAliasSet == null) {
            this.xtceAliasSet = new XtceAliasSet();
        }
        for (Map.Entry<String, String> e : newAliases.getAliases().entrySet()) {
            this.xtceAliasSet.addAlias(e.getKey(), e.getValue());
        }
    }

    public void addAlias(String namespace, String alias) {
        if (this.xtceAliasSet == null) {
            this.xtceAliasSet = new XtceAliasSet();
        }
        this.xtceAliasSet.addAlias(namespace, alias);
    }

    public String getOpsName() {
        String alias;
        if (this.xtceAliasSet != null && (alias = this.xtceAliasSet.getAlias("MDB:OPS Name")) != null) {
            return alias;
        }
        return this.name;
    }

    public String getSubsystemName() {
        return NameDescription.getSubsystemName(this.qualifiedName);
    }

    public static String getName(String fqname) {
        int index = fqname.lastIndexOf(PATH_SEPARATOR);
        if (index < 0) {
            return fqname;
        }
        return fqname.substring(index + 1);
    }

    public static String getSubsystemName(String fqname) {
        int index = fqname.lastIndexOf(PATH_SEPARATOR);
        if (index == 0) {
            return String.valueOf(PATH_SEPARATOR);
        }
        if (index < 0) {
            throw new RuntimeException("Illegal qualified name '" + fqname + "'");
        }
        return fqname.substring(0, index);
    }
}

