/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.utils.DoubleRange;
import org.yamcs.utils.StringConverter;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.AlarmRanges;
import org.yamcs.xtce.BinaryDataEncoding;
import org.yamcs.xtce.BinaryParameterType;
import org.yamcs.xtce.BooleanParameterType;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.Comparison;
import org.yamcs.xtce.ComparisonList;
import org.yamcs.xtce.ContainerEntry;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.DynamicIntegerValue;
import org.yamcs.xtce.EnumeratedParameterType;
import org.yamcs.xtce.EnumerationAlarm;
import org.yamcs.xtce.FixedIntegerValue;
import org.yamcs.xtce.FloatDataEncoding;
import org.yamcs.xtce.FloatParameterType;
import org.yamcs.xtce.Header;
import org.yamcs.xtce.IntegerDataEncoding;
import org.yamcs.xtce.IntegerParameterType;
import org.yamcs.xtce.IntegerValue;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.NameReference;
import org.yamcs.xtce.NumericAlarm;
import org.yamcs.xtce.NumericContextAlarm;
import org.yamcs.xtce.OperatorType;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterEntry;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.PolynomialCalibrator;
import org.yamcs.xtce.RateInStream;
import org.yamcs.xtce.Repeat;
import org.yamcs.xtce.SequenceContainer;
import org.yamcs.xtce.SequenceEntry;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.SplineCalibrator;
import org.yamcs.xtce.SplinePoint;
import org.yamcs.xtce.StringDataEncoding;
import org.yamcs.xtce.StringParameterType;
import org.yamcs.xtce.UnitType;
import org.yamcs.xtce.UnresolvedNameReference;
import org.yamcs.xtce.ValueEnumerationRange;
import org.yamcs.xtce.xml.XtceAliasSet;
import org.yamcs.xtce.xml.XtceNotImplemented;
import org.yamcs.xtce.xml.XtceParameterProperties;
import org.yamcs.xtce.xml.XtceTerm;

public class XtceStaxReader {
    private static final String XTCE_SPACE_SYSTEM = "SpaceSystem";
    private static final String XTCE_ALIAS_SET = "AliasSet";
    private static final String XTCE_ALIAS = "Alias";
    private static final String XTCE_LONG_DESCRIPTION = "LongDescription";
    private static final String XTCE_HEADER = "Header";
    private static final String XTCE_AuthorSet = "AuthorSet";
    private static final String XTCE_NoteSet = "NoteSet";
    private static final String XTCE_HistorySet = "HistorySet";
    private static final String XTCE_TelemetryMetaData = "TelemetryMetaData";
    private static final String XTCE_ParameterTypeSet = "ParameterTypeSet";
    private static final String XTCE_BooleanParameterType = "BooleanParameterType";
    private static final String XTCE_EnumeratedParameterType = "EnumeratedParameterType";
    private static final String XTCE_EnumerationList = "EnumerationList";
    private static final String XTCE_Enumeration = "Enumeration";
    private static final String XTCE_RangeEnumeration = "RangeEnumeration";
    private static final String XTCE_IntegerParameterType = "IntegerParameterType";
    private static final String XTCE_StringParameterType = "StringParameterType";
    private static final String XTCE_BinaryParameterType = "BinaryParameterType";
    private static final String XTCE_FloatParameterType = "FloatParameterType";
    private static final String XTCE_RelativeTimeParameterType = "RelativeTimeParameterType";
    private static final String XTCE_AbsoluteTimeParameterType = "AbsoluteTimeParameterType";
    private static final String XTCE_ArrayParameterType = "ArrayParameterType";
    private static final String XTCE_AggregateParameterType = "AggregateParameterType";
    private static final String XTCE_PARAMETER_SET = "ParameterSet";
    private static final String XTCE_PARAMETER = "Parameter";
    private static final String XTCE_PARAMETER_REF = "ParameterRef";
    private static final String XTCE_PARAMETER_PROPERTIES = "ParameterProperties";
    private static final String XTCE_VALIDITY_CONDITION = "ValidityCondition";
    private static final String XTCE_COMPARISON_LIST = "ComparisonList";
    private static final String XTCE_COMPARISON = "Comparison";
    private static final String XTCE_BOOLEAN_EXPRESSION = "BooleanExpression";
    private static final String XTCE_CUSTOM_ALGORITHM = "CustomAlgorithm";
    private static final String XTCE_MATH_ALGORITHM = "MathAlgorithm";
    private static final String XTCE_RESTRICTION_CRITERIA = "RestrictionCriteria";
    private static final String XTCE_SYSTEM_NAME = "SystemName";
    private static final String XTCE_PHYSICAL_ADDRESS_SET = "PhysicalAddressSet";
    private static final String XTCE_TIME_ASSOCIATION = "TimeAssociation";
    private static final String XTCE_CONTAINER_SET = "ContainerSet";
    private static final String XTCE_BASE_CONTAINER = "BaseContainer";
    private static final String XTCE_MESSAGE_SET = "MessageSet";
    private static final String XTCE_STREAM_SET = "StreamSet";
    private static final String XTCE_ALGORITHM_SET = "AlgorithmSet";
    private static final String XTCE_COMMAND_MEATA_DATA = "CommandMetaData";
    private static final String XTCE_SEQUENCE_CONTAINER = "SequenceContainer";
    private static final String XTCE_ENTRY_LIST = "EntryList";
    private static final String XTCE_PARAMETER_REF_ENTRY = "ParameterRefEntry";
    private static final String XTCE_LOCATION_IN_CONTAINER_IN_BITS = "LocationInContainerInBits";
    private static final String XTCE_REPEAT_ENTRY = "RepeatEntry";
    private static final String XTCE_INCLUDE_CONDITION = "IncludeCondition";
    private static final String XTCE_PARAMETER_SEGMENT_REF_ENTRY = "ParameterSegmentRefEntry";
    private static final String XTCE_CONTAINER_REF_ENTRY = "ContainerRefEntry";
    private static final String XTCE_CONTAINER_SEGMENT_REF_ENTRY = "ContainerSegmentRefEntry";
    private static final String XTCE_STREAM_SEGMENT_ENTRY = "StreamSegmentEntry";
    private static final String XTCE_INDIRECT_PARAMETER_REF_ENTRY = "IndirectParameterRefEntry";
    private static final String XTCE_ARRAY_PARAMETER_REF_ENTRY = "ArrayParameterRefEntry";
    private static final String XTCE_UNIT_SET = "UnitSet";
    private static final String XTCE_UNIT = "Unit";
    private static final String XTCE_FLOAT_DATA_ENCODING = "FloatDataEncoding";
    private static final String XTCE_BINARY_DATA_ENCODING = "BinaryDataEncoding";
    private static final String XTCE_SIZE_IN_BITS = "SizeInBits";
    private static final String XTCE_FIXED_VALUE = "FixedValue";
    private static final String XTCE_DYNAMIC_VALUE = "DynamicValue";
    private static final String XTCE_DISCRETE_LOOKUP_LIST = "DiscreteLookupList";
    private static final String XTCE_INTEGER_DATA_ENCODING = "IntegerDataEncoding";
    private static final String XTCE_STRING_DATA_ENCODING = "StringDataEncoding";
    private static final String XTCE_CONTEXT_ALARM_LIST = "ContextAlarmList";
    private static final String XTCE_CONTEXT_ALARM = "ContextAlarm";
    private static final String XTCE_CONTEXT_MATCH = "ContextMatch";
    private static final String XTCE_DEFAULT_CALIBRATOR = "DefaultCalibrator";
    private static final String XTCE_CONTEXT_CALIBRATOR_LIST = "ContextCalibratorList";
    private static final String XTCE_SPLINE_CALIBRATOR = "SplineCalibrator";
    private static final String XTCE_POLYNOMIAL_CALIBRATOR = "PolynomialCalibrator";
    private static final String XTCE_MATH_OPERATION_CALIBRATOR = "MathOperationCalibrator";
    private static final String XTCE_TERM = "Term";
    private static final String XTCE_SPLINE_POINT = "SplinePoint";
    private static final String XTCE_COUNT = "Count";
    private static final String XTCE_INTEGER_VALUE = "IntegerValue";
    private static final String XTCE_PARAMETER_INSTANCE_REF = "ParameterInstanceRef";
    private static final String XTCE_STATIC_ALARM_RANGES = "StaticAlarmRanges";
    private static final String XTCE_DEFAULT_ALARM = "DefaultAlarm";
    private static final String XTCE_FIXED = "Fixed";
    private static final String XTCE_TERMINATION_CHAR = "TerminationChar";
    private static final String XTCE_LEADING_SIZE = "LeadingSize";
    private static final String XTCE_DEFAULT_RATE_IN_STREAM = "DefaultRateInStream";
    private static Logger log = LoggerFactory.getLogger(XtceStaxReader.class);
    private XMLEventReader xmlEventReader = null;
    private XMLEvent xmlEvent = null;
    private Map<String, Integer> xtceSkipStatistics = new HashMap<String, Integer>();
    private Set<String> excludedContainers = new HashSet<String>();
    String fileName;

    public SpaceSystem readXmlDocument(String fileName) throws XMLStreamException, IOException {
        SpaceSystem spaceSystem;
        block7: {
            this.fileName = fileName;
            this.xmlEventReader = this.initEventReader(fileName);
            this.xmlEvent = null;
            spaceSystem = null;
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                int eventType = this.xmlEvent.getEventType();
                if (eventType == 5) continue;
                if (eventType == 7) {
                    this.onStartDocument((StartDocument)this.xmlEvent);
                } else if (eventType == 1) {
                    spaceSystem = this.readSpaceSystem();
                } else {
                    if (eventType == 8) break block7;
                    if (this.isStartElementWithName(XTCE_SPACE_SYSTEM)) {
                        SpaceSystem ss = this.readSpaceSystem();
                        spaceSystem.addSpaceSystem(ss);
                    } else {
                        log.error("Unhandled event: {} ", (Object)this.xmlEvent);
                    }
                }
                if (this.xmlEventReader.peek() == null) break;
            }
            this.xmlEvent = null;
            this.xmlEventReader.close();
            this.xmlEventReader = null;
            throw new IllegalStateException("XML file parsing error");
        }
        this.onEndDocument();
        log.info("XTCE file parsing finished successfully");
        return spaceSystem;
    }

    private void onStartDocument(StartDocument start) {
        log.trace("XML version=\"" + start.getVersion() + "\" encoding: \"" + start.getCharacterEncodingScheme() + "\"");
    }

    private SpaceSystem readSpaceSystem() throws XMLStreamException {
        this.checkStartElementPreconditions();
        String value = this.readAttribute("name", this.xmlEvent.asStartElement());
        SpaceSystem spaceSystem = new SpaceSystem(value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                XtceAliasSet aliasSet = this.readXtceAliasSet();
                spaceSystem.setAliasSet(aliasSet);
                continue;
            }
            if (this.isStartElementWithName(XTCE_HEADER)) {
                this.readXtceHeader(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_TelemetryMetaData)) {
                this.readXtceTelemetryMetaData(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_COMMAND_MEATA_DATA)) {
                this.readXtceCommandMetaData(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_SPACE_SYSTEM)) {
                SpaceSystem ss = this.readSpaceSystem();
                spaceSystem.addSpaceSystem(ss);
                continue;
            }
            if (this.isEndElementWithName(XTCE_SPACE_SYSTEM)) break;
        }
        return spaceSystem;
    }

    private void onEndDocument() {
        try {
            log.trace("End of XML document");
            if (this.xmlEventReader != null) {
                this.xmlEventReader.close();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        finally {
            this.xmlEventReader = null;
        }
    }

    private XtceAliasSet readXtceAliasSet() throws XMLStreamException {
        log.trace(XTCE_ALIAS_SET);
        this.checkStartElementPreconditions();
        XtceAliasSet xtceAliasSet = new XtceAliasSet();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS)) {
                this.readXtceAlias(xtceAliasSet);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ALIAS_SET)) break;
        }
        return xtceAliasSet;
    }

    private void readXtceAlias(XtceAliasSet aliasSet) throws XMLStreamException {
        log.trace(XTCE_ALIAS);
        this.checkStartElementPreconditions();
        String nameSpace = this.readAttribute("nameSpace", this.xmlEvent.asStartElement());
        if (nameSpace == null) {
            throw new XMLStreamException("Namespace attribute is missing");
        }
        nameSpace = nameSpace.intern();
        String alias = this.readAttribute("alias", this.xmlEvent.asStartElement());
        if (alias == null) {
            throw new XMLStreamException("Alias attribute is missing");
        }
        aliasSet.addAlias(nameSpace, alias);
        this.xmlEvent = this.xmlEventReader.nextEvent();
        if (!this.isEndElementWithName(XTCE_ALIAS)) {
            throw new IllegalStateException("Alias end element expected");
        }
    }

    private void readXtceHeader(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_HEADER);
        this.checkStartElementPreconditions();
        Header h = new Header();
        String value = this.readAttribute("version", this.xmlEvent.asStartElement());
        h.setVersion(value);
        value = this.readAttribute("date", this.xmlEvent.asStartElement());
        h.setDate(value);
        spaceSystem.setHeader(h);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_AuthorSet)) {
                this.skipXtceSection(XTCE_AuthorSet);
                continue;
            }
            if (this.isStartElementWithName(XTCE_NoteSet)) {
                this.skipXtceSection(XTCE_NoteSet);
                continue;
            }
            if (this.isStartElementWithName(XTCE_HistorySet)) {
                this.skipXtceSection(XTCE_HistorySet);
                continue;
            }
            if (this.isEndElementWithName(XTCE_HEADER)) break;
        }
    }

    private void readXtceTelemetryMetaData(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_TelemetryMetaData);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ParameterTypeSet)) {
                this.readXtceParameterTypeSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_PARAMETER_SET)) {
                this.readXtceParameterSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTAINER_SET)) {
                this.readXtceContainerSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_MESSAGE_SET)) {
                this.readXtceMessageSet();
                continue;
            }
            if (this.isStartElementWithName(XTCE_STREAM_SET)) {
                this.readXtceStreamSet();
                continue;
            }
            if (this.isStartElementWithName(XTCE_ALGORITHM_SET)) {
                this.readXtceAlgorithmSet(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(XTCE_TelemetryMetaData)) break;
        }
    }

    private void readXtceParameterTypeSet(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_ParameterTypeSet);
        this.checkStartElementPreconditions();
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            ParameterType parameterType = null;
            if (this.isStartElementWithName(XTCE_BooleanParameterType)) {
                parameterType = this.readXtceBooleanParameterType();
            } else if (this.isStartElementWithName(XTCE_EnumeratedParameterType)) {
                parameterType = this.readXtceEnumeratedParameterType();
            } else if (this.isStartElementWithName(XTCE_FloatParameterType)) {
                parameterType = this.readXtceFloatParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_IntegerParameterType)) {
                parameterType = this.readXtceIntegerParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_BinaryParameterType)) {
                parameterType = this.readXtceBinaryParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_StringParameterType)) {
                parameterType = this.readXtceStringParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_RelativeTimeParameterType)) {
                parameterType = this.readXtceRelativeTimeParameterType();
            } else if (this.isStartElementWithName(XTCE_AbsoluteTimeParameterType)) {
                parameterType = this.readXtceAbsoluteTimeParameterType();
            } else if (this.isStartElementWithName(XTCE_ArrayParameterType)) {
                parameterType = this.readXtceArrayParameterType();
            } else if (this.isStartElementWithName(XTCE_AggregateParameterType)) {
                parameterType = this.readXtceAggregateParameterType();
            }
            if (parameterType == null) continue;
            spaceSystem.addParameterType(parameterType);
        } while (!this.isEndElementWithName(XTCE_ParameterTypeSet));
    }

    private BooleanParameterType readXtceBooleanParameterType() throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_BooleanParameterType);
        this.checkStartElementPreconditions();
        BooleanParameterType boolParamType = null;
        String name = this.readAttribute("name", this.xmlEvent.asStartElement());
        if (name == null) {
            throw new XMLStreamException("Unnamed boolean parameter type");
        }
        boolParamType = new BooleanParameterType(name);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                boolParamType.addAllUnits(this.readXtceUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                boolParamType.setEncoding(this.readXtceIntegerDataEncoding());
                continue;
            }
            if (this.isEndElementWithName(XTCE_BooleanParameterType)) break;
        }
        return boolParamType;
    }

    private ParameterType readXtceAggregateParameterType() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_AggregateParameterType);
        return null;
    }

    private ParameterType readXtceArrayParameterType() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_ArrayParameterType);
        return null;
    }

    private ParameterType readXtceAbsoluteTimeParameterType() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_AbsoluteTimeParameterType);
        return null;
    }

    private ParameterType readXtceRelativeTimeParameterType() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_RelativeTimeParameterType);
        return null;
    }

    private FloatParameterType readXtceFloatParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        FloatParameterType floatParamType = null;
        log.trace(XTCE_FloatParameterType);
        this.checkStartElementPreconditions();
        String value = this.readAttribute("name", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException("Unnamed float parameter type");
        }
        floatParamType = new FloatParameterType(value);
        value = this.readAttribute("sizeInBits", this.xmlEvent.asStartElement());
        if (value != null) {
            int sizeInBits = Integer.parseInt(value);
            if (sizeInBits != 32 && sizeInBits != 64) {
                throw new XMLStreamException("Float encoding " + sizeInBits + " not supported; Only 32 and 64 bits are supported");
            }
            floatParamType.setSizeInBits(sizeInBits);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                floatParamType.addAllUnits(this.readXtceUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                floatParamType.setEncoding(this.readXtceIntegerDataEncoding());
                continue;
            }
            if (this.isStartElementWithName(XTCE_FLOAT_DATA_ENCODING)) {
                floatParamType.setEncoding(this.readXtceFloatDataEncoding());
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_ALARM)) {
                floatParamType.setDefaultAlarm(this.readDefaultAlarm());
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                floatParamType.setContextAlarmList(this.readNumericContextAlarmList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_FloatParameterType)) break;
        }
        return floatParamType;
    }

    private FloatDataEncoding readXtceFloatDataEncoding() throws XMLStreamException {
        log.trace(XTCE_FLOAT_DATA_ENCODING);
        this.checkStartElementPreconditions();
        FloatDataEncoding floatDataEncoding = null;
        String name = "";
        String value = this.readAttribute("sizeInBits", this.xmlEvent.asStartElement());
        floatDataEncoding = value != null ? new FloatDataEncoding(Integer.parseInt(value)) : new FloatDataEncoding(32);
        value = this.readAttribute("encoding", this.xmlEvent.asStartElement());
        if (value != null && !"IEEE754_1985".equalsIgnoreCase(value)) {
            if ("MILSTD_1750A".equalsIgnoreCase(value)) {
                log.error("Encoding MILSTD_1750A is not currently supported.");
                throw new XMLStreamException("Encoding MILSTD_1750A is not currently supported.");
            }
            throw new XMLStreamException();
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_DEFAULT_CALIBRATOR)) {
                floatDataEncoding.setDefaultCalibrator(this.readDefaultCalibrator());
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_CALIBRATOR_LIST)) {
                this.skipXtceSection(XTCE_CONTEXT_CALIBRATOR_LIST);
                continue;
            }
            if (this.isEndElementWithName(XTCE_FLOAT_DATA_ENCODING)) break;
        }
        return floatDataEncoding;
    }

    private List<NumericContextAlarm> readNumericContextAlarmList(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_CONTEXT_ALARM_LIST);
        ArrayList<NumericContextAlarm> contextAlarmList = new ArrayList<NumericContextAlarm>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM)) {
                contextAlarmList.add(this.readNumericContextAlarm(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTEXT_ALARM_LIST)) break;
        }
        return contextAlarmList;
    }

    private NumericAlarm readDefaultAlarm() throws XMLStreamException {
        NumericAlarm na = new NumericAlarm();
        this.readAlarmAttributes(na);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(XTCE_DEFAULT_ALARM)) {
                return na;
            }
            if (this.xmlEvent.getEventType() != 1) continue;
            this.readNumericAlarmElement(na);
        }
    }

    private NumericContextAlarm readNumericContextAlarm(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_CONTEXT_ALARM);
        NumericContextAlarm nca = new NumericContextAlarm();
        this.readAlarmAttributes(nca);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTEXT_MATCH)) {
                nca.setContextMatch(this.readMatchCriteria(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTEXT_ALARM)) {
                return nca;
            }
            if (this.xmlEvent.getEventType() != 1) continue;
            this.readNumericAlarmElement(nca);
        }
    }

    private void readNumericAlarmElement(NumericAlarm numericAlarm) throws XMLStreamException {
        if (this.isStartElementWithName(XTCE_STATIC_ALARM_RANGES)) {
            numericAlarm.setStaticAlarmRanges(this.readAlarmRanges());
        }
    }

    private AlarmRanges readAlarmRanges() throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        AlarmRanges ar = new AlarmRanges();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("WatchRange")) {
                ar.addWatchRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("WarningRange")) {
                ar.addWarningRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("DistressRange")) {
                ar.addDistressRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("CriticalRange")) {
                ar.addCriticalRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("SevereRange")) {
                ar.addSevereRange(this.readFloatRange());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return ar;
    }

    private DoubleRange readFloatRange() {
        StartElement e = this.xmlEvent.asStartElement();
        double minExclusive = Double.NaN;
        double maxExclusive = Double.NaN;
        double minInclusive = Double.NaN;
        double maxInclusive = Double.NaN;
        String value = this.readAttribute("minExclusive", e);
        if (value != null) {
            minExclusive = Double.parseDouble(value);
        }
        if ((value = this.readAttribute("maxExclusive", e)) != null) {
            maxExclusive = Double.parseDouble(value);
        }
        if ((value = this.readAttribute("minInclusive", e)) != null) {
            minInclusive = Double.parseDouble(value);
        }
        if ((value = this.readAttribute("maxInclusive", e)) != null) {
            maxInclusive = Double.parseDouble(value);
        }
        return DoubleRange.fromXtceComplement((double)minExclusive, (double)maxExclusive, (double)minInclusive, (double)maxInclusive);
    }

    private void readAlarmAttributes(NumericAlarm numericAlarm) {
        String value = this.readAttribute("minViolations", this.xmlEvent.asStartElement());
        if (value != null) {
            int minViolations = Integer.parseInt(value);
            numericAlarm.setMinViolations(minViolations);
        }
    }

    private BinaryParameterType readXtceBinaryParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_BinaryParameterType);
        this.checkStartElementPreconditions();
        BinaryParameterType binaryParamType = null;
        String name = this.readAttribute("name", this.xmlEvent.asStartElement());
        if (name == null) {
            throw new XMLStreamException("Unnamed binary parameter type");
        }
        binaryParamType = new BinaryParameterType(name);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                binaryParamType.addAllUnits(this.readXtceUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                binaryParamType.setEncoding(this.readXtceIntegerDataEncoding());
                continue;
            }
            if (this.isStartElementWithName(XTCE_BINARY_DATA_ENCODING)) {
                binaryParamType.setEncoding(this.readXtceBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_BinaryParameterType)) break;
        }
        return binaryParamType;
    }

    private DataEncoding readXtceBinaryDataEncoding(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_BINARY_DATA_ENCODING);
        this.checkStartElementPreconditions();
        BinaryDataEncoding binaryDataEncoding = null;
        String name = "";
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_SIZE_IN_BITS)) {
                IntegerValue v = this.readXtceIntegerValue(spaceSystem);
                if (v instanceof FixedIntegerValue) {
                    binaryDataEncoding = new BinaryDataEncoding((int)((FixedIntegerValue)v).getValue());
                    continue;
                }
                this.throwException("Only FixedIntegerValue supported for sizeInBits");
                continue;
            }
            if (this.isStartElementWithName("FromBinaryTransformAlgorithm")) {
                this.skipXtceSection("FromBinaryTransformAlgorithm");
                continue;
            }
            if (this.isStartElementWithName("ToBinaryTransformAlgorithm")) {
                this.skipXtceSection("ToBinaryTransformAlgorithm");
                continue;
            }
            if (this.isEndElementWithName(XTCE_BINARY_DATA_ENCODING)) break;
        }
        return binaryDataEncoding;
    }

    private void throwException(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg + " at " + this.xmlEvent.getLocation().getLineNumber() + ": " + this.xmlEvent.getLocation().getColumnNumber());
    }

    private int readIntegerValue() throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        int sizeInBits = 0;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                sizeInBits = this.getIntegerCharacter();
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return sizeInBits;
    }

    int getIntegerCharacter() throws XMLStreamException {
        if (this.xmlEvent.isCharacters()) {
            String value = this.xmlEvent.asCharacters().getData();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new XMLStreamException("Cannot parse integer '" + value + "' at " + this.xmlEvent.getLocation().getLineNumber() + ":" + this.xmlEvent.getLocation().getColumnNumber());
            }
        }
        throw new IllegalStateException();
    }

    private StringParameterType readXtceStringParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_IntegerParameterType);
        this.checkStartElementPreconditions();
        StringParameterType stringParamType = null;
        String value = this.readAttribute("name", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException("Unnamed string parameter type");
        }
        stringParamType = new StringParameterType(value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                stringParamType.addAllUnits(this.readXtceUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_STRING_DATA_ENCODING)) {
                stringParamType.setEncoding(this.readXtceStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                this.skipXtceSection(XTCE_CONTEXT_ALARM_LIST);
                continue;
            }
            if (this.isEndElementWithName(XTCE_StringParameterType)) break;
        }
        return stringParamType;
    }

    private StringDataEncoding readXtceStringDataEncoding(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StringDataEncoding stringDataEncoding = new StringDataEncoding();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_SIZE_IN_BITS)) {
                this.readStringSizeInBits(spaceSystem, stringDataEncoding);
                continue;
            }
            if (this.isEndElementWithName(XTCE_STRING_DATA_ENCODING)) break;
        }
        return stringDataEncoding;
    }

    private void readStringSizeInBits(SpaceSystem spaceSystem, StringDataEncoding stringDataEncoding) throws XMLStreamException {
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_FIXED)) {
                IntegerValue v = this.readXtceIntegerValue(spaceSystem);
                if (v instanceof FixedIntegerValue) {
                    stringDataEncoding.setSizeType(StringDataEncoding.SizeType.FIXED);
                    stringDataEncoding.setSizeInBits((int)((FixedIntegerValue)v).getValue());
                    continue;
                }
                this.throwException("Only FixedValue supported for string size in bits");
                continue;
            }
            if (this.isStartElementWithName(XTCE_TERMINATION_CHAR)) {
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.TERMINATION_CHAR);
                byte[] x = this.readHexBinary();
                if (x == null || x.length != 1) {
                    throw new XMLStreamException("Terminated strings have to have the size of the termination character of 1");
                }
                stringDataEncoding.setTerminationChar(x[0]);
                continue;
            }
            if (this.isStartElementWithName(XTCE_LEADING_SIZE)) {
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.LEADING_SIZE);
                String value = this.readAttribute("sizeInBitsOfSizeTag", this.xmlEvent.asStartElement());
                stringDataEncoding.setSizeInBitsOfSizeTag(Integer.valueOf(value));
                continue;
            }
            if (this.isEndElementWithName(XTCE_SIZE_IN_BITS)) break;
        }
    }

    private byte[] readHexBinary() throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        byte[] b = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                b = StringConverter.hexStringToArray((String)this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return b;
    }

    private IntegerParameterType readXtceIntegerParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_IntegerParameterType);
        this.checkStartElementPreconditions();
        String value = this.readAttribute("name", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException("Unnamed integer parameter type");
        }
        IntegerParameterType integerParamType = new IntegerParameterType(value);
        value = this.readAttribute("sizeInBits", this.xmlEvent.asStartElement());
        if (value != null) {
            int sizeInBits = Integer.parseInt(value);
            integerParamType.setSizeInBits(sizeInBits);
        }
        if ((value = this.readAttribute("signed", this.xmlEvent.asStartElement())) != null) {
            boolean signed = Boolean.parseBoolean(value);
            integerParamType.setSigned(signed);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                integerParamType.addAllUnits(this.readXtceUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                integerParamType.setEncoding(this.readXtceIntegerDataEncoding());
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_ALARM)) {
                integerParamType.setDefaultAlarm(this.readDefaultAlarm());
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                integerParamType.setContextAlarmList(this.readNumericContextAlarmList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_IntegerParameterType)) break;
        }
        return integerParamType;
    }

    private IntegerDataEncoding readXtceIntegerDataEncoding() throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_INTEGER_DATA_ENCODING);
        this.checkStartElementPreconditions();
        IntegerDataEncoding integerDataEncoding = null;
        String name = "";
        String value = this.readAttribute("sizeInBits", this.xmlEvent.asStartElement());
        integerDataEncoding = value != null ? new IntegerDataEncoding(Integer.parseInt(value)) : new IntegerDataEncoding(8);
        value = this.readAttribute("encoding", this.xmlEvent.asStartElement());
        if (value != null) {
            if ("unsigned".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.UNSIGNED);
            } else if ("signMagnitude".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.SIGN_MAGNITUDE);
            } else if ("twosComplement".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.TWOS_COMPLEMENT);
            } else if ("twosCompliment".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.TWOS_COMPLEMENT);
            } else if ("onesComplement".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.ONES_COMPLEMENT);
            } else {
                this.throwException("Unsupported encoding '" + value + "'");
            }
        } else {
            integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.UNSIGNED);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_DEFAULT_CALIBRATOR)) {
                integerDataEncoding.setDefaultCalibrator(this.readDefaultCalibrator());
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_CALIBRATOR_LIST)) {
                this.skipXtceSection(XTCE_CONTEXT_CALIBRATOR_LIST);
                continue;
            }
            if (this.isEndElementWithName(XTCE_INTEGER_DATA_ENCODING)) break;
        }
        return integerDataEncoding;
    }

    private Calibrator readDefaultCalibrator() throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_DEFAULT_CALIBRATOR);
        this.checkStartElementPreconditions();
        Calibrator calibrator = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_POLYNOMIAL_CALIBRATOR)) {
                calibrator = this.readXtcePolynomialCalibrator();
                continue;
            }
            if (this.isStartElementWithName(XTCE_MATH_OPERATION_CALIBRATOR)) {
                this.skipXtceSection(XTCE_MATH_OPERATION_CALIBRATOR);
                continue;
            }
            if (this.isStartElementWithName(XTCE_SPLINE_CALIBRATOR)) {
                calibrator = this.readXtceSplineCalibrator();
                continue;
            }
            if (this.isEndElementWithName(XTCE_DEFAULT_CALIBRATOR)) break;
        }
        return calibrator;
    }

    private Calibrator readXtceSplineCalibrator() throws XMLStreamException {
        log.trace(XTCE_SPLINE_CALIBRATOR);
        this.checkStartElementPreconditions();
        ArrayList<SplinePoint> splinePoints = new ArrayList<SplinePoint>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_SPLINE_POINT)) {
                splinePoints.add(this.readXtceSplinePoint());
                continue;
            }
            if (this.isEndElementWithName(XTCE_SPLINE_CALIBRATOR)) break;
        }
        return new SplineCalibrator(splinePoints);
    }

    private SplinePoint readXtceSplinePoint() throws XMLStreamException {
        log.trace(XTCE_SPLINE_POINT);
        this.checkStartElementPreconditions();
        double raw = 0.0;
        double calibrated = 0.0;
        String attributeValue = this.readAttribute("raw", this.xmlEvent.asStartElement());
        if (attributeValue == null) {
            throw new XMLStreamException();
        }
        raw = Double.parseDouble(attributeValue);
        attributeValue = this.readAttribute("calibrated", this.xmlEvent.asStartElement());
        if (attributeValue == null) {
            throw new XMLStreamException();
        }
        calibrated = Double.parseDouble(attributeValue);
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
        } while (!this.isEndElementWithName(XTCE_SPLINE_POINT));
        return new SplinePoint(raw, calibrated);
    }

    private Calibrator readXtcePolynomialCalibrator() throws XMLStreamException {
        log.trace(XTCE_POLYNOMIAL_CALIBRATOR);
        this.checkStartElementPreconditions();
        int maxExponent = 0;
        HashMap<Integer, Double> polynome = new HashMap<Integer, Double>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_TERM)) {
                XtceTerm term = this.readXtceTerm();
                if (term.getExponent() > maxExponent) {
                    maxExponent = term.getExponent();
                }
                polynome.put(term.getExponent(), term.getCoefficient());
                continue;
            }
            if (this.isEndElementWithName(XTCE_POLYNOMIAL_CALIBRATOR)) break;
        }
        double[] coefficients = new double[maxExponent + 1];
        for (Map.Entry entry : polynome.entrySet()) {
            coefficients[((Integer)entry.getKey()).intValue()] = (Double)entry.getValue();
        }
        return new PolynomialCalibrator(coefficients);
    }

    private XtceTerm readXtceTerm() throws XMLStreamException {
        log.trace(XTCE_TERM);
        this.checkStartElementPreconditions();
        int exponent = 0;
        double coefficient = 0.0;
        String value = this.readAttribute("coefficient", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException();
        }
        coefficient = Double.parseDouble(value);
        value = this.readAttribute("exponent", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException();
        }
        exponent = (int)Double.parseDouble(value);
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
        } while (!this.isEndElementWithName(XTCE_TERM));
        return new XtceTerm(exponent, coefficient);
    }

    private List<UnitType> readXtceUnitSet() throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_UNIT_SET);
        ArrayList<UnitType> units = new ArrayList<UnitType>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT)) {
                UnitType u = this.readXtceUnit();
                units.add(u);
                continue;
            }
            if (this.isEndElementWithName(XTCE_UNIT_SET)) break;
        }
        return units;
    }

    private UnitType readXtceUnit() throws XMLStreamException {
        String descriptionValue;
        String factorValue;
        String powerValue;
        block4: {
            log.trace(XTCE_UNIT);
            this.checkStartElementPreconditions();
            StartElement element = this.xmlEvent.asStartElement();
            powerValue = this.readAttribute("power", element);
            factorValue = this.readAttribute("factor", element);
            descriptionValue = this.readAttribute("description", element);
            do {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.xmlEvent.isCharacters()) break block4;
            } while (!this.isEndElementWithName(XTCE_UNIT));
            return null;
        }
        String unit = this.xmlEvent.asCharacters().getData();
        UnitType unitType = new UnitType(unit);
        if (powerValue != null) {
            unitType.setPower(Double.parseDouble(powerValue));
        }
        if (factorValue != null) {
            unitType.setFactor(factorValue);
        }
        if (descriptionValue != null) {
            unitType.setDescription(descriptionValue);
        }
        return unitType;
    }

    private EnumeratedParameterType readXtceEnumeratedParameterType() throws IllegalStateException, XMLStreamException {
        EnumeratedParameterType enumParamType = null;
        log.trace(XTCE_EnumeratedParameterType);
        this.checkStartElementPreconditions();
        String value = this.readAttribute("name", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException();
        }
        enumParamType = new EnumeratedParameterType(value);
        value = this.readAttribute("defaultValue", this.xmlEvent.asStartElement());
        if (value != null) {
            enumParamType.setInitialValue(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                enumParamType.addAllUnits(this.readXtceUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                enumParamType.setEncoding(this.readXtceIntegerDataEncoding());
                continue;
            }
            if (this.isStartElementWithName(XTCE_EnumerationList)) {
                this.readXtceEnumerationList(enumParamType);
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_ALARM)) {
                enumParamType.setDefaultAlarm(this.readXtceEnumerationAlarm(enumParamType));
                continue;
            }
            if (this.isEndElementWithName(XTCE_EnumeratedParameterType)) break;
        }
        return enumParamType;
    }

    private void readXtceEnumerationList(EnumeratedParameterType enumParamType) throws XMLStreamException {
        log.trace(XTCE_EnumerationList);
        this.checkStartElementPreconditions();
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement());
        if (initialValue != null) {
            enumParamType.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_Enumeration)) {
                this.readXtceEnumeration(enumParamType);
                continue;
            }
            if (this.isStartElementWithName(XTCE_RangeEnumeration)) {
                enumParamType.addEnumerationRange(this.readXtceRangeEnumeration());
                continue;
            }
            if (this.isEndElementWithName(XTCE_EnumerationList)) break;
        }
    }

    private EnumerationAlarm readXtceEnumerationAlarm(EnumeratedParameterType enumParamType) throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        EnumerationAlarm alarm = new EnumerationAlarm();
        String v = this.readAttribute("minViolations", this.xmlEvent.asStartElement());
        if (v != null) {
            alarm.setMinViolations(Integer.parseInt(v));
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("EnumerationAlarm")) {
                String label = this.readAttribute("enumerationLabel", this.xmlEvent.asStartElement());
                if (label == null) {
                    label = this.readAttribute("enumerationValue", this.xmlEvent.asStartElement());
                }
                if (label == null) {
                    throw new XMLStreamException(this.fileName + ": error in In definition of " + enumParamType.getName() + "EnumerationAlarm: no enumerationLabel specified", this.xmlEvent.getLocation());
                }
                if (!enumParamType.hasLabel(label)) {
                    throw new XMLStreamException("Reference to invalid enumeration label '" + label + "'");
                }
                AlarmLevels level = this.getAlarmLevel(this.readAttribute("alarmLevel", this.xmlEvent.asStartElement()));
                alarm.addAlarm(label, level);
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return alarm;
    }

    private AlarmLevels getAlarmLevel(String l) throws XMLStreamException {
        try {
            return AlarmLevels.valueOf(l.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Invalid alarm level '" + l + "'; use one of: " + Arrays.toString((Object[])AlarmLevels.values()));
        }
    }

    private ValueEnumerationRange readXtceRangeEnumeration() throws XMLStreamException {
        log.trace(XTCE_RangeEnumeration);
        this.checkStartElementPreconditions();
        boolean isMinInclusive = true;
        boolean isMaxInclusive = true;
        double min = 0.0;
        double max = 0.0;
        String value = this.readAttribute("maxInclusive", this.xmlEvent.asStartElement());
        if (value != null) {
            max = Double.parseDouble(value);
            isMaxInclusive = true;
        }
        if ((value = this.readAttribute("minInclusive", this.xmlEvent.asStartElement())) != null) {
            isMinInclusive = true;
            min = Double.parseDouble(value);
        }
        if ((value = this.readAttribute("maxExclusive", this.xmlEvent.asStartElement())) != null) {
            max = Double.parseDouble(value);
            isMaxInclusive = false;
        }
        if ((value = this.readAttribute("minExclusive", this.xmlEvent.asStartElement())) != null) {
            isMinInclusive = false;
            min = Double.parseDouble(value);
        }
        if ((value = this.readAttribute("label", this.xmlEvent.asStartElement())) == null) {
            log.error("Attribute label is missing.");
            value = "UNDEF";
        }
        ValueEnumerationRange range = new ValueEnumerationRange(min, max, isMinInclusive, isMaxInclusive, value);
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
        } while (!this.isEndElementWithName(XTCE_RangeEnumeration));
        return range;
    }

    private void readXtceEnumeration(EnumeratedParameterType enumParamType) throws XMLStreamException {
        log.trace(XTCE_Enumeration);
        this.checkStartElementPreconditions();
        long longValue = 0L;
        String value = this.readAttribute("value", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException();
        }
        longValue = Long.parseLong(value);
        value = this.readAttribute("label", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException();
        }
        enumParamType.addEnumerationValue(longValue, value);
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
        } while (!this.isEndElementWithName(XTCE_Enumeration));
    }

    private void readXtceParameterSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_PARAMETER_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_PARAMETER)) {
                this.readXtceParameter(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_PARAMETER_REF)) {
                this.readXtceParameterRef();
                continue;
            }
            if (this.isEndElementWithName(XTCE_PARAMETER_SET)) break;
        }
    }

    private XtceNotImplemented readXtceParameterRef() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_PARAMETER_REF);
        return null;
    }

    private Parameter readXtceParameter(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_PARAMETER);
        this.checkStartElementPreconditions();
        Parameter parameter = null;
        StartElement element = this.xmlEvent.asStartElement();
        String value = this.readAttribute("name", element);
        if (value == null) {
            throw new XMLStreamException("Missing name for the parameter");
        }
        parameter = new Parameter(value);
        value = this.readAttribute("parameterTypeRef", element);
        if (value != null) {
            ParameterType ptype = spaceSystem.getParameterType(value);
            if (ptype != null) {
                parameter.setParameterType(ptype);
            } else {
                Parameter p = parameter;
                NameReference nr = new UnresolvedNameReference(value, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
                    p.setParameterType((ParameterType)((Object)nd));
                    return true;
                });
                spaceSystem.addUnresolvedReference(nr);
            }
        } else {
            throw new XMLStreamException("Cannot find parameterTypeRef in element: " + element);
        }
        value = this.readAttribute("shortDescription", element);
        parameter.setShortDescription(value);
        spaceSystem.addParameter(parameter);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                parameter.setAliasSet(this.readXtceAliasSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_PARAMETER_PROPERTIES)) {
                this.readXtceParameterProperties(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                parameter.setLongDescription(this.readXtceLongDescription(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_PARAMETER)) break;
        }
        return parameter;
    }

    private XtceParameterProperties readXtceParameterProperties(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_PARAMETER_PROPERTIES);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_VALIDITY_CONDITION)) {
                this.readMatchCriteria(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_PHYSICAL_ADDRESS_SET)) {
                this.skipXtceSection(XTCE_PHYSICAL_ADDRESS_SET);
                continue;
            }
            if (this.isStartElementWithName(XTCE_SYSTEM_NAME)) {
                this.skipXtceSection(XTCE_SYSTEM_NAME);
                continue;
            }
            if (this.isStartElementWithName(XTCE_TIME_ASSOCIATION)) {
                this.skipXtceSection(XTCE_TIME_ASSOCIATION);
                continue;
            }
            if (this.isEndElementWithName(XTCE_PARAMETER_PROPERTIES)) break;
        }
        return null;
    }

    private String readXtceLongDescription(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StringBuilder longDescr = new StringBuilder();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(XTCE_LONG_DESCRIPTION)) break;
            if (!this.xmlEvent.isCharacters()) {
                throw new IllegalStateException("LongDescription characters or end element expected but instead got " + this.xmlEvent);
            }
            longDescr.append(this.xmlEvent.asCharacters().getData());
        }
        return longDescr.toString();
    }

    private RateInStream readXtceRateInStream(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        String basis = this.readAttribute("basis", this.xmlEvent.asStartElement());
        if (basis != null && !"perSecond".equalsIgnoreCase(basis)) {
            throw new XMLStreamException("Currently unsupported rate in stream basis: " + basis);
        }
        long minInterval = -1L;
        long maxInterval = -1L;
        String v = this.readAttribute("minimumValue", this.xmlEvent.asStartElement());
        if (v != null) {
            maxInterval = (long)(1000.0 / Double.parseDouble(v));
        }
        if ((v = this.readAttribute("maximumValue", this.xmlEvent.asStartElement())) != null) {
            minInterval = (long)(1000.0 / Double.parseDouble(v));
        }
        RateInStream ris = new RateInStream(minInterval, maxInterval);
        this.xmlEvent = this.xmlEventReader.nextEvent();
        if (!this.isEndElementWithName(XTCE_DEFAULT_RATE_IN_STREAM)) {
            throw new IllegalStateException("DefaultRateInStream end element expected");
        }
        return ris;
    }

    private MatchCriteria readMatchCriteria(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("MatchCriteria");
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        MatchCriteria criteria = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_COMPARISON)) {
                criteria = this.readXtceComparison(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_COMPARISON_LIST)) {
                criteria = this.readXtceComparisonList(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_BOOLEAN_EXPRESSION)) {
                this.skipXtceSection(XTCE_BOOLEAN_EXPRESSION);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CUSTOM_ALGORITHM)) {
                this.skipXtceSection(XTCE_CUSTOM_ALGORITHM);
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return criteria;
    }

    private ComparisonList readXtceComparisonList(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_COMPARISON_LIST);
        this.checkStartElementPreconditions();
        ComparisonList list = new ComparisonList();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_COMPARISON)) {
                list.addComparison(this.readXtceComparison(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_COMPARISON_LIST)) break;
        }
        return list;
    }

    private void readXtceContainerSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_CONTAINER_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_SEQUENCE_CONTAINER)) {
                SequenceContainer sc = this.readXtceSequenceContainer(spaceSystem);
                if (this.excludedContainers.contains(sc.getName())) {
                    log.debug("Not adding '" + sc.getName() + "' to the SpaceSystem because excluded by configuration");
                } else {
                    spaceSystem.addSequenceContainer(sc);
                }
                if (sc.getBaseContainer() != null || spaceSystem.getRootSequenceContainer() != null) continue;
                spaceSystem.setRootSequenceContainer(sc);
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTAINER_SET)) break;
        }
    }

    private SequenceContainer readXtceSequenceContainer(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_SEQUENCE_CONTAINER);
        this.checkStartElementPreconditions();
        SequenceContainer seqContainer = null;
        String value = this.readAttribute("name", this.xmlEvent.asStartElement());
        if (value == null) {
            throw new XMLStreamException("Name is missing for container");
        }
        seqContainer = new SequenceContainer(value);
        value = this.readAttribute("shortDescription", this.xmlEvent.asStartElement());
        if (value != null) {
            seqContainer.setShortDescription(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                seqContainer.setAliasSet(this.readXtceAliasSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_ENTRY_LIST)) {
                this.readXtceEntryList(spaceSystem, seqContainer);
                continue;
            }
            if (this.isStartElementWithName(XTCE_BASE_CONTAINER)) {
                this.readXtceBaseContainer(spaceSystem, seqContainer);
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                seqContainer.setLongDescription(this.readXtceLongDescription(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_RATE_IN_STREAM)) {
                seqContainer.setRateInStream(this.readXtceRateInStream(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_SEQUENCE_CONTAINER)) break;
        }
        return seqContainer;
    }

    private void readXtceBaseContainer(SpaceSystem spaceSystem, SequenceContainer seqContainer) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_BASE_CONTAINER);
        this.checkStartElementPreconditions();
        String refName = this.readAttribute("containerRef", this.xmlEvent.asStartElement());
        if (refName != null) {
            if (this.excludedContainers.contains(refName)) {
                log.debug("adding " + seqContainer.getName() + " to the list of the excluded containers because its parent is excluded");
                this.excludedContainers.add(seqContainer.getName());
            } else {
                SequenceContainer baseContainer = spaceSystem.getSequenceContainer(refName);
                if (baseContainer != null) {
                    seqContainer.setBaseContainer(baseContainer);
                } else {
                    SequenceContainer finalsc = seqContainer;
                    NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.SEQUENCE_CONTAINTER).addResolvedAction(nd -> {
                        finalsc.setBaseContainer((SequenceContainer)nd);
                        return true;
                    });
                    spaceSystem.addUnresolvedReference(nr);
                }
            }
        } else {
            throw new XMLStreamException("Reference on base container is missing");
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_RESTRICTION_CRITERIA)) {
                MatchCriteria criteria = this.readMatchCriteria(spaceSystem);
                seqContainer.setRestrictionCriteria(criteria);
                continue;
            }
            if (this.isEndElementWithName(XTCE_BASE_CONTAINER)) break;
        }
    }

    private void readXtceEntryList(SpaceSystem spaceSystem, SequenceContainer seqContainer) throws XMLStreamException {
        log.trace(XTCE_ENTRY_LIST);
        this.checkStartElementPreconditions();
        while (true) {
            SequenceEntry entry;
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_PARAMETER_REF_ENTRY)) {
                entry = this.readXtceParameterRefEntry(spaceSystem);
                entry.setSequenceContainer(seqContainer);
                seqContainer.addEntry(entry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_PARAMETER_SEGMENT_REF_ENTRY)) {
                this.skipXtceSection(XTCE_PARAMETER_SEGMENT_REF_ENTRY);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTAINER_REF_ENTRY)) {
                entry = this.readXtceConteinerRefEntry(spaceSystem);
                entry.setSequenceContainer(seqContainer);
                seqContainer.addEntry(entry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTAINER_SEGMENT_REF_ENTRY)) {
                this.skipXtceSection(XTCE_CONTAINER_SEGMENT_REF_ENTRY);
                continue;
            }
            if (this.isStartElementWithName(XTCE_STREAM_SEGMENT_ENTRY)) {
                this.skipXtceSection(XTCE_STREAM_SEGMENT_ENTRY);
                continue;
            }
            if (this.isStartElementWithName(XTCE_INDIRECT_PARAMETER_REF_ENTRY)) {
                this.skipXtceSection(XTCE_INDIRECT_PARAMETER_REF_ENTRY);
                continue;
            }
            if (this.isStartElementWithName(XTCE_ARRAY_PARAMETER_REF_ENTRY)) {
                this.skipXtceSection(XTCE_ARRAY_PARAMETER_REF_ENTRY);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ENTRY_LIST)) break;
        }
    }

    private SequenceEntry readXtceParameterRefEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_PARAMETER_REF_ENTRY);
        this.checkStartElementPreconditions();
        String refName = this.readAttribute("parameterRef", this.xmlEvent.asStartElement());
        if (refName == null) {
            throw new XMLStreamException("Reference to parameter is missing");
        }
        SequenceEntry.ReferenceLocationType locationType = SequenceEntry.ReferenceLocationType.previousEntry;
        Parameter parameter = spaceSystem.getParameter(refName);
        ParameterEntry parameterEntry = null;
        if (parameter != null) {
            parameterEntry = new ParameterEntry(-1, null, 0, locationType, parameter);
        } else {
            ParameterEntry finalpe = parameterEntry = new ParameterEntry(-1, null, 0, locationType);
            NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
                finalpe.setParameter((Parameter)nd);
                return true;
            });
            spaceSystem.addUnresolvedReference(nr);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) {
                this.readXtceLocationInContainerInBits(parameterEntry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_REPEAT_ENTRY)) {
                Repeat r = this.readXtceRepeatEntry(spaceSystem);
                parameterEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName(XTCE_INCLUDE_CONDITION)) {
                this.skipXtceSection(XTCE_INCLUDE_CONDITION);
                continue;
            }
            if (this.isEndElementWithName(XTCE_PARAMETER_REF_ENTRY)) break;
        }
        return parameterEntry;
    }

    private ContainerEntry readXtceConteinerRefEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_CONTAINER_REF_ENTRY);
        this.checkStartElementPreconditions();
        String refName = this.readAttribute("containerRef", this.xmlEvent.asStartElement());
        if (refName == null) {
            throw new XMLStreamException("Reference to container is missing");
        }
        SequenceEntry.ReferenceLocationType locationType = SequenceEntry.ReferenceLocationType.previousEntry;
        SequenceContainer container = spaceSystem.getSequenceContainer(refName);
        ContainerEntry containerEntry = null;
        if (container != null) {
            containerEntry = new ContainerEntry(-1, null, 0, locationType, container);
        } else {
            ContainerEntry finalce = containerEntry = new ContainerEntry(-1, null, 0, locationType);
            NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.SEQUENCE_CONTAINTER).addResolvedAction(nd -> {
                finalce.setRefContainer((SequenceContainer)nd);
                return true;
            });
            spaceSystem.addUnresolvedReference(nr);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) {
                this.readXtceLocationInContainerInBits(containerEntry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_REPEAT_ENTRY)) {
                Repeat r = this.readXtceRepeatEntry(spaceSystem);
                containerEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName(XTCE_INCLUDE_CONDITION)) {
                this.skipXtceSection(XTCE_INCLUDE_CONDITION);
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTAINER_REF_ENTRY)) break;
        }
        return containerEntry;
    }

    private Repeat readXtceRepeatEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_REPEAT_ENTRY);
        Repeat r = new Repeat();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_COUNT)) {
                r.setCount(this.readXtceIntegerValue(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FromBinaryTransformAlgorithm")) {
                this.skipXtceSection("FromBinaryTransformAlgorithm");
                continue;
            }
            if (this.isStartElementWithName("ToBinaryTransformAlgorithm")) {
                this.skipXtceSection("ToBinaryTransformAlgorithm");
                continue;
            }
            if (this.isEndElementWithName(XTCE_REPEAT_ENTRY)) break;
        }
        return r;
    }

    private IntegerValue readXtceIntegerValue(SpaceSystem spaceSystem) throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        this.checkStartElementPreconditions();
        IntegerValue v = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_FIXED_VALUE)) {
                v = new FixedIntegerValue(this.readIntegerValue());
                continue;
            }
            if (this.isStartElementWithName(XTCE_DYNAMIC_VALUE)) {
                v = this.readDynamicValue(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return v;
    }

    private DynamicIntegerValue readDynamicValue(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_DYNAMIC_VALUE);
        this.checkStartElementPreconditions();
        DynamicIntegerValue v = new DynamicIntegerValue();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_PARAMETER_INSTANCE_REF)) {
                ParameterInstanceRef pir = this.readXtceParameterInstanceRef(spaceSystem);
                v.setParameterInstanceRef(pir);
                continue;
            }
            if (this.isEndElementWithName(XTCE_DYNAMIC_VALUE)) break;
        }
        return v;
    }

    private ParameterInstanceRef readXtceParameterInstanceRef(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_PARAMETER_INSTANCE_REF);
        String paramRef = this.readAttribute("parameterRef", this.xmlEvent.asStartElement());
        if (paramRef == null) {
            throw new XMLStreamException("Reference to parameter is missing");
        }
        ParameterInstanceRef instanceRef = new ParameterInstanceRef(true);
        NameReference nr = new UnresolvedNameReference(paramRef, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
            instanceRef.setParameter((Parameter)nd);
            return true;
        });
        Parameter parameter = spaceSystem.getParameter(paramRef);
        if (parameter != null) {
            if (!nr.resolved(parameter)) {
                spaceSystem.addUnresolvedReference(nr);
            }
        } else {
            spaceSystem.addUnresolvedReference(nr);
        }
        return instanceRef;
    }

    private void readXtceLocationInContainerInBits(SequenceEntry entry) throws XMLStreamException {
        log.trace(XTCE_LOCATION_IN_CONTAINER_IN_BITS);
        this.checkStartElementPreconditions();
        int locationInContainerInBits = 0;
        String value = this.readAttribute("referenceLocation", this.xmlEvent.asStartElement());
        if (value == null) {
            value = "previousEntry";
        }
        if (value.equalsIgnoreCase("previousEntry")) {
            entry.setReferenceLocation(SequenceEntry.ReferenceLocationType.previousEntry);
        } else if (value.equalsIgnoreCase("containerStart")) {
            entry.setReferenceLocation(SequenceEntry.ReferenceLocationType.containerStart);
        } else {
            throw new XMLStreamException("Currently unsupported reference location: " + value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_FIXED_VALUE)) {
                locationInContainerInBits = this.readIntegerValue();
                continue;
            }
            if (this.isStartElementWithName(XTCE_DYNAMIC_VALUE)) {
                this.skipXtceSection(XTCE_DYNAMIC_VALUE);
                continue;
            }
            if (this.isStartElementWithName(XTCE_DISCRETE_LOOKUP_LIST)) {
                this.skipXtceSection(XTCE_DISCRETE_LOOKUP_LIST);
                continue;
            }
            if (this.isEndElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) break;
        }
        entry.setLocationInContainerInBits(locationInContainerInBits);
    }

    private Comparison readXtceComparison(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_COMPARISON);
        this.checkStartElementPreconditions();
        String paramRef = this.readAttribute("parameterRef", this.xmlEvent.asStartElement());
        if (paramRef == null) {
            throw new XMLStreamException("Reference to parameter is missing");
        }
        String value = this.readAttribute("comparisonOperator", this.xmlEvent.asStartElement());
        if (value == null) {
            value = "==";
        }
        OperatorType optype = Comparison.stringToOperator(value);
        String theValue = this.readAttribute("value", this.xmlEvent.asStartElement());
        if (theValue == null) {
            throw new XMLStreamException("Value for comparison is missing");
        }
        boolean useCalibratedValue = true;
        value = this.readAttribute("useCalibratedValue", this.xmlEvent.asStartElement());
        if (value != null) {
            useCalibratedValue = value.equalsIgnoreCase("true");
        }
        ParameterInstanceRef instanceRef = new ParameterInstanceRef(useCalibratedValue);
        Comparison comparison = new Comparison(instanceRef, theValue, optype);
        NameReference nr = new UnresolvedNameReference(paramRef, NameReference.Type.PARAMETER).addResolvedAction(nd -> {
            Parameter p = (Parameter)nd;
            instanceRef.setParameter((Parameter)nd);
            if (p.getParameterType() == null) {
                return false;
            }
            comparison.resolveValueType();
            return true;
        });
        Parameter parameter = spaceSystem.getParameter(paramRef);
        if (parameter != null) {
            if (!nr.resolved(parameter)) {
                spaceSystem.addUnresolvedReference(nr);
            }
        } else {
            spaceSystem.addUnresolvedReference(nr);
        }
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
        } while (!this.isEndElementWithName(XTCE_COMPARISON));
        return comparison;
    }

    private XtceNotImplemented readXtceMessageSet() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_MESSAGE_SET);
        return null;
    }

    private XtceNotImplemented readXtceStreamSet() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_STREAM_SET);
        return null;
    }

    private void readXtceAlgorithmSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_ALGORITHM_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_MATH_ALGORITHM)) {
                this.readXtceMathAlgorithm();
                continue;
            }
            if (this.isStartElementWithName(XTCE_CUSTOM_ALGORITHM)) {
                this.readXtceCustomAlgorithm();
                continue;
            }
            if (this.isEndElementWithName(XTCE_ALGORITHM_SET)) break;
        }
    }

    private XtceNotImplemented readXtceMathAlgorithm() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_MATH_ALGORITHM);
        return null;
    }

    private void readXtceCommandMetaData(SpaceSystem spaceSystem) throws XMLStreamException {
        this.skipXtceSection(XTCE_COMMAND_MEATA_DATA);
    }

    private XtceNotImplemented readXtceCustomAlgorithm() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_CUSTOM_ALGORITHM);
        return null;
    }

    private void addToSkipStatistics(String xtceSectionName) {
        Integer count = this.xtceSkipStatistics.get(xtceSectionName);
        if (count == null) {
            this.xtceSkipStatistics.put(xtceSectionName, new Integer(1));
        } else {
            this.xtceSkipStatistics.put(xtceSectionName, count + 1);
        }
    }

    public void writeStatistics() {
        log.info("------------------");
        log.info("Statistics of skipped elements: ");
        for (Map.Entry<String, Integer> entry : this.xtceSkipStatistics.entrySet()) {
            log.info(">> " + entry.getKey() + ": " + entry.getValue());
        }
        log.info("------------------");
    }

    private void skipXtceSection(String sectionName) throws XMLStreamException, IllegalStateException {
        log.trace(sectionName);
        this.checkStartElementPreconditions();
        this.addToSkipStatistics(sectionName);
        try {
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.isStartElementWithName(sectionName)) {
                    this.skipXtceSection(sectionName);
                    continue;
                }
                if (this.isEndElementWithName(sectionName)) break;
            }
            log.info("Section <" + sectionName + "> skipped");
            return;
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("End of section unreachable: " + sectionName);
        }
    }

    private XMLEventReader initEventReader(String filename) throws FileNotFoundException, XMLStreamException {
        FileInputStream in = new FileInputStream(new File(filename));
        XMLInputFactory factory = XMLInputFactory.newInstance();
        return factory.createXMLEventReader(in);
    }

    private boolean hasAttributes(StartElement element) {
        if (element == null) {
            log.info("element param is null");
            return false;
        }
        return element.getAttributes().hasNext();
    }

    private boolean isStartElementWithName(String localName) {
        return this.xmlEvent.getEventType() == 1 && this.xmlEvent.asStartElement().getName().getLocalPart().equals(localName);
    }

    private boolean isEndElementWithName(String localName) {
        return this.xmlEvent.getEventType() == 2 && this.xmlEvent.asEndElement().getName().getLocalPart().equals(localName);
    }

    private void checkStartElementPreconditions() throws IllegalStateException {
        if (this.xmlEvent == null) {
            throw new IllegalStateException("xmlEvent is null");
        }
        if (this.xmlEvent.getEventType() != 1) {
            throw new IllegalStateException("xmlEvent type is not start element");
        }
    }

    private String readAttribute(String attName, StartElement element) {
        Attribute attribute = element.getAttributeByName(new QName(attName));
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        XtceStaxReader reader = new XtceStaxReader();
        if (args.length == 1) {
            reader.readXmlDocument(args[0]);
            reader.writeStatistics();
        } else {
            System.out.println("Wrong arguments, exactly one argument allowed");
        }
    }

    public void setExcludedContainers(Set<String> excludedContainers) {
        this.excludedContainers = excludedContainers;
    }
}

