/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.AggregateParameterType;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.Member;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.util.AggregateMemberNames;

public class AggregateDataType
extends NameDescription
implements DataType {
    private static final long serialVersionUID = 1L;
    List<Member> memberList = new ArrayList<Member>();
    transient AggregateMemberNames memberNames;

    public AggregateDataType(String name) {
        super(name);
    }

    protected AggregateDataType(AggregateDataType t) {
        super(t);
        this.memberList = t.memberList;
        this.memberNames = t.memberNames;
    }

    public void addMember(Member memberType) {
        this.memberList.add(memberType);
    }

    public void addMembers(List<Member> memberList) {
        this.memberList.addAll(memberList);
    }

    @Override
    public String getTypeAsString() {
        return "aggregate";
    }

    public Member getMember(String name) {
        for (Member m : this.memberList) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public List<Member> getMemberList() {
        return this.memberList;
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.AGGREGATE;
    }

    public Member getMember(String[] path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("path cannot be empty");
        }
        Member m = this.getMember(path[0]);
        for (int i = 1; i < path.length; ++i) {
            if (m == null) {
                return null;
            }
            DataType ptype = m.getType();
            if (!(ptype instanceof AggregateParameterType)) {
                return null;
            }
            m = ((AggregateParameterType)ptype).getMember(path[i]);
            m = this.getMember(path[i]);
        }
        return m;
    }

    public AggregateMemberNames getMemberNames() {
        if (this.memberNames == null) {
            String[] n = (String[])this.memberList.stream().map(m -> m.getName()).toArray(String[]::new);
            this.memberNames = AggregateMemberNames.get(n);
        }
        return this.memberNames;
    }

    public int numMembers() {
        return this.memberList.size();
    }

    public Member getMember(int idx) {
        return this.memberList.get(idx);
    }

    @Override
    public void setInitialValue(String initialValue) {
        throw new UnsupportedOperationException("Cannot set initial value; please send individual initial values for the members");
    }

    @Override
    public Map<String, Object> parseString(String initialValue) {
        try {
            JsonElement je = new JsonParser().parse(initialValue);
            if (je instanceof JsonObject) {
                return this.fromJson((JsonObject)je);
            }
            throw new IllegalArgumentException("Expected JSON object but found " + je.getClass());
        }
        catch (JsonParseException jpe) {
            throw new IllegalArgumentException(jpe.toString());
        }
    }

    private Map<String, Object> fromJson(JsonObject jobj) {
        HashMap<String, Object> r = new HashMap<String, Object>();
        for (Member memb : this.memberList) {
            Object v;
            if (jobj.has(memb.getName())) {
                v = jobj.remove(memb.getName()).toString();
                r.put(memb.getName(), memb.getType().parseString((String)v));
                continue;
            }
            v = memb.getInitialValue();
            if (v == null) {
                v = memb.getType().getInitialValue();
            }
            if (v == null) {
                throw new IllegalArgumentException("No value could be determined for member '" + memb.getName() + "' (its corresponding type does not have an initial value)");
            }
            r.put(memb.getName(), v);
        }
        if (jobj.size() > 0) {
            throw new IllegalArgumentException("Unknown members " + jobj.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList()));
        }
        return r;
    }

    @Override
    public Map<String, Object> getInitialValue() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        for (Member memb : this.memberList) {
            Object v = memb.getInitialValue();
            if (v == null) {
                v = memb.getType().getInitialValue();
            }
            if (v == null) {
                return null;
            }
            r.put(memb.getName(), v);
        }
        return r;
    }
}

