/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.yamcs.xtce.InputParameter;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.OutputParameter;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.TriggerSetType;

public abstract class Algorithm
extends NameDescription {
    private static final long serialVersionUID = 6L;
    private TriggerSetType triggerSet;
    private List<InputParameter> inputList = new ArrayList<InputParameter>();
    private List<OutputParameter> outputList = new ArrayList<OutputParameter>();
    private Scope scope = Scope.GLOBAL;

    Algorithm(Algorithm a) {
        super(a);
        this.triggerSet = a.triggerSet;
        this.inputList = a.inputList;
        this.outputList = a.outputList;
        this.scope = a.scope;
    }

    public Algorithm(String name) {
        super(name);
    }

    public TriggerSetType getTriggerSet() {
        return this.triggerSet;
    }

    public void setTriggerSet(TriggerSetType triggerSet) {
        this.triggerSet = triggerSet;
    }

    public void addInput(InputParameter inputParameter) {
        this.inputList.add(inputParameter);
    }

    public void addOutput(OutputParameter outputParameter) {
        this.outputList.add(outputParameter);
    }

    public List<InputParameter> getInputSet() {
        return this.inputList;
    }

    public List<InputParameter> getInputList() {
        return this.inputList;
    }

    public List<OutputParameter> getOutputSet() {
        return this.outputList;
    }

    public List<OutputParameter> getOutputList() {
        return this.outputList;
    }

    public void setOutputSet(List<OutputParameter> outputSet) {
        this.outputList = outputSet;
    }

    public void setOutputList(List<OutputParameter> outputList) {
        this.outputList = outputList;
    }

    public void setInputSet(List<InputParameter> inputSet) {
        this.setInputList(inputSet);
    }

    public void setInputList(List<InputParameter> inputList) {
        this.inputList = inputList;
    }

    public boolean canProvide(Parameter parameter) {
        for (OutputParameter p : this.outputList) {
            if (p.getParameter() != parameter) continue;
            return true;
        }
        return false;
    }

    public void print(PrintStream out) {
        out.print("Algorithm name: " + this.name);
        if (this.scope != Scope.GLOBAL) {
            out.print(", scope: " + (Object)((Object)this.scope));
        }
        if (this.getAliasSet() != null) {
            out.print(", aliases: " + this.getAliasSet());
        }
        out.println();
        for (InputParameter inputParameter : this.inputList) {
            out.println("\t\tInputParameter " + inputParameter);
        }
        for (OutputParameter outputParameter : this.outputList) {
            out.println("\t\tOutputParameter " + outputParameter);
        }
        out.println("\t\tTriggers " + this.triggerSet);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public static enum Scope {
        GLOBAL,
        COMMAND_VERIFICATION,
        CONTAINER_PROCESSING;

    }
}

