/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.NameDescription;

public class ArrayDataType
extends NameDescription
implements DataType {
    private static final long serialVersionUID = 1L;
    private DataType type;
    private final int numberOfDimensions;
    private Object[] initialValue;
    private int[] dimensions;

    public ArrayDataType(String name, int numberOfDimensions) {
        super(name);
        this.numberOfDimensions = numberOfDimensions;
    }

    public ArrayDataType(ArrayDataType t) {
        super(t);
        this.type = t.type;
        this.numberOfDimensions = t.numberOfDimensions;
        this.initialValue = t.initialValue;
    }

    public void setElementType(DataType type) {
        this.type = type;
    }

    public DataType getElementType() {
        return this.type;
    }

    public int getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    public void setDimensions(int[] dimensions) {
        if (dimensions.length != this.numberOfDimensions) {
            throw new IllegalArgumentException("Number of dimensions does not match: got " + dimensions.length + " but expected " + this.numberOfDimensions);
        }
        this.dimensions = dimensions;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.ARRAY;
    }

    @Override
    public String getTypeAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.getName());
        for (int i = 0; i < this.numberOfDimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    @Override
    public void setInitialValue(String initialValue) {
        this.initialValue = this.parseString(initialValue);
    }

    public Object[] parseString(String v) {
        Object[] r;
        try {
            JsonElement el = new JsonParser().parse(v);
            if (!(el instanceof JsonArray)) {
                throw new IllegalArgumentException("Expected an array but got a : " + el.getClass());
            }
            JsonArray jarr = (JsonArray)el;
            r = new Object[jarr.size()];
            for (int i = 0; i < jarr.size(); ++i) {
                r[i] = this.type.parseString(jarr.get(i).toString());
            }
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Cannot parse string as json: " + e.getMessage());
        }
        return r;
    }

    public Object[] getInitialValue() {
        return this.initialValue;
    }
}

