/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.List;
import org.yamcs.xtce.ArrayParameterType;
import org.yamcs.xtce.IntegerValue;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.SequenceEntry;

public class ArrayParameterEntry
extends SequenceEntry {
    private static final long serialVersionUID = 1L;
    private Parameter parameter;
    List<IntegerValue> dim;

    public void setParameter(Parameter parameter) {
        if (!(parameter.getParameterType() instanceof ArrayParameterType)) {
            throw new IllegalArgumentException("Array parameter type required");
        }
        this.parameter = parameter;
        this.validateSize();
    }

    public void setSize(List<IntegerValue> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Dimension sizes cannot be empty");
        }
        this.dim = list;
        this.validateSize();
    }

    public List<IntegerValue> getSize() {
        return this.dim;
    }

    private void validateSize() {
        if (this.dim != null && this.parameter != null) {
            ArrayParameterType ptype = (ArrayParameterType)this.parameter.getParameterType();
            if (this.dim.size() != ptype.getNumberOfDimensions()) {
                throw new IllegalArgumentException("The numberOfDimensions of the parameter does not match the size length: " + ptype.getNumberOfDimensions() + " vs " + this.dim.size());
            }
        }
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public String toString() {
        return "ArrayParameterEntry position:" + this.getIndex() + ", container:" + this.container.getName() + " locationInContainer:" + this.getLocationInContainerInBits() + " from:" + (Object)((Object)this.getReferenceLocation()) + ", " + this.parameter + (this.getRepeatEntry() != null ? ", repeatEntry: (" + this.getRepeatEntry() + ")" : "");
    }
}

