/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.xtce.AggregateParameterType;
import org.yamcs.xtce.CriteriaEvaluator;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.OperatorType;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.PathElement;
import org.yamcs.xtce.util.DataTypeUtil;

public class Comparison
implements MatchCriteria {
    private static final long serialVersionUID = 9L;
    ParameterInstanceRef instanceRef;
    OperatorType comparisonOperator;
    String stringValue;
    private Object value;
    static transient Logger log = LoggerFactory.getLogger((String)Comparison.class.getName());

    public Comparison(ParameterInstanceRef paraRef, String stringValue, OperatorType op) {
        if (stringValue == null) {
            throw new NullPointerException("stringValue");
        }
        this.instanceRef = paraRef;
        this.stringValue = stringValue;
        this.value = stringValue;
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    public Comparison(ParameterInstanceRef paraRef, int intValue, OperatorType op) {
        this.instanceRef = paraRef;
        this.value = intValue;
        this.stringValue = Integer.toString(intValue);
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    public Comparison(ParameterInstanceRef paraRef, long longValue, OperatorType op) {
        this.instanceRef = paraRef;
        this.value = longValue;
        this.stringValue = Long.toString(longValue);
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    public Comparison(ParameterInstanceRef paraRef, double doubleValue, OperatorType op) {
        this.instanceRef = paraRef;
        this.value = doubleValue;
        this.stringValue = Double.toString(doubleValue);
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    private void checkParaRef(ParameterInstanceRef paraRef) {
        if (paraRef.getInstance() != 0) {
            throw new UnsupportedOperationException("Condition on parameter values from history are not supported");
        }
    }

    @Override
    public boolean isMet(CriteriaEvaluator evaluator) {
        return evaluator.evaluate(this.comparisonOperator, this.instanceRef, this.value);
    }

    public void resolveValueType() {
        boolean useCalibratedValue = this.instanceRef.useCalibratedValue();
        ParameterType ptype = this.instanceRef.getParameter().getParameterType();
        if (ptype instanceof AggregateParameterType) {
            ParameterType ptype1 = (ParameterType)DataTypeUtil.getMemberType(ptype, this.instanceRef.getMemberPath());
            if (ptype1 == null) {
                throw new IllegalArgumentException("reference " + PathElement.pathToString(this.instanceRef.getMemberPath()) + " points to un unexisting member inside the parameter type " + ptype.getName());
            }
            ptype = ptype1;
        }
        try {
            this.value = useCalibratedValue ? ptype.parseString(this.stringValue) : ptype.parseStringForRawValue(this.stringValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot parse value required for comparing with " + this.instanceRef.getParameter().getName() + ": " + e.getMessage(), e);
        }
    }

    public ParameterInstanceRef getParameterRef() {
        return this.instanceRef;
    }

    public OperatorType getComparisonOperator() {
        return this.comparisonOperator;
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        HashSet<Parameter> pset = new HashSet<Parameter>();
        pset.add(this.instanceRef.getParameter());
        return pset;
    }

    public static String operatorToString(OperatorType op) {
        switch (op) {
            case EQUALITY: {
                return "==";
            }
            case INEQUALITY: {
                return "!=";
            }
            case LARGERTHAN: {
                return ">";
            }
            case LARGEROREQUALTHAN: {
                return ">=";
            }
            case SMALLERTHAN: {
                return "<";
            }
            case SMALLEROREQUALTHAN: {
                return "<=";
            }
        }
        return "unknown";
    }

    public static OperatorType stringToOperator(String s) {
        if ("==".equals(s)) {
            return OperatorType.EQUALITY;
        }
        if ("!=".equals(s)) {
            return OperatorType.INEQUALITY;
        }
        if (">".equals(s)) {
            return OperatorType.LARGERTHAN;
        }
        if (">=".equals(s)) {
            return OperatorType.LARGEROREQUALTHAN;
        }
        if ("<".equals(s)) {
            return OperatorType.SMALLERTHAN;
        }
        if ("<=".equals(s)) {
            return OperatorType.SMALLEROREQUALTHAN;
        }
        log.warn("unknown operator type " + s);
        return null;
    }

    public Parameter getParameter() {
        return this.instanceRef.getParameter();
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String toString() {
        if (this.instanceRef.getParameter() != null) {
            return "Comparison: paraName(" + this.instanceRef.getParameter().getName() + (this.instanceRef.useCalibratedValue() ? ".eng" : ".raw") + ")" + Comparison.operatorToString(this.comparisonOperator) + this.stringValue;
        }
        return "Comparison: paraName(unresolved)" + Comparison.operatorToString(this.comparisonOperator) + this.stringValue;
    }
}

