/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.ContextCalibrator;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.NumericDataEncoding;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.StringDataEncoding;

public class FloatDataEncoding
extends DataEncoding
implements NumericDataEncoding {
    private static final long serialVersionUID = 3L;
    Calibrator defaultCalibrator = null;
    private List<ContextCalibrator> contextCalibratorList = null;
    private final Encoding encoding;
    StringDataEncoding stringEncoding = null;

    public FloatDataEncoding(int sizeInBits) {
        this(sizeInBits, ByteOrder.BIG_ENDIAN, Encoding.IEEE754_1985);
    }

    public FloatDataEncoding(int sizeInBits, ByteOrder byteOrder, Encoding encoding) {
        super(sizeInBits, byteOrder);
        FloatDataEncoding.validateEncodingSizeInBits(encoding, sizeInBits);
        this.encoding = encoding;
    }

    private static void validateEncodingSizeInBits(Encoding encoding, int sizeInBits) {
        if (encoding == Encoding.IEEE754_1985) {
            if (sizeInBits != 32 && sizeInBits != 64) {
                throw new IllegalArgumentException("For IEEE754_1985 encoding sizeInBits has to be 32 or 64");
            }
        } else if (encoding == Encoding.MILSTD_1750A && sizeInBits != 32 && sizeInBits != 48) {
            throw new IllegalArgumentException("For MILSTD_1750A encoding sizeInBits has to be 32 or 48");
        }
    }

    public FloatDataEncoding(StringDataEncoding sde) {
        super(sde.getSizeInBits());
        this.encoding = Encoding.STRING;
        this.stringEncoding = sde;
    }

    public FloatDataEncoding(int sizeInBits, Encoding encoding) {
        this(sizeInBits, ByteOrder.BIG_ENDIAN, encoding);
    }

    public FloatDataEncoding(FloatDataEncoding fde) {
        super(fde);
        this.defaultCalibrator = fde.defaultCalibrator;
        this.contextCalibratorList = fde.contextCalibratorList;
        this.encoding = fde.encoding;
        this.stringEncoding = fde.stringEncoding;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public StringDataEncoding getStringDataEncoding() {
        return this.stringEncoding;
    }

    @Override
    public Calibrator getDefaultCalibrator() {
        return this.defaultCalibrator;
    }

    @Override
    public void setDefaultCalibrator(Calibrator calibrator) {
        this.defaultCalibrator = calibrator;
    }

    public String toString() {
        switch (this.getEncoding()) {
            case IEEE754_1985: 
            case MILSTD_1750A: {
                return "FloatDataEncoding(sizeInBits=" + this.sizeInBits + "" + (this.defaultCalibrator == null ? "" : ", defaultCalibrator:" + this.defaultCalibrator) + ")";
            }
            case STRING: {
                return "FloatDataEncoding(StringEncoding: " + this.stringEncoding + (this.defaultCalibrator == null ? "" : ", defaultCalibrator:" + this.defaultCalibrator) + ")";
            }
        }
        return "UnknownFloatEncoding(" + (Object)((Object)this.getEncoding()) + ")";
    }

    @Override
    public Object parseString(String stringValue) {
        switch (this.getEncoding()) {
            case IEEE754_1985: 
            case MILSTD_1750A: {
                if (this.sizeInBits == 32) {
                    return Float.valueOf(Float.parseFloat(stringValue));
                }
                return Double.parseDouble(stringValue);
            }
            case STRING: {
                return stringValue;
            }
        }
        throw new IllegalStateException("Unknown encoding " + (Object)((Object)this.getEncoding()));
    }

    @Override
    public List<ContextCalibrator> getContextCalibratorList() {
        return this.contextCalibratorList;
    }

    @Override
    public void setContextCalibratorList(List<ContextCalibrator> contextCalibratorList) {
        this.contextCalibratorList = contextCalibratorList;
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        if (this.contextCalibratorList != null) {
            HashSet<Parameter> r = new HashSet<Parameter>();
            for (ContextCalibrator cc : this.contextCalibratorList) {
                r.addAll(cc.getContextMatch().getDependentParameters());
            }
            return r;
        }
        return Collections.emptySet();
    }

    @Override
    public FloatDataEncoding copy() {
        return new FloatDataEncoding(this);
    }

    public static enum Encoding {
        IEEE754_1985,
        MILSTD_1750A,
        STRING;

    }
}

