/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.FloatValidRange;
import org.yamcs.xtce.NumericDataType;

public abstract class FloatDataType
extends NumericDataType {
    private static final long serialVersionUID = 1L;
    FloatValidRange validRange;
    int sizeInBits = 32;

    protected FloatDataType(String name) {
        super(name);
    }

    protected FloatDataType(FloatDataType t) {
        super(t);
        this.validRange = t.validRange;
        this.sizeInBits = t.sizeInBits;
    }

    @Override
    public Double getInitialValue() {
        return (Double)this.initialValue;
    }

    public void setInitialValue(double initialValue) {
        this.initialValue = initialValue;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public void setSizeInBits(int sizeInBits) {
        this.sizeInBits = sizeInBits;
    }

    public void setValidRange(FloatValidRange validRange) {
        this.validRange = validRange;
    }

    public FloatValidRange getValidRange() {
        return this.validRange;
    }

    @Override
    public Double parseString(String stringValue) {
        if (this.sizeInBits == 32) {
            return Float.parseFloat(stringValue);
        }
        return Double.parseDouble(stringValue);
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return this.sizeInBits <= 32 ? Yamcs.Value.Type.FLOAT : Yamcs.Value.Type.DOUBLE;
    }

    @Override
    public String getTypeAsString() {
        return "float";
    }
}

