/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.math.BigInteger;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.IntegerValidRange;
import org.yamcs.xtce.NumericDataType;

public abstract class IntegerDataType
extends NumericDataType {
    private static final long serialVersionUID = 1L;
    int sizeInBits = 32;
    protected boolean signed = true;
    IntegerValidRange validRange;

    protected IntegerDataType(String name) {
        super(name);
    }

    protected IntegerDataType(IntegerDataType t) {
        super(t);
        this.sizeInBits = t.sizeInBits;
        this.signed = t.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public void setSizeInBits(int sizeInBits) {
        if (sizeInBits > 64) {
            throw new IllegalArgumentException("Maximum supported size in bits is 64");
        }
        this.sizeInBits = sizeInBits;
    }

    public IntegerValidRange getValidRange() {
        return this.validRange;
    }

    public void setValidRange(IntegerValidRange range) {
        this.validRange = range;
    }

    public void setInitialValue(Long initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public Long getInitialValue() {
        return (Long)this.initialValue;
    }

    @Override
    public Long parseString(String stringValue) {
        String sv = stringValue.replace("_", "");
        if (sv.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        int off = 0;
        char sv0 = sv.charAt(0);
        boolean negative = false;
        int radix = 10;
        if (sv0 == '-') {
            if (!this.signed) {
                throw new NumberFormatException("negative number specified for unsigned integer");
            }
            negative = true;
            ++off;
        } else if (sv0 == '+') {
            ++off;
        }
        if (sv.startsWith("0b", off) || sv.startsWith("0B", off)) {
            off += 2;
            radix = 2;
        } else if (sv.startsWith("0o", off) || sv.startsWith("0O", off)) {
            off += 2;
            radix = 8;
        } else if (sv.startsWith("0x", off) || sv.startsWith("0X", off)) {
            off += 2;
            radix = 16;
        }
        if (sv.startsWith("-", off) || sv.startsWith("+", off)) {
            throw new NumberFormatException("Sign character in the middle of the number");
        }
        BigInteger bn = new BigInteger(sv.substring(off), radix);
        int bs = this.sizeInBits;
        if (this.signed) {
            --bs;
        }
        if (bn.bitLength() > bs) {
            throw new NumberFormatException("Number " + stringValue + " does not fit the bit size (" + this.sizeInBits + (this.signed ? "/signed" : "unsigned") + ")");
        }
        long x = bn.longValue();
        if (negative) {
            x = -x;
        }
        return x;
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return this.sizeInBits > 32 ? (this.signed ? Yamcs.Value.Type.SINT64 : Yamcs.Value.Type.UINT64) : (this.signed ? Yamcs.Value.Type.SINT32 : Yamcs.Value.Type.UINT32);
    }

    @Override
    public String getTypeAsString() {
        return "integer";
    }
}

