/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.List;
import org.yamcs.xtce.MathOperator;
import org.yamcs.xtce.ParameterInstanceRef;

public class MathOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Element> elementList;

    public MathOperation(List<Element> elementList) {
        this.elementList = elementList;
    }

    public List<Element> getElementList() {
        return this.elementList;
    }

    public static class Element
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final ElementType type;
        double value;
        ParameterInstanceRef pref;
        MathOperator operator;

        public Element(double value) {
            this.type = ElementType.ValueOperand;
            this.value = value;
        }

        public Element() {
            this.type = ElementType.ThisParameterOperand;
        }

        public Element(ParameterInstanceRef pref) {
            this.type = ElementType.ParameterInstanceRefOperand;
            this.pref = pref;
        }

        public Element(MathOperator op) {
            this.type = ElementType.Operator;
            this.operator = op;
        }

        public Element(ElementType type) {
            this.type = type;
        }

        public ElementType getType() {
            return this.type;
        }

        public MathOperator getOperator() {
            return this.operator;
        }

        public ParameterInstanceRef getParameterInstanceRef() {
            return this.pref;
        }

        public String toString() {
            switch (this.type) {
                case Operator: {
                    return this.operator.xtceName();
                }
                case ParameterInstanceRefOperand: {
                    return "pref";
                }
                case ThisParameterOperand: {
                    return "this";
                }
                case ValueOperand: {
                    return Double.toString(this.value);
                }
            }
            return "";
        }

        public void setParameterInstance(ParameterInstanceRef pref) {
            this.pref = pref;
        }
    }

    public static enum ElementType {
        ValueOperand,
        ThisParameterOperand,
        ParameterInstanceRefOperand,
        Operator;

    }
}

