/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

public enum MathOperator {
    PLUS("+", 2),
    MINUS("-", 2),
    STAR("*", 2),
    DIV("/", 2),
    MODULO("%", 2),
    POW("^", 2),
    REVPOW("y^x", 2),
    LN("ln", 1),
    LOG("log", 1),
    EXP("e^x", 1),
    INV("1/x", 1),
    FACT("x!", 1),
    TAN("tan", 1),
    COS("cos", 1),
    SIN("sin", 1),
    ATAN("atan", 1),
    ACOS("acos", 1),
    ASIN("asin", 1),
    TANH("tanh", 1),
    COSH("cosh", 1),
    SINH("sinh", 1),
    ATANH("atanh", 1),
    ACOSH("acosh", 1),
    ASINH("asinh", 1),
    SWAP("swap", 2),
    DROP("drop", 1),
    DUP("dup", 1),
    OVER("over", 1),
    ABS("abs", 1);

    private final String xtceName;
    private final int arity;

    private MathOperator(String v, int arity) {
        this.xtceName = v;
        this.arity = arity;
    }

    public int getArity() {
        return this.arity;
    }

    public static MathOperator fromXtceName(String s) {
        for (MathOperator mo : MathOperator.values()) {
            if (!mo.xtceName.equals(s)) continue;
            return mo;
        }
        throw new IllegalArgumentException("Invalid math operator '" + s + "'");
    }

    public String xtceName() {
        return this.xtceName;
    }
}

