/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.xml.XtceAliasSet;

public class NamedDescriptionIndex<T extends NameDescription>
implements Serializable,
Iterable<T> {
    private static final long serialVersionUID = 3L;
    private LinkedHashMap<String, LinkedHashMap<String, T>> aliasIndex = new LinkedHashMap();
    private LinkedHashMap<String, T> index = new LinkedHashMap();

    public void add(T o) {
        XtceAliasSet aliases = ((NameDescription)o).getAliasSet();
        if (aliases != null) {
            for (String ns : aliases.getNamespaces()) {
                LinkedHashMap m = this.aliasIndex.computeIfAbsent(ns, k -> new LinkedHashMap());
                m.put(aliases.getAlias(ns).toUpperCase(), o);
            }
        }
        if (((NameDescription)o).getQualifiedName() != null) {
            this.index.put(((NameDescription)o).getQualifiedName(), o);
        } else {
            this.index.put(((NameDescription)o).getName(), o);
        }
    }

    public T get(String qualifiedName) {
        return (T)((NameDescription)this.index.get(qualifiedName));
    }

    public T get(String nameSpace, String name) {
        Map m = this.aliasIndex.get(nameSpace);
        if (m != null) {
            return (T)((NameDescription)m.get(name.toUpperCase()));
        }
        return null;
    }

    public Collection<T> getObjects() {
        return this.index.values();
    }

    public int size() {
        return this.index.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.index.values().iterator();
    }
}

