/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yamcs.xtce.Container;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.SequenceEntry;

public class SequenceContainer
extends Container {
    private static final long serialVersionUID = 4L;
    List<SequenceEntry> entryList = new ArrayList<SequenceEntry>();
    private boolean useAsArchivePartition;

    public SequenceContainer(String name) {
        super(name);
    }

    @Override
    public SequenceContainer getBaseContainer() {
        return (SequenceContainer)this.baseContainer;
    }

    @Override
    public void setBaseContainer(Container baseContainer) {
        if (!(baseContainer instanceof SequenceContainer)) {
            throw new IllegalArgumentException("The SequenceContainer expects a SequenceContainer as base container");
        }
        this.baseContainer = (SequenceContainer)baseContainer;
    }

    @Override
    public MatchCriteria getRestrictionCriteria() {
        return this.restrictionCriteria;
    }

    @Override
    public void addEntry(SequenceEntry entry) {
        this.entryList.add(entry);
        entry.setIndex(this.entryList.size() - 1);
        entry.setContainer(this);
    }

    public void insertEntry(int idx, SequenceEntry entry) {
        this.entryList.add(idx, entry);
        for (int i = idx; i < this.entryList.size(); ++i) {
            SequenceEntry se = this.entryList.get(i);
            se.setIndex(i);
            se.setContainer(this);
        }
    }

    public void setEntryList(List<SequenceEntry> entryList) {
        this.entryList = entryList;
        for (int i = 0; i < entryList.size(); ++i) {
            SequenceEntry entry = entryList.get(i);
            entry.setIndex(i);
            entry.setContainer(this);
        }
    }

    @Override
    public List<SequenceEntry> getEntryList() {
        return Collections.unmodifiableList(this.entryList);
    }

    public String toString() {
        return "SequenceContainer(name=" + this.name + ")";
    }

    public boolean useAsArchivePartition() {
        return this.useAsArchivePartition;
    }

    public void useAsArchivePartition(boolean useAsArchivePartition) {
        this.useAsArchivePartition = useAsArchivePartition;
    }

    public void print(PrintStream out) {
        out.print("SequenceContainer name: " + this.name + (this.sizeInBits > -1 ? ", sizeInBits: " + this.sizeInBits : ""));
        if (this.getAliasSet() != null) {
            out.print(", aliases: " + this.getAliasSet());
        }
        out.print(", useAsArchivePartition:" + this.useAsArchivePartition);
        if (this.rate != null) {
            out.print(", rateInStream: " + this.rate);
        }
        out.println();
        if (this.baseContainer != null) {
            out.print("\tbaseContainer: '" + this.baseContainer.getQualifiedName());
            out.println("', restrictionCriteria: " + this.restrictionCriteria);
        }
        for (SequenceEntry se : this.getEntryList()) {
            out.println("\t\t" + se);
        }
    }
}

