/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.nio.charset.Charset;
import org.yamcs.xtce.DataEncoding;

public class StringDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 1L;
    private SizeType sizeType;
    private byte terminationChar = 0;
    int sizeInBitsOfSizeTag = 16;
    private String encoding = "UTF-8";

    public StringDataEncoding() {
        super(-1);
    }

    public StringDataEncoding(SizeType sizeType) {
        super(-1);
        this.sizeType = sizeType;
    }

    StringDataEncoding(StringDataEncoding sde) {
        super(sde);
        this.sizeType = sde.sizeType;
        this.terminationChar = sde.terminationChar;
        this.sizeInBitsOfSizeTag = sde.sizeInBitsOfSizeTag;
        this.encoding = sde.encoding;
    }

    public void setSizeType(SizeType sizeType) {
        this.sizeType = sizeType;
    }

    public SizeType getSizeType() {
        return this.sizeType;
    }

    public int getSizeInBitsOfSizeTag() {
        return this.sizeInBitsOfSizeTag;
    }

    public void setSizeInBitsOfSizeTag(int sizeInBits) {
        this.sizeInBitsOfSizeTag = sizeInBits;
    }

    public byte getTerminationChar() {
        return this.terminationChar;
    }

    public void setTerminationChar(byte tc) {
        this.terminationChar = tc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StringDataEncoding size: ");
        sb.append((Object)this.getSizeType()).append("(");
        switch (this.getSizeType()) {
            case FIXED: {
                sb.append("fixedSizeInBits=" + this.getSizeInBits());
                break;
            }
            case LEADING_SIZE: {
                sb.append("sizeInBitsOfSizeTag=" + this.getSizeInBitsOfSizeTag());
                if (this.getSizeInBits() == -1) break;
                sb.append(", sizeInBits=" + this.getSizeInBits());
                break;
            }
            case TERMINATION_CHAR: {
                sb.append("terminationChar=" + this.getTerminationChar());
                if (this.getSizeInBits() == -1) break;
                sb.append(", sizeInBits=" + this.getSizeInBits());
                break;
            }
            case CUSTOM: {
                sb.append(this.getFromBinaryTransformAlgorithm());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Object parseString(String stringValue) {
        return stringValue;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        Charset.forName(encoding);
        this.encoding = encoding;
    }

    @Override
    public StringDataEncoding copy() {
        return new StringDataEncoding(this);
    }

    public static enum SizeType {
        FIXED,
        TERMINATION_CHAR,
        LEADING_SIZE,
        CUSTOM;

    }
}

