/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.ConfigurationException;
import org.yamcs.utils.DoubleRange;
import org.yamcs.utils.StringConverter;
import org.yamcs.xtce.AbsoluteTimeParameterType;
import org.yamcs.xtce.AggregateArgumentType;
import org.yamcs.xtce.AggregateParameterType;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.AlarmRanges;
import org.yamcs.xtce.AlarmType;
import org.yamcs.xtce.Argument;
import org.yamcs.xtce.ArgumentAssignment;
import org.yamcs.xtce.ArgumentEntry;
import org.yamcs.xtce.ArgumentType;
import org.yamcs.xtce.ArrayParameterEntry;
import org.yamcs.xtce.ArrayParameterType;
import org.yamcs.xtce.BinaryArgumentType;
import org.yamcs.xtce.BinaryDataEncoding;
import org.yamcs.xtce.BinaryParameterType;
import org.yamcs.xtce.BooleanArgumentType;
import org.yamcs.xtce.BooleanParameterType;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.CheckWindow;
import org.yamcs.xtce.CommandContainer;
import org.yamcs.xtce.CommandVerifier;
import org.yamcs.xtce.Comparison;
import org.yamcs.xtce.ComparisonList;
import org.yamcs.xtce.Container;
import org.yamcs.xtce.ContainerEntry;
import org.yamcs.xtce.ContextCalibrator;
import org.yamcs.xtce.CustomAlgorithm;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.DataSource;
import org.yamcs.xtce.DynamicIntegerValue;
import org.yamcs.xtce.EnumeratedArgumentType;
import org.yamcs.xtce.EnumeratedDataType;
import org.yamcs.xtce.EnumeratedParameterType;
import org.yamcs.xtce.EnumerationAlarm;
import org.yamcs.xtce.EnumerationContextAlarm;
import org.yamcs.xtce.FixedIntegerValue;
import org.yamcs.xtce.FixedValueEntry;
import org.yamcs.xtce.FloatArgumentType;
import org.yamcs.xtce.FloatDataEncoding;
import org.yamcs.xtce.FloatParameterType;
import org.yamcs.xtce.Header;
import org.yamcs.xtce.InputParameter;
import org.yamcs.xtce.IntegerArgumentType;
import org.yamcs.xtce.IntegerDataEncoding;
import org.yamcs.xtce.IntegerParameterType;
import org.yamcs.xtce.IntegerValue;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.MathAlgorithm;
import org.yamcs.xtce.MathOperation;
import org.yamcs.xtce.MathOperationCalibrator;
import org.yamcs.xtce.MathOperator;
import org.yamcs.xtce.Member;
import org.yamcs.xtce.MetaCommand;
import org.yamcs.xtce.NumericAlarm;
import org.yamcs.xtce.NumericContextAlarm;
import org.yamcs.xtce.OnParameterUpdateTrigger;
import org.yamcs.xtce.OnPeriodicRateTrigger;
import org.yamcs.xtce.OperatorType;
import org.yamcs.xtce.OutputParameter;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterEntry;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.PolynomialCalibrator;
import org.yamcs.xtce.RateInStream;
import org.yamcs.xtce.ReferenceTime;
import org.yamcs.xtce.Repeat;
import org.yamcs.xtce.SequenceContainer;
import org.yamcs.xtce.SequenceEntry;
import org.yamcs.xtce.Significance;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.SplineCalibrator;
import org.yamcs.xtce.SplinePoint;
import org.yamcs.xtce.StringArgumentType;
import org.yamcs.xtce.StringDataEncoding;
import org.yamcs.xtce.StringParameterType;
import org.yamcs.xtce.TimeEpoch;
import org.yamcs.xtce.TriggerSetType;
import org.yamcs.xtce.TriggeredMathOperation;
import org.yamcs.xtce.UnitType;
import org.yamcs.xtce.ValueEnumerationRange;
import org.yamcs.xtce.util.NameReference;
import org.yamcs.xtce.util.UnresolvedNameReference;
import org.yamcs.xtce.util.UnresolvedParameterReference;
import org.yamcs.xtce.xml.XtceAliasSet;
import org.yamcs.xtce.xml.XtceNotImplemented;
import org.yamcs.xtce.xml.XtceParameterProperties;
import org.yamcs.xtce.xml.XtceTerm;

public class XtceStaxReader {
    private static final String XTCE_RelativeTimeParameterType = "RelativeTimeParameterType";
    private static final String XTCE_ARRAY_PARAMETER_TYPE = "ArrayParameterType";
    private static final String XTCE_AGGREGATE_PARAMETER_TYPE = "AggregateParameterType";
    private static final String XTCE_AGGREGATE_ARGUMENT_TYPE = "AggregateArgumentType";
    private static final String XTCE_AuthorSet = "AuthorSet";
    private static final String XTCE_NoteSet = "NoteSet";
    private static final String XTCE_HistorySet = "HistorySet";
    private static final String XTCE_TELEMTRY_META_DATA = "TelemetryMetaData";
    private static final String XTCE_PARAMETER_TYPE_SET = "ParameterTypeSet";
    private static final String XTCE_BOOLEAN_PARAMETER_TYPE = "BooleanParameterType";
    private static final String XTCE_ENUMERATED_PARAMETER_TYPE = "EnumeratedParameterType";
    private static final String XTCE_ENUMERATION_LIST = "EnumerationList";
    private static final String XTCE_ENUMERATION = "Enumeration";
    private static final String XTCE_RANGE_ENUMERATION = "RangeEnumeration";
    private static final String XTCE_STRING_PARAMETER_TYPE = "StringParameterType";
    private static final String XTCE_BINARY_PARAMETER_TYPE = "BinaryParameterType";
    private static final String XTCE_INTEGER_PARAMETER_TYPE = "IntegerParameterType";
    private static final String XTCE_FLOAT_PARAMETER_TYPE = "FloatParameterType";
    private static final String XTCE_SPACE_SYSTEM = "SpaceSystem";
    private static final String XTCE_ALIAS_SET = "AliasSet";
    private static final String XTCE_ALIAS = "Alias";
    private static final String XTCE_LONG_DESCRIPTION = "LongDescription";
    private static final String XTCE_HEADER = "Header";
    private static final String XTCE_ABSOLUTE_TIME_PARAMETER_TYPE = "AbsoluteTimeParameterType";
    private static final String XTCE_PARAMETER_SET = "ParameterSet";
    private static final String XTCE_PARAMETER = "Parameter";
    private static final String XTCE_PARAMETER_REF = "ParameterRef";
    private static final String XTCE_PARAMETER_PROPERTIES = "ParameterProperties";
    private static final String XTCE_VALIDITY_CONDITION = "ValidityCondition";
    private static final String XTCE_COMPARISON_LIST = "ComparisonList";
    private static final String XTCE_COMPARISON = "Comparison";
    private static final String XTCE_BOOLEAN_EXPRESSION = "BooleanExpression";
    private static final String XTCE_CUSTOM_ALGORITHM = "CustomAlgorithm";
    private static final String XTCE_MATH_ALGORITHM = "MathAlgorithm";
    private static final String XTCE_RESTRICTION_CRITERIA = "RestrictionCriteria";
    private static final String XTCE_SYSTEM_NAME = "SystemName";
    private static final String XTCE_PHYSICAL_ADDRESS_SET = "PhysicalAddressSet";
    private static final String XTCE_TIME_ASSOCIATION = "TimeAssociation";
    private static final String XTCE_CONTAINER_SET = "ContainerSet";
    private static final String XTCE_COMMAND_CONTAINER_SET = "CommandContainerSet";
    private static final String XTCE_BASE_CONTAINER = "BaseContainer";
    private static final String XTCE_MESSAGE_SET = "MessageSet";
    private static final String XTCE_STREAM_SET = "StreamSet";
    private static final String XTCE_ALGORITHM_SET = "AlgorithmSet";
    private static final String XTCE_COMMAND_MEATA_DATA = "CommandMetaData";
    private static final String XTCE_SEQUENCE_CONTAINER = "SequenceContainer";
    private static final String XTCE_ENTRY_LIST = "EntryList";
    private static final String XTCE_PARAMETER_REF_ENTRY = "ParameterRefEntry";
    private static final String XTCE_LOCATION_IN_CONTAINER_IN_BITS = "LocationInContainerInBits";
    private static final String XTCE_REPEAT_ENTRY = "RepeatEntry";
    private static final String XTCE_INCLUDE_CONDITION = "IncludeCondition";
    private static final String XTCE_PARAMETER_SEGMENT_REF_ENTRY = "ParameterSegmentRefEntry";
    private static final String XTCE_CONTAINER_REF_ENTRY = "ContainerRefEntry";
    private static final String XTCE_CONTAINER_SEGMENT_REF_ENTRY = "ContainerSegmentRefEntry";
    private static final String XTCE_STREAM_SEGMENT_ENTRY = "StreamSegmentEntry";
    private static final String XTCE_INDIRECT_PARAMETER_REF_ENTRY = "IndirectParameterRefEntry";
    private static final String XTCE_ARRAY_PARAMETER_REF_ENTRY = "ArrayParameterRefEntry";
    private static final String XTCE_UNIT_SET = "UnitSet";
    private static final String XTCE_UNIT = "Unit";
    private static final String XTCE_FLOAT_DATA_ENCODING = "FloatDataEncoding";
    private static final String XTCE_BINARY_DATA_ENCODING = "BinaryDataEncoding";
    private static final String XTCE_SIZE_IN_BITS = "SizeInBits";
    private static final String XTCE_FIXED_VALUE = "FixedValue";
    private static final String XTCE_DYNAMIC_VALUE = "DynamicValue";
    private static final String XTCE_DISCRETE_LOOKUP_LIST = "DiscreteLookupList";
    private static final String XTCE_INTEGER_DATA_ENCODING = "IntegerDataEncoding";
    private static final String XTCE_STRING_DATA_ENCODING = "StringDataEncoding";
    private static final String XTCE_CONTEXT_ALARM_LIST = "ContextAlarmList";
    private static final String XTCE_CONTEXT_ALARM = "ContextAlarm";
    private static final String XTCE_CONTEXT_MATCH = "ContextMatch";
    private static final String XTCE_DEFAULT_CALIBRATOR = "DefaultCalibrator";
    private static final String XTCE_CALIBRATOR = "Calibrator";
    private static final String XTCE_CONTEXT_CALIBRATOR = "ContextCalibrator";
    private static final String XTCE_CONTEXT_CALIBRATOR_LIST = "ContextCalibratorList";
    private static final String XTCE_SPLINE_CALIBRATOR = "SplineCalibrator";
    private static final String XTCE_POLYNOMIAL_CALIBRATOR = "PolynomialCalibrator";
    private static final String XTCE_MATH_OPERATION_CALIBRATOR = "MathOperationCalibrator";
    private static final String XTCE_TERM = "Term";
    private static final String XTCE_SPLINE_POINT = "SplinePoint";
    private static final String XTCE_COUNT = "Count";
    private static final String XTCE_PARAMETER_INSTANCE_REF = "ParameterInstanceRef";
    private static final String XTCE_STATIC_ALARM_RANGES = "StaticAlarmRanges";
    private static final String XTCE_DEFAULT_ALARM = "DefaultAlarm";
    private static final String XTCE_FIXED = "Fixed";
    private static final String XTCE_TERMINATION_CHAR = "TerminationChar";
    private static final String XTCE_LEADING_SIZE = "LeadingSize";
    private static final String XTCE_DEFAULT_RATE_IN_STREAM = "DefaultRateInStream";
    private static final String XTCE_REFERENCE_TIME = "ReferenceTime";
    private static final String XTCE_OFFSET_FROM = "OffsetFrom";
    private static final String XTCE_EPOCH = "Epoch";
    private static final String XTCE_ENCODING = "Encoding";
    private static final String XTCE_ARGUMENT_TYPE_SET = "ArgumentTypeSet";
    private static final String XTCE_META_COMMAND_SET = "MetaCommandSet";
    private static final String XTCE_META_COMMAND = "MetaCommand";
    private static final String XTCE_COMMAND_CONTAINER = "CommandContainer";
    private static final String XTCE_STRING_ARGUMENT_TYPE = "StringArgumentType";
    private static final String XTCE_BINARY_ARGUMENT_TYPE = "BinaryArgumentType";
    private static final String XTCE_INTEGER_ARGUMENT_TYPE = "IntegerArgumentType";
    private static final String XTCE_FLOAT_ARGUMENT_TYPE = "FloatArgumentType";
    private static final String XTCE_BOOLEAN_ARGUMENT_TYPE = "BooleanArgumentType";
    private static final String XTCE_ENUMERATED_ARGUMENT_TYPE = "EnumeratedArgumentType";
    private static final String XTCE_BASE_META_COMMAND = "BaseMetaCommand";
    private static final String XTCE_ARGUMENT_LIST = "ArgumentList";
    private static final String XTCE_ARGUMENT_ASSIGNMENT_LIST = "ArgumentAssignmentList";
    private static final String XTCE_ARGUMENT = "Argument";
    private static final String XTCE_ARGUMENT_REF_ENTRY = "ArgumentRefEntry";
    private static final String XTCE_ARRAY_ARGUMENT_REF_ENTRY = "ArrayArgumentRefEntry";
    private static final String XTCE_FIXED_VALUE_ENTRY = "FixedValueEntry";
    private static final String XTCE_VALUE_OPERAND = "ValueOperand";
    private static final String XTCE_MATH_OPERATION = "MathOperation";
    private static final String XTCE_TRIGGER_SET = "TriggerSet";
    private static final String XTCE_OUTPUT_SET = "OutputSet";
    private static final String XTCE_INPUT_SET = "InputSet";
    private static final String XTCE_INPUT_PARAMETER_INSTANCE_REF = "InputParameterInstanceRef";
    private static final String XTCE_CONSTANT = "Constant";
    private static final String XTCE_OUTPUT_PARAMETER_REF = "OutputParameterRef";
    private static final String XTCE_ALGORITHM_TEXT = "AlgorithmText";
    private static final String XTCE_ARGUMENT_ASSIGNMENT = "ArgumentAssignment";
    private static final String XTCE_MEMBER_LIST = "MemberList";
    private static final String XTCE_MEMBER = "Member";
    private static final String XTCE_DIMENSION_LIST = "DimensionList";
    private static final String XTCE_SIZE = "Size";
    private static final String XTCE_DIMENSION = "Dimension";
    private static final String XTCE_STARTING_INDEX = "StartingIndex";
    private static final String XTCE_ENDING_INDEX = "EndingIndex";
    private static final String XTCE_ANCILLARY_DATA_SET = "AncillaryDataSet";
    private static final String XTCE_VALID_RANGE = "ValidRange";
    private static final String XTCE_BINARY_ENCODING = "BinaryEncoding";
    private static final String XTCE_DEFAULT_SIGNIFICANCE = "DefaultSignificance";
    private static final String XTCE_VERIFIER_SET = "VerifierSet";
    private static final String XTCE_CONTAINER_REF = "ContainerRef";
    private static final String XTCE_CHECK_WINDOW = "CheckWindow";
    private static Logger log = LoggerFactory.getLogger(XtceStaxReader.class);
    private XMLEventReader xmlEventReader = null;
    private XMLEvent xmlEvent = null;
    private Map<String, Integer> xtceSkipStatistics = new HashMap<String, Integer>();
    private Set<String> excludedContainers = new HashSet<String>();
    String fileName;

    public SpaceSystem readXmlDocument(String fileName) throws XMLStreamException, IOException {
        this.fileName = fileName;
        log.info("Parsing XTCE file {}", (Object)fileName);
        this.xmlEventReader = this.initEventReader(fileName);
        this.xmlEvent = null;
        SpaceSystem spaceSystem = null;
        try {
            block9: {
                while (true) {
                    this.xmlEvent = this.xmlEventReader.nextEvent();
                    int eventType = this.xmlEvent.getEventType();
                    if (eventType == 5) continue;
                    if (eventType == 7) {
                        this.onStartDocument((StartDocument)this.xmlEvent);
                    } else if (eventType == 1) {
                        spaceSystem = this.readSpaceSystem();
                    } else {
                        if (eventType == 8) break block9;
                        if (this.isStartElementWithName(XTCE_SPACE_SYSTEM)) {
                            SpaceSystem ss = this.readSpaceSystem();
                            spaceSystem.addSpaceSystem(ss);
                        } else {
                            log.error("Unhandled event: {} ", (Object)this.xmlEvent);
                        }
                    }
                    if (this.xmlEventReader.peek() == null) break;
                }
                this.xmlEvent = null;
                this.xmlEventReader.close();
                this.xmlEventReader = null;
                throw new IllegalStateException("XML file parsing error");
            }
            this.onEndDocument();
            log.info("XTCE file parsing finished, loaded: {} parameters, {} tm containers, {} commands", new Object[]{spaceSystem.getParameterCount(true), spaceSystem.getSequenceContainerCount(true), spaceSystem.getMetaCommandCount(true)});
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new XMLStreamException(e.getMessage(), this.xmlEvent.getLocation());
        }
        return spaceSystem;
    }

    private void onStartDocument(StartDocument start) {
        log.trace("XML version='{} encoding: '{}'", (Object)start.getVersion(), (Object)start.getCharacterEncodingScheme());
    }

    private SpaceSystem readSpaceSystem() throws XMLStreamException {
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        SpaceSystem spaceSystem = new SpaceSystem(value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                spaceSystem.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                XtceAliasSet aliasSet = this.readAliasSet();
                spaceSystem.setAliasSet(aliasSet);
                continue;
            }
            if (this.isStartElementWithName(XTCE_HEADER)) {
                this.readHeader(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_TELEMTRY_META_DATA)) {
                this.readTelemetryMetaData(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_COMMAND_MEATA_DATA)) {
                this.readCommandMetaData(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_SPACE_SYSTEM)) {
                SpaceSystem ss = this.readSpaceSystem();
                spaceSystem.addSpaceSystem(ss);
                continue;
            }
            if (this.isEndElementWithName(XTCE_SPACE_SYSTEM)) {
                return spaceSystem;
            }
            this.logUnknown();
        }
    }

    private void onEndDocument() {
        try {
            log.trace("End of XML document");
            if (this.xmlEventReader != null) {
                this.xmlEventReader.close();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        finally {
            this.xmlEventReader = null;
        }
    }

    private XtceAliasSet readAliasSet() throws XMLStreamException {
        log.trace(XTCE_ALIAS_SET);
        this.checkStartElementPreconditions();
        XtceAliasSet xtceAliasSet = new XtceAliasSet();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS)) {
                this.readAlias(xtceAliasSet);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ALIAS_SET)) {
                return xtceAliasSet;
            }
            this.logUnknown();
        }
    }

    private void readAlias(XtceAliasSet aliasSet) throws XMLStreamException {
        log.trace(XTCE_ALIAS);
        this.checkStartElementPreconditions();
        String nameSpace = this.readMandatoryAttribute("nameSpace", this.xmlEvent.asStartElement());
        nameSpace = nameSpace.intern();
        String alias = this.readMandatoryAttribute("alias", this.xmlEvent.asStartElement());
        aliasSet.addAlias(nameSpace, alias);
        this.xmlEvent = this.xmlEventReader.nextEvent();
        if (!this.isEndElementWithName(XTCE_ALIAS)) {
            throw new IllegalStateException("Alias end element expected");
        }
    }

    private void readHeader(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_HEADER);
        this.checkStartElementPreconditions();
        Header h = new Header();
        String value = this.readAttribute("version", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            h.setVersion(value);
        }
        if ((value = this.readAttribute("date", this.xmlEvent.asStartElement(), null)) != null) {
            h.setDate(value);
        }
        spaceSystem.setHeader(h);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_AuthorSet)) {
                this.skipXtceSection(XTCE_AuthorSet);
                continue;
            }
            if (this.isStartElementWithName(XTCE_NoteSet)) {
                this.skipXtceSection(XTCE_NoteSet);
                continue;
            }
            if (this.isStartElementWithName(XTCE_HistorySet)) {
                this.skipXtceSection(XTCE_HistorySet);
                continue;
            }
            if (this.isEndElementWithName(XTCE_HEADER)) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readTelemetryMetaData(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_TELEMTRY_META_DATA);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_PARAMETER_TYPE_SET)) {
                this.readParameterTypeSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_PARAMETER_SET)) {
                this.readParameterSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTAINER_SET)) {
                this.readContainerSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_MESSAGE_SET)) {
                this.readMessageSet();
                continue;
            }
            if (this.isStartElementWithName(XTCE_STREAM_SET)) {
                this.readStreamSet();
                continue;
            }
            if (this.isStartElementWithName(XTCE_ALGORITHM_SET)) {
                this.readAlgorithmSet(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(XTCE_TELEMTRY_META_DATA)) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readParameterTypeSet(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_PARAMETER_TYPE_SET);
        this.checkStartElementPreconditions();
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            ParameterType parameterType = null;
            if (this.isStartElementWithName(XTCE_BOOLEAN_PARAMETER_TYPE)) {
                parameterType = this.readBooleanParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_ENUMERATED_PARAMETER_TYPE)) {
                parameterType = this.readEnumeratedParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_FLOAT_PARAMETER_TYPE)) {
                parameterType = this.readFloatParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_INTEGER_PARAMETER_TYPE)) {
                parameterType = this.readIntegerParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_BINARY_PARAMETER_TYPE)) {
                parameterType = this.readBinaryParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_STRING_PARAMETER_TYPE)) {
                parameterType = this.readStringParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_RelativeTimeParameterType)) {
                parameterType = this.readRelativeTimeParameterType();
            } else if (this.isStartElementWithName(XTCE_ABSOLUTE_TIME_PARAMETER_TYPE)) {
                parameterType = this.readAbsoluteTimeParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_ARRAY_PARAMETER_TYPE)) {
                parameterType = this.readArrayParameterType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_AGGREGATE_PARAMETER_TYPE)) {
                parameterType = this.readAggregateParameterType(spaceSystem);
            } else {
                this.logUnknown();
            }
            if (parameterType == null) continue;
            spaceSystem.addParameterType(parameterType);
        } while (!this.isEndElementWithName(XTCE_PARAMETER_TYPE_SET));
    }

    private BooleanParameterType readBooleanParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_BOOLEAN_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        BooleanParameterType boolParamType = null;
        String name = this.readMandatoryAttribute("name", element);
        boolParamType = new BooleanParameterType(name);
        boolParamType.setOneStringValue(this.readAttribute("oneStringValue", element, "True"));
        boolParamType.setZeroStringValue(this.readAttribute("zeroStringValue", element, "False"));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                boolParamType.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                boolParamType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                boolParamType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_FLOAT_DATA_ENCODING)) {
                boolParamType.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_BINARY_DATA_ENCODING)) {
                boolParamType.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_STRING_DATA_ENCODING)) {
                boolParamType.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_BOOLEAN_PARAMETER_TYPE)) {
                return boolParamType;
            }
            this.logUnknown();
        }
    }

    private ParameterType readAggregateParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_AGGREGATE_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        AggregateParameterType ptype = null;
        String name = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        ptype = new AggregateParameterType(name);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_MEMBER_LIST)) {
                ptype.addMembers(this.readMemberList(spaceSystem, true));
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                ptype.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isEndElementWithName(XTCE_AGGREGATE_PARAMETER_TYPE)) {
                return ptype;
            }
            this.logUnknown();
        }
    }

    private List<Member> readMemberList(SpaceSystem spaceSystem, boolean paramOrAggreg) throws XMLStreamException {
        log.trace(XTCE_MEMBER_LIST);
        this.checkStartElementPreconditions();
        ArrayList<Member> l = new ArrayList<Member>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_MEMBER)) {
                l.add(this.readXtceMember(spaceSystem, paramOrAggreg));
                continue;
            }
            if (this.isEndElementWithName(XTCE_MEMBER_LIST)) break;
        }
        return l;
    }

    private Member readXtceMember(SpaceSystem spaceSystem, boolean paramOrAggreg) throws XMLStreamException {
        log.trace(XTCE_MEMBER);
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        String name = this.readMandatoryAttribute("name", element);
        Member member = new Member(name);
        member.setShortDescription(this.readAttribute("shortDescription", element, null));
        String typeRef = this.readMandatoryAttribute("typeRef", element);
        if (paramOrAggreg) {
            ParameterType ptype = spaceSystem.getParameterType(typeRef);
            if (ptype != null) {
                member.setDataType(ptype);
            } else {
                NameReference nr = new UnresolvedNameReference(typeRef, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
                    member.setDataType((ParameterType)((Object)nd));
                    return true;
                });
                spaceSystem.addUnresolvedReference(nr);
            }
        } else {
            ArgumentType atype = spaceSystem.getArgumentType(typeRef);
            if (atype != null) {
                member.setDataType(atype);
            } else {
                NameReference nr = new UnresolvedNameReference(typeRef, NameReference.Type.ARGUMENT_TYPE).addResolvedAction(nd -> {
                    member.setDataType((ArgumentType)((Object)nd));
                    return true;
                });
                spaceSystem.addUnresolvedReference(nr);
            }
        }
        return member;
    }

    private ParameterType readArrayParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_ARRAY_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        String name = this.readMandatoryAttribute("name", element);
        String value = this.readMandatoryAttribute("numberOfDimensions", element);
        int dim = Integer.valueOf(value);
        ArrayParameterType ptype = new ArrayParameterType(name, dim);
        String refName = this.readMandatoryAttribute("arrayTypeRef", this.xmlEvent.asStartElement());
        NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
            ptype.setElementType((ParameterType)((Object)nd));
            return true;
        });
        spaceSystem.addUnresolvedReference(nr);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                ptype.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isEndElementWithName(XTCE_ARRAY_PARAMETER_TYPE)) {
                return ptype;
            }
            this.logUnknown();
        }
    }

    private AbsoluteTimeParameterType readAbsoluteTimeParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        AbsoluteTimeParameterType ptype = null;
        log.trace(XTCE_ABSOLUTE_TIME_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        ptype = new AbsoluteTimeParameterType(value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                ptype.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_REFERENCE_TIME)) {
                ptype.setReferenceTime(this.readReferenceTime(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_ENCODING)) {
                this.readEncoding(spaceSystem, ptype);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ABSOLUTE_TIME_PARAMETER_TYPE)) {
                return ptype;
            }
            this.logUnknown();
        }
    }

    private ParameterType readRelativeTimeParameterType() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_RelativeTimeParameterType);
        return null;
    }

    private ReferenceTime readReferenceTime(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_REFERENCE_TIME);
        this.checkStartElementPreconditions();
        ReferenceTime referenceTime = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_OFFSET_FROM)) {
                referenceTime = new ReferenceTime(this.readParameterInstanceRef(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_EPOCH)) {
                referenceTime = new ReferenceTime(this.readEpoch());
                continue;
            }
            if (this.isEndElementWithName(XTCE_REFERENCE_TIME)) {
                return referenceTime;
            }
            this.logUnknown();
        }
    }

    private TimeEpoch readEpoch() throws XMLStreamException {
        log.trace(XTCE_EPOCH);
        String s = this.readStringBetweenTags(XTCE_EPOCH);
        try {
            return new TimeEpoch(TimeEpoch.CommonEpochs.valueOf(s));
        }
        catch (IllegalArgumentException e) {
            return new TimeEpoch(s);
        }
    }

    private void readEncoding(SpaceSystem spaceSystem, AbsoluteTimeParameterType ptype) throws XMLStreamException {
        String scales;
        log.trace(XTCE_ENCODING);
        this.checkStartElementPreconditions();
        String units = this.readAttribute("units", this.xmlEvent.asStartElement(), null);
        if (units != null && !"seconds".equals(units)) {
            throw new XMLStreamException("Unsupported unit types '" + units + "' for time encoding. Only seconds (with scaling) supported", this.xmlEvent.getLocation());
        }
        boolean needsScaling = false;
        double offset = 0.0;
        double scale = 1.0;
        String offsets = this.readAttribute("offset", this.xmlEvent.asStartElement(), null);
        if (offsets != null) {
            needsScaling = true;
            offset = this.parseDouble(offsets);
        }
        if ((scales = this.readAttribute("scale", this.xmlEvent.asStartElement(), null)) != null) {
            needsScaling = true;
            scale = this.parseDouble(scales);
        }
        ptype.setScaling(needsScaling, offset, scale);
        DataEncoding dataEncoding = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                dataEncoding = this.readIntegerDataEncoding(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_FLOAT_DATA_ENCODING)) {
                dataEncoding = this.readFloatDataEncoding(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ENCODING)) {
                ptype.setEncoding(dataEncoding);
                return;
            }
            this.logUnknown();
        }
    }

    private FloatParameterType readFloatParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        FloatParameterType floatParamType = null;
        log.trace(XTCE_FLOAT_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        String value = this.readMandatoryAttribute("name", element);
        floatParamType = new FloatParameterType(value);
        value = this.readAttribute("sizeInBits", element, null);
        if (value != null) {
            int sizeInBits = Integer.parseInt(value);
            if (sizeInBits != 32 && sizeInBits != 64) {
                throw new XMLStreamException("Float encoding " + sizeInBits + " not supported; Only 32 and 64 bits are supported", this.xmlEvent.getLocation());
            }
            floatParamType.setSizeInBits(sizeInBits);
        }
        if ((value = this.readAttribute("initialValue", element, null)) != null) {
            floatParamType.setInitialValue(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                floatParamType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                floatParamType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_FLOAT_DATA_ENCODING)) {
                floatParamType.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_ALARM)) {
                floatParamType.setDefaultAlarm(this.readDefaultAlarm());
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                floatParamType.setContextAlarmList(this.readNumericContextAlarmList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_FLOAT_PARAMETER_TYPE)) break;
        }
        return floatParamType;
    }

    private FloatDataEncoding readFloatDataEncoding(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_FLOAT_DATA_ENCODING);
        this.checkStartElementPreconditions();
        FloatDataEncoding floatDataEncoding = null;
        int sizeInBits = this.readIntAttribute("sizeInBits", this.xmlEvent.asStartElement(), 32);
        String value = this.readAttribute("encoding", this.xmlEvent.asStartElement(), null);
        FloatDataEncoding.Encoding enc = FloatDataEncoding.Encoding.IEEE754_1985;
        if (value != null && !"IEEE754_1985".equalsIgnoreCase(value)) {
            if ("MILSTD_1750A".equalsIgnoreCase(value)) {
                enc = FloatDataEncoding.Encoding.MILSTD_1750A;
            } else {
                this.throwException("Unknown encoding '" + value + "'");
            }
        }
        floatDataEncoding = new FloatDataEncoding(sizeInBits, enc);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_DEFAULT_CALIBRATOR)) {
                floatDataEncoding.setDefaultCalibrator(this.readCalibrator(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_CALIBRATOR_LIST)) {
                floatDataEncoding.setContextCalibratorList(this.readContextCalibratorList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_FLOAT_DATA_ENCODING)) {
                return floatDataEncoding;
            }
            this.logUnknown();
        }
    }

    private List<NumericContextAlarm> readNumericContextAlarmList(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_CONTEXT_ALARM_LIST);
        ArrayList<NumericContextAlarm> contextAlarmList = new ArrayList<NumericContextAlarm>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM)) {
                contextAlarmList.add(this.readNumericContextAlarm(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTEXT_ALARM_LIST)) break;
        }
        return contextAlarmList;
    }

    private NumericAlarm readDefaultAlarm() throws XMLStreamException {
        NumericAlarm na = new NumericAlarm();
        this.readAlarmAttributes(na);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(XTCE_DEFAULT_ALARM)) {
                return na;
            }
            if (this.xmlEvent.getEventType() != 1) continue;
            this.readNumericAlarmElement(na);
        }
    }

    private NumericContextAlarm readNumericContextAlarm(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_CONTEXT_ALARM);
        NumericContextAlarm nca = new NumericContextAlarm();
        this.readAlarmAttributes(nca);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTEXT_MATCH)) {
                nca.setContextMatch(this.readMatchCriteria(spaceSystem));
                continue;
            }
            if (this.xmlEvent.getEventType() == 1) {
                this.readNumericAlarmElement(nca);
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTEXT_ALARM)) {
                return nca;
            }
            this.logUnknown();
        }
    }

    private void readNumericAlarmElement(NumericAlarm numericAlarm) throws XMLStreamException {
        if (this.isStartElementWithName(XTCE_STATIC_ALARM_RANGES)) {
            numericAlarm.setStaticAlarmRanges(this.readAlarmRanges());
        }
    }

    private AlarmRanges readAlarmRanges() throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        AlarmRanges ar = new AlarmRanges();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("WatchRange")) {
                ar.addWatchRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("WarningRange")) {
                ar.addWarningRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("DistressRange")) {
                ar.addDistressRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("CriticalRange")) {
                ar.addCriticalRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("SevereRange")) {
                ar.addSevereRange(this.readFloatRange());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return ar;
    }

    private DoubleRange readFloatRange() throws XMLStreamException {
        StartElement e = this.xmlEvent.asStartElement();
        double minExclusive = this.readDoubleAttribute("minExclusive", e, Double.NaN);
        double maxExclusive = this.readDoubleAttribute("maxExclusive", e, Double.NaN);
        double minInclusive = this.readDoubleAttribute("minInclusive", e, Double.NaN);
        double maxInclusive = this.readDoubleAttribute("maxInclusive", e, Double.NaN);
        return DoubleRange.fromXtceComplement((double)minExclusive, (double)maxExclusive, (double)minInclusive, (double)maxInclusive);
    }

    private void readAlarmAttributes(AlarmType alarm) {
        String value = this.readAttribute("minViolations", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            int minViolations = Integer.parseInt(value);
            alarm.setMinViolations(minViolations);
        }
    }

    private BinaryParameterType readBinaryParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_BINARY_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        BinaryParameterType binaryParamType = null;
        String name = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        binaryParamType = new BinaryParameterType(name);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                binaryParamType.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                binaryParamType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                binaryParamType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_BINARY_DATA_ENCODING)) {
                binaryParamType.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_BINARY_PARAMETER_TYPE)) {
                return binaryParamType;
            }
            this.logUnknown();
        }
    }

    private BinaryDataEncoding readBinaryDataEncoding(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_BINARY_DATA_ENCODING);
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        BinaryDataEncoding binaryDataEncoding = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_SIZE_IN_BITS)) {
                IntegerValue v = this.readIntegerValue(spaceSystem);
                if (v instanceof FixedIntegerValue) {
                    binaryDataEncoding = new BinaryDataEncoding((int)((FixedIntegerValue)v).getValue());
                    continue;
                }
                this.throwException("Only FixedIntegerValue supported for sizeInBits");
                continue;
            }
            if (this.isStartElementWithName("FromBinaryTransformAlgorithm")) {
                this.skipXtceSection("FromBinaryTransformAlgorithm");
                continue;
            }
            if (this.isStartElementWithName("ToBinaryTransformAlgorithm")) {
                this.skipXtceSection("ToBinaryTransformAlgorithm");
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return binaryDataEncoding;
    }

    private void throwException(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg, this.xmlEvent.getLocation());
    }

    private int readIntegerValue() throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        int sizeInBits = 0;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                sizeInBits = this.getIntegerCharacter();
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return sizeInBits;
    }

    int getIntegerCharacter() throws XMLStreamException {
        if (this.xmlEvent.isCharacters()) {
            String value = this.xmlEvent.asCharacters().getData();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new XMLStreamException("Cannot parse integer '" + value + "'", this.xmlEvent.getLocation());
            }
        }
        throw new IllegalStateException();
    }

    private StringParameterType readStringParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_INTEGER_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        StringParameterType stringParamType = null;
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        stringParamType = new StringParameterType(value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                stringParamType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_STRING_DATA_ENCODING)) {
                stringParamType.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                this.skipXtceSection(XTCE_CONTEXT_ALARM_LIST);
                continue;
            }
            if (this.isEndElementWithName(XTCE_STRING_PARAMETER_TYPE)) break;
        }
        return stringParamType;
    }

    private StringDataEncoding readStringDataEncoding(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StringDataEncoding stringDataEncoding = new StringDataEncoding();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_SIZE_IN_BITS)) {
                this.readStringSizeInBits(spaceSystem, stringDataEncoding);
                continue;
            }
            if (this.isEndElementWithName(XTCE_STRING_DATA_ENCODING)) break;
        }
        return stringDataEncoding;
    }

    private void readStringSizeInBits(SpaceSystem spaceSystem, StringDataEncoding stringDataEncoding) throws XMLStreamException {
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_FIXED)) {
                IntegerValue v = this.readIntegerValue(spaceSystem);
                if (v instanceof FixedIntegerValue) {
                    stringDataEncoding.setSizeType(StringDataEncoding.SizeType.FIXED);
                    stringDataEncoding.setSizeInBits((int)((FixedIntegerValue)v).getValue());
                    continue;
                }
                this.throwException("Only FixedValue supported for string size in bits");
                continue;
            }
            if (this.isStartElementWithName(XTCE_TERMINATION_CHAR)) {
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.TERMINATION_CHAR);
                byte[] x = this.readHexBinary();
                if (x == null || x.length != 1) {
                    this.throwException("Terminated strings have to have the size of the termination character of 1");
                }
                stringDataEncoding.setTerminationChar(x[0]);
                continue;
            }
            if (this.isStartElementWithName(XTCE_LEADING_SIZE)) {
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.LEADING_SIZE);
                int sizeInBits = this.readIntAttribute("sizeInBitsOfSizeTag", this.xmlEvent.asStartElement(), 16);
                stringDataEncoding.setSizeInBitsOfSizeTag(sizeInBits);
                continue;
            }
            if (this.isEndElementWithName(XTCE_SIZE_IN_BITS)) break;
        }
    }

    private byte[] readHexBinary() throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        byte[] b = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                b = StringConverter.hexStringToArray((String)this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return b;
    }

    private IntegerParameterType readIntegerParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_INTEGER_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        String value = this.readMandatoryAttribute("name", element);
        IntegerParameterType integerParamType = new IntegerParameterType(value);
        int sizeInBits = this.readIntAttribute("sizeInBits", element, 32);
        integerParamType.setSizeInBits(sizeInBits);
        value = this.readAttribute("signed", element, null);
        if (value != null) {
            boolean signed = Boolean.parseBoolean(value);
            integerParamType.setSigned(signed);
        }
        if ((value = this.readAttribute("initialValue", element, null)) != null) {
            integerParamType.setInitialValue(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                integerParamType.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                integerParamType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                integerParamType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_ALARM)) {
                integerParamType.setDefaultAlarm(this.readDefaultAlarm());
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                integerParamType.setContextAlarmList(this.readNumericContextAlarmList(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_VALID_RANGE)) {
                this.skipXtceSection(XTCE_VALID_RANGE);
                continue;
            }
            if (this.isEndElementWithName(XTCE_INTEGER_PARAMETER_TYPE)) {
                return integerParamType;
            }
            this.logUnknown();
        }
    }

    private IntegerDataEncoding readIntegerDataEncoding(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_INTEGER_DATA_ENCODING);
        this.checkStartElementPreconditions();
        IntegerDataEncoding integerDataEncoding = null;
        int sizeInBits = this.readIntAttribute("sizeInBits", this.xmlEvent.asStartElement(), 8);
        if (sizeInBits < 0 || sizeInBits > 64) {
            throw new XMLStreamException("Invalid sizeInBits " + sizeInBits + " specified for integer data encoding. Supported are between 0 and 64.", this.xmlEvent.getLocation());
        }
        integerDataEncoding = new IntegerDataEncoding(sizeInBits);
        String value = this.readAttribute("encoding", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            if ("unsigned".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.UNSIGNED);
            } else if ("signMagnitude".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.SIGN_MAGNITUDE);
            } else if ("twosComplement".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.TWOS_COMPLEMENT);
            } else if ("twosCompliment".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.TWOS_COMPLEMENT);
            } else if ("onesComplement".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.ONES_COMPLEMENT);
            } else {
                this.throwException("Unsupported encoding '" + value + "'");
            }
        } else {
            integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.UNSIGNED);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_DEFAULT_CALIBRATOR)) {
                integerDataEncoding.setDefaultCalibrator(this.readCalibrator(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_CALIBRATOR_LIST)) {
                integerDataEncoding.setContextCalibratorList(this.readContextCalibratorList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                return integerDataEncoding;
            }
            this.logUnknown();
        }
    }

    private List<ContextCalibrator> readContextCalibratorList(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_CONTEXT_CALIBRATOR_LIST);
        this.checkStartElementPreconditions();
        ArrayList<ContextCalibrator> clist = new ArrayList<ContextCalibrator>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTEXT_CALIBRATOR)) {
                clist.add(this.readContextCalibrator(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTEXT_CALIBRATOR_LIST)) {
                return clist;
            }
            this.logUnknown();
        }
    }

    private Calibrator readCalibrator(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_DEFAULT_CALIBRATOR);
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        Calibrator calibrator = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_POLYNOMIAL_CALIBRATOR)) {
                calibrator = this.readPolynomialCalibrator();
                continue;
            }
            if (this.isStartElementWithName(XTCE_MATH_OPERATION_CALIBRATOR)) {
                calibrator = (Calibrator)((Object)this.readMathOperation(spaceSystem, null));
                continue;
            }
            if (this.isStartElementWithName(XTCE_SPLINE_CALIBRATOR)) {
                calibrator = this.readSplineCalibrator();
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return calibrator;
    }

    private MathOperation readMathOperation(SpaceSystem spaceSystem, MathAlgorithm algo) throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        ArrayList<MathOperation.Element> list = new ArrayList<MathOperation.Element>();
        String refName = null;
        if (algo != null) {
            refName = this.readMandatoryAttribute("outputParameterRef", this.xmlEvent.asStartElement());
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_VALUE_OPERAND)) {
                list.add(new MathOperation.Element(this.readDouble()));
                continue;
            }
            if (this.isStartElementWithName("ThisParameterOperand")) {
                if (algo != null) {
                    throw new XMLStreamException("Cannot reference 'ThisParameter' in algorithms.", this.xmlEvent.getLocation());
                }
                this.skipToTheEnd("ThisParameterOperand");
                list.add(new MathOperation.Element());
                continue;
            }
            if (this.isStartElementWithName("ParameterInstanceRefOperand")) {
                if (algo == null) {
                    throw new XMLStreamException("Cannot reference other paramters in calibrations. Use 'ThisParameterOperand' to refer to the parameter to be calibrated ", this.xmlEvent.getLocation());
                }
                ParameterInstanceRef pref = this.readParameterInstanceRef(spaceSystem);
                algo.addInput(new InputParameter(pref));
                list.add(new MathOperation.Element(pref));
                continue;
            }
            if (this.isStartElementWithName("Operator")) {
                list.add(new MathOperation.Element(this.readMathOperator()));
                continue;
            }
            if (this.isStartElementWithName(XTCE_TRIGGER_SET)) {
                algo.setTriggerSet(this.readTriggerSet(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        if (algo != null) {
            TriggeredMathOperation trigMathOp = new TriggeredMathOperation(list);
            NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.PARAMETER).addResolvedAction(nd -> {
                algo.addOutput(new OutputParameter((Parameter)nd));
                return true;
            });
            spaceSystem.addUnresolvedReference(nr);
            algo.setMathOperation(trigMathOp);
            return trigMathOp;
        }
        return new MathOperationCalibrator(list);
    }

    private TriggerSetType readTriggerSet(SpaceSystem spaceSystem) throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        TriggerSetType triggerSet = new TriggerSetType();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("OnParameterUpdateTrigger")) {
                triggerSet.addOnParameterUpdateTrigger(this.readOnParameterUpdateTrigger(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("OnContainerUpdateTrigger")) {
                throw new XMLStreamException("OnContainerUpdateTrigger not implemented", this.xmlEvent.getLocation());
            }
            if (this.isStartElementWithName("OnPeriodicRateTrigger")) {
                triggerSet.addOnPeriodicRateTrigger(this.readOnPeriodicRateTrigger(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return triggerSet;
    }

    private OnParameterUpdateTrigger readOnParameterUpdateTrigger(SpaceSystem spaceSystem) throws XMLStreamException {
        String refName = null;
        refName = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        OnParameterUpdateTrigger trigger = new OnParameterUpdateTrigger();
        NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.PARAMETER).addResolvedAction(nd -> {
            trigger.setParameter((Parameter)nd);
            return true;
        });
        spaceSystem.addUnresolvedReference(nr);
        return trigger;
    }

    private OnPeriodicRateTrigger readOnPeriodicRateTrigger(SpaceSystem spaceSystem) throws XMLStreamException {
        double d = this.readDoubleAttribute("fireRateInSeconds", this.xmlEvent.asStartElement());
        OnPeriodicRateTrigger trigger = new OnPeriodicRateTrigger((long)(1000.0 * d));
        return trigger;
    }

    private double parseDouble(String value) throws XMLStreamException {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new XMLStreamException("Cannot parse double value '" + value + "'", this.xmlEvent.getLocation());
        }
    }

    private MathOperator readMathOperator() throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        MathOperator m = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                m = MathOperator.fromXtceName(this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return m;
    }

    private ContextCalibrator readContextCalibrator(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_CONTEXT_CALIBRATOR);
        this.checkStartElementPreconditions();
        MatchCriteria context = null;
        Calibrator calibrator = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTEXT_MATCH)) {
                context = this.readMatchCriteria(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CALIBRATOR)) {
                calibrator = this.readCalibrator(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTEXT_CALIBRATOR)) break;
        }
        if (context == null) {
            throw new XMLStreamException("Invalid context calibrator, no context specified");
        }
        if (calibrator == null) {
            throw new XMLStreamException("Invalid context calibrator, no calibrator specified");
        }
        return new ContextCalibrator(context, calibrator);
    }

    private Calibrator readSplineCalibrator() throws XMLStreamException {
        log.trace(XTCE_SPLINE_CALIBRATOR);
        this.checkStartElementPreconditions();
        ArrayList<SplinePoint> splinePoints = new ArrayList<SplinePoint>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_SPLINE_POINT)) {
                splinePoints.add(this.readSplinePoint());
                continue;
            }
            if (this.isEndElementWithName(XTCE_SPLINE_CALIBRATOR)) break;
        }
        return new SplineCalibrator(splinePoints);
    }

    private SplinePoint readSplinePoint() throws XMLStreamException {
        log.trace(XTCE_SPLINE_POINT);
        this.checkStartElementPreconditions();
        double raw = this.readDoubleAttribute("raw", this.xmlEvent.asStartElement());
        double calibrated = this.readDoubleAttribute("calibrated", this.xmlEvent.asStartElement());
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(XTCE_SPLINE_POINT)) {
                return new SplinePoint(raw, calibrated);
            }
            this.logUnknown();
        }
    }

    private Calibrator readPolynomialCalibrator() throws XMLStreamException {
        log.trace(XTCE_POLYNOMIAL_CALIBRATOR);
        this.checkStartElementPreconditions();
        int maxExponent = 0;
        HashMap<Integer, Double> polynome = new HashMap<Integer, Double>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_TERM)) {
                XtceTerm term = this.readTerm();
                if (term.getExponent() > maxExponent) {
                    maxExponent = term.getExponent();
                }
                polynome.put(term.getExponent(), term.getCoefficient());
                continue;
            }
            if (this.isEndElementWithName(XTCE_POLYNOMIAL_CALIBRATOR)) {
                double[] coefficients = new double[maxExponent + 1];
                for (Map.Entry entry : polynome.entrySet()) {
                    coefficients[((Integer)entry.getKey()).intValue()] = (Double)entry.getValue();
                }
                return new PolynomialCalibrator(coefficients);
            }
            this.logUnknown();
        }
    }

    private XtceTerm readTerm() throws XMLStreamException {
        log.trace(XTCE_TERM);
        this.checkStartElementPreconditions();
        int exponent = this.readIntAttribute("exponent", this.xmlEvent.asStartElement());
        double coefficient = this.readDoubleAttribute("coefficient", this.xmlEvent.asStartElement());
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
        } while (!this.isEndElementWithName(XTCE_TERM));
        return new XtceTerm(exponent, coefficient);
    }

    private List<UnitType> readUnitSet() throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_UNIT_SET);
        ArrayList<UnitType> units = new ArrayList<UnitType>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT)) {
                UnitType u = this.readUnit();
                units.add(u);
                continue;
            }
            if (this.isEndElementWithName(XTCE_UNIT_SET)) {
                return units;
            }
            this.logUnknown();
        }
    }

    private Double readDouble() throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        Double d = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                d = this.parseDouble(this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return d;
    }

    private UnitType readUnit() throws XMLStreamException {
        String descriptionValue;
        String factorValue;
        double powerValue;
        block3: {
            log.trace(XTCE_UNIT);
            this.checkStartElementPreconditions();
            StartElement element = this.xmlEvent.asStartElement();
            powerValue = this.readDoubleAttribute("power", element, 1.0);
            factorValue = this.readAttribute("factor", element, null);
            descriptionValue = this.readAttribute("description", element, null);
            do {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.xmlEvent.isCharacters()) break block3;
            } while (!this.isEndElementWithName(XTCE_UNIT));
            return null;
        }
        String unit = this.xmlEvent.asCharacters().getData();
        UnitType unitType = new UnitType(unit);
        unitType.setPower(powerValue);
        if (factorValue != null) {
            unitType.setFactor(factorValue);
        }
        if (descriptionValue != null) {
            unitType.setDescription(descriptionValue);
        }
        return unitType;
    }

    private EnumeratedParameterType readEnumeratedParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        EnumeratedParameterType enumParamType = null;
        log.trace(XTCE_ENUMERATED_PARAMETER_TYPE);
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        enumParamType = new EnumeratedParameterType(value);
        value = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            enumParamType.setInitialValue(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                enumParamType.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                enumParamType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                enumParamType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_FLOAT_DATA_ENCODING)) {
                enumParamType.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_STRING_DATA_ENCODING)) {
                enumParamType.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_BINARY_DATA_ENCODING)) {
                enumParamType.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_ENUMERATION_LIST)) {
                this.readEnumerationList(enumParamType);
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_ALARM)) {
                enumParamType.setDefaultAlarm(this.readEnumerationAlarm(enumParamType));
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                enumParamType.setContextAlarmList(this.readEnumerationContextAlarmList(spaceSystem, enumParamType));
                continue;
            }
            if (this.isEndElementWithName(XTCE_ENUMERATED_PARAMETER_TYPE)) {
                return enumParamType;
            }
            this.logUnknown();
        }
    }

    private List<EnumerationContextAlarm> readEnumerationContextAlarmList(SpaceSystem spaceSystem, EnumeratedParameterType enumParamType) throws XMLStreamException {
        log.trace(XTCE_CONTEXT_ALARM_LIST);
        ArrayList<EnumerationContextAlarm> contextAlarmList = new ArrayList<EnumerationContextAlarm>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM)) {
                contextAlarmList.add(this.readEnumerationContextAlarm(spaceSystem, enumParamType));
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                return contextAlarmList;
            }
            this.logUnknown();
        }
    }

    private EnumerationContextAlarm readEnumerationContextAlarm(SpaceSystem spaceSystem, EnumeratedParameterType enumParamType) throws XMLStreamException {
        log.trace(XTCE_CONTEXT_ALARM);
        EnumerationContextAlarm eca = new EnumerationContextAlarm();
        this.readAlarmAttributes(eca);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTEXT_MATCH)) {
                eca.setContextMatch(this.readMatchCriteria(spaceSystem));
                continue;
            }
            if (this.xmlEvent.getEventType() == 1) {
                EnumerationAlarm a = this.readEnumerationAlarm(enumParamType);
                eca.setAlarmList(a.getAlarmList());
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTEXT_ALARM)) {
                return eca;
            }
            this.logUnknown();
        }
    }

    private void readEnumerationList(EnumeratedDataType enumDataType) throws XMLStreamException {
        log.trace(XTCE_ENUMERATION_LIST);
        this.checkStartElementPreconditions();
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (initialValue != null) {
            enumDataType.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ENUMERATION)) {
                this.readEnumeration(enumDataType);
                continue;
            }
            if (this.isStartElementWithName(XTCE_RANGE_ENUMERATION)) {
                enumDataType.addEnumerationRange(this.readRangeEnumeration());
                continue;
            }
            if (this.isEndElementWithName(XTCE_ENUMERATION_LIST)) {
                return;
            }
            this.logUnknown();
        }
    }

    private EnumerationAlarm readEnumerationAlarm(EnumeratedParameterType enumParamType) throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        EnumerationAlarm alarm = new EnumerationAlarm();
        alarm.setMinViolations(this.readIntAttribute("minViolations", this.xmlEvent.asStartElement(), 1));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("EnumerationAlarm")) {
                String label = this.readAttribute("enumerationLabel", this.xmlEvent.asStartElement(), null);
                if (label == null) {
                    label = this.readAttribute("enumerationValue", this.xmlEvent.asStartElement(), null);
                }
                if (label == null) {
                    throw new XMLStreamException(this.fileName + ": error in In definition of " + enumParamType.getName() + "EnumerationAlarm: no enumerationLabel specified", this.xmlEvent.getLocation());
                }
                if (!enumParamType.hasLabel(label)) {
                    throw new XMLStreamException("Reference to invalid enumeration label '" + label + "'");
                }
                AlarmLevels level = this.getAlarmLevel(this.readAttribute("alarmLevel", this.xmlEvent.asStartElement(), null));
                alarm.addAlarm(label, level);
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return alarm;
    }

    private AlarmLevels getAlarmLevel(String l) throws XMLStreamException {
        try {
            return AlarmLevels.valueOf(l.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Invalid alarm level '" + l + "'; use one of: " + Arrays.toString((Object[])AlarmLevels.values()));
        }
    }

    private ValueEnumerationRange readRangeEnumeration() throws XMLStreamException {
        log.trace(XTCE_RANGE_ENUMERATION);
        this.checkStartElementPreconditions();
        boolean isMinInclusive = true;
        boolean isMaxInclusive = true;
        double min = 0.0;
        double max = 0.0;
        String value = this.readAttribute("maxInclusive", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            max = this.parseDouble(value);
            isMaxInclusive = true;
        }
        if ((value = this.readAttribute("minInclusive", this.xmlEvent.asStartElement(), null)) != null) {
            isMinInclusive = true;
            min = this.parseDouble(value);
        }
        if ((value = this.readAttribute("maxExclusive", this.xmlEvent.asStartElement(), null)) != null) {
            max = this.parseDouble(value);
            isMaxInclusive = false;
        }
        if ((value = this.readAttribute("minExclusive", this.xmlEvent.asStartElement(), null)) != null) {
            isMinInclusive = false;
            min = this.parseDouble(value);
        }
        if ((value = this.readAttribute("label", this.xmlEvent.asStartElement(), null)) == null) {
            log.error("Attribute label is missing.");
            value = "UNDEF";
        }
        ValueEnumerationRange range = new ValueEnumerationRange(min, max, isMinInclusive, isMaxInclusive, value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(XTCE_RANGE_ENUMERATION)) {
                return range;
            }
            this.logUnknown();
        }
    }

    private void readEnumeration(EnumeratedDataType enumDataType) throws XMLStreamException {
        log.trace(XTCE_ENUMERATION);
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        long longValue = this.readLongAttribute("value", element);
        String label = this.readMandatoryAttribute("label", element);
        String maxValue = this.readAttribute("maxValue", element, null);
        if (maxValue != null) {
            double mvd = Double.parseDouble(maxValue);
            enumDataType.addEnumerationRange(new ValueEnumerationRange(longValue, mvd, true, true, label));
        } else {
            enumDataType.addEnumerationValue(longValue, label);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(XTCE_ENUMERATION)) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readParameterSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_PARAMETER_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_PARAMETER)) {
                this.readParameter(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_PARAMETER_REF)) {
                this.skipXtceSection(XTCE_PARAMETER_REF);
                continue;
            }
            if (this.isEndElementWithName(XTCE_PARAMETER_SET)) {
                return;
            }
            this.logUnknown();
        }
    }

    private Parameter readParameter(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_PARAMETER);
        this.checkStartElementPreconditions();
        Parameter parameter = null;
        StartElement element = this.xmlEvent.asStartElement();
        String value = this.readMandatoryAttribute("name", element);
        parameter = new Parameter(value);
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        value = this.readMandatoryAttribute("parameterTypeRef", element);
        ParameterType ptype = spaceSystem.getParameterType(value);
        if (ptype != null) {
            parameter.setParameterType(ptype);
            if (initialValue != null) {
                parameter.setInitialValue(ptype.parseString(initialValue));
            }
        } else {
            Parameter p = parameter;
            NameReference nr = new UnresolvedNameReference(value, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
                ParameterType ptype1 = (ParameterType)((Object)nd);
                p.setParameterType(ptype1);
                if (initialValue != null) {
                    p.setInitialValue(ptype1.parseString(initialValue));
                }
                return true;
            });
            spaceSystem.addUnresolvedReference(nr);
        }
        parameter.setShortDescription(this.readAttribute("shortDescription", element, null));
        spaceSystem.addParameter(parameter);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                parameter.setAliasSet(this.readAliasSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_PARAMETER_PROPERTIES)) {
                this.readParameterProperties(spaceSystem, parameter);
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                parameter.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_ANCILLARY_DATA_SET)) {
                this.skipXtceSection(XTCE_ANCILLARY_DATA_SET);
                continue;
            }
            if (this.isEndElementWithName(XTCE_PARAMETER)) {
                return parameter;
            }
            this.logUnknown();
        }
    }

    private XtceParameterProperties readParameterProperties(SpaceSystem spaceSystem, Parameter p) throws XMLStreamException {
        log.trace(XTCE_PARAMETER_PROPERTIES);
        this.checkStartElementPreconditions();
        String v = this.readAttribute("dataSource", this.xmlEvent.asStartElement(), null);
        if (v != null) {
            try {
                p.setDataSource(DataSource.valueOf(v.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new XMLStreamException("invalid dataSource '" + v + "'. Valid values: " + DataSource.values());
            }
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_VALIDITY_CONDITION)) {
                this.readMatchCriteria(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_PHYSICAL_ADDRESS_SET)) {
                this.skipXtceSection(XTCE_PHYSICAL_ADDRESS_SET);
                continue;
            }
            if (this.isStartElementWithName(XTCE_SYSTEM_NAME)) {
                this.skipXtceSection(XTCE_SYSTEM_NAME);
                continue;
            }
            if (this.isStartElementWithName(XTCE_TIME_ASSOCIATION)) {
                this.skipXtceSection(XTCE_TIME_ASSOCIATION);
                continue;
            }
            if (this.isEndElementWithName(XTCE_PARAMETER_PROPERTIES)) {
                return null;
            }
            this.logUnknown();
        }
    }

    private String readStringBetweenTags(String tagName) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StringBuilder longDescr = new StringBuilder();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(tagName)) break;
            if (!this.xmlEvent.isCharacters()) {
                throw new IllegalStateException(tagName + " characters or end element expected but instead got " + this.xmlEvent);
            }
            longDescr.append(this.xmlEvent.asCharacters().getData());
        }
        return longDescr.toString();
    }

    private RateInStream readRateInStream(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        String basis = this.readAttribute("basis", this.xmlEvent.asStartElement(), null);
        if (basis != null && !"perSecond".equalsIgnoreCase(basis)) {
            throw new XMLStreamException("Currently unsupported rate in stream basis: " + basis);
        }
        long minInterval = -1L;
        long maxInterval = -1L;
        String v = this.readAttribute("minimumValue", this.xmlEvent.asStartElement(), null);
        if (v != null) {
            maxInterval = (long)(1000.0 / this.parseDouble(v));
        }
        if ((v = this.readAttribute("maximumValue", this.xmlEvent.asStartElement(), null)) != null) {
            minInterval = (long)(1000.0 / this.parseDouble(v));
        }
        RateInStream ris = new RateInStream(minInterval, maxInterval);
        this.xmlEvent = this.xmlEventReader.nextEvent();
        if (!this.isEndElementWithName(XTCE_DEFAULT_RATE_IN_STREAM)) {
            throw new IllegalStateException("DefaultRateInStream end element expected");
        }
        return ris;
    }

    private MatchCriteria readMatchCriteria(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("MatchCriteria");
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        MatchCriteria criteria = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_COMPARISON)) {
                criteria = this.readComparison(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_COMPARISON_LIST)) {
                criteria = this.readComparisonList(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_BOOLEAN_EXPRESSION)) {
                this.skipXtceSection(XTCE_BOOLEAN_EXPRESSION);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CUSTOM_ALGORITHM)) {
                this.skipXtceSection(XTCE_CUSTOM_ALGORITHM);
                continue;
            }
            if (this.isEndElementWithName(tag)) {
                return criteria;
            }
            this.logUnknown();
        }
    }

    private ComparisonList readComparisonList(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_COMPARISON_LIST);
        this.checkStartElementPreconditions();
        ComparisonList list = new ComparisonList();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_COMPARISON)) {
                list.addComparison(this.readComparison(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_COMPARISON_LIST)) {
                return list;
            }
            this.logUnknown();
        }
    }

    private void readContainerSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_CONTAINER_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_SEQUENCE_CONTAINER)) {
                SequenceContainer sc = this.readSequenceContainer(spaceSystem);
                if (this.excludedContainers.contains(sc.getName())) {
                    log.debug("Not adding '" + sc.getName() + "' to the SpaceSystem because excluded by configuration");
                } else {
                    spaceSystem.addSequenceContainer(sc);
                }
                if (sc.getBaseContainer() != null || spaceSystem.getRootSequenceContainer() != null) continue;
                spaceSystem.setRootSequenceContainer(sc);
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTAINER_SET)) {
                return;
            }
            this.logUnknown();
        }
    }

    private SequenceContainer readSequenceContainer(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_SEQUENCE_CONTAINER);
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        SequenceContainer seqContainer = new SequenceContainer(value);
        seqContainer.setShortDescription(this.readAttribute("shortDescription", this.xmlEvent.asStartElement(), null));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                seqContainer.setAliasSet(this.readAliasSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_ENTRY_LIST)) {
                this.readEntryList(spaceSystem, seqContainer, null);
                continue;
            }
            if (this.isStartElementWithName(XTCE_BASE_CONTAINER)) {
                this.readBaseContainer(spaceSystem, seqContainer);
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                seqContainer.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_RATE_IN_STREAM)) {
                seqContainer.setRateInStream(this.readRateInStream(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_BINARY_ENCODING)) {
                BinaryDataEncoding bde = this.readBinaryDataEncoding(spaceSystem);
                seqContainer.setSizeInBits(bde.getSizeInBits());
                continue;
            }
            if (this.isEndElementWithName(XTCE_SEQUENCE_CONTAINER)) {
                return seqContainer;
            }
            this.logUnknown();
        }
    }

    private void readBaseContainer(SpaceSystem spaceSystem, SequenceContainer seqContainer) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_BASE_CONTAINER);
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("containerRef", this.xmlEvent.asStartElement());
        if (this.excludedContainers.contains(refName)) {
            log.debug("adding " + seqContainer.getName() + " to the list of the excluded containers because its parent is excluded");
            this.excludedContainers.add(seqContainer.getName());
        } else {
            SequenceContainer baseContainer = spaceSystem.getSequenceContainer(refName);
            if (baseContainer != null) {
                seqContainer.setBaseContainer(baseContainer);
            } else {
                SequenceContainer finalsc = seqContainer;
                NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.SEQUENCE_CONTAINER).addResolvedAction(nd -> {
                    finalsc.setBaseContainer((SequenceContainer)nd);
                    return true;
                });
                spaceSystem.addUnresolvedReference(nr);
            }
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_RESTRICTION_CRITERIA)) {
                MatchCriteria criteria = this.readMatchCriteria(spaceSystem);
                seqContainer.setRestrictionCriteria(criteria);
                continue;
            }
            if (this.isEndElementWithName(XTCE_BASE_CONTAINER)) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readEntryList(SpaceSystem spaceSystem, Container container, MetaCommand mc) throws XMLStreamException {
        log.trace(XTCE_ENTRY_LIST);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            SequenceEntry entry = null;
            if (this.isStartElementWithName(XTCE_PARAMETER_REF_ENTRY)) {
                entry = this.readParameterRefEntry(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_PARAMETER_SEGMENT_REF_ENTRY)) {
                this.skipXtceSection(XTCE_PARAMETER_SEGMENT_REF_ENTRY);
            } else if (this.isStartElementWithName(XTCE_CONTAINER_REF_ENTRY)) {
                entry = this.readContainerRefEntry(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_CONTAINER_SEGMENT_REF_ENTRY)) {
                this.skipXtceSection(XTCE_CONTAINER_SEGMENT_REF_ENTRY);
            } else if (this.isStartElementWithName(XTCE_STREAM_SEGMENT_ENTRY)) {
                this.skipXtceSection(XTCE_STREAM_SEGMENT_ENTRY);
            } else if (this.isStartElementWithName(XTCE_INDIRECT_PARAMETER_REF_ENTRY)) {
                this.skipXtceSection(XTCE_INDIRECT_PARAMETER_REF_ENTRY);
            } else if (this.isStartElementWithName(XTCE_ARRAY_PARAMETER_REF_ENTRY)) {
                entry = this.readArrayParameterRefEntry(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_ARGUMENT_REF_ENTRY)) {
                entry = this.readArgumentRefEntry(spaceSystem, mc);
            } else if (this.isStartElementWithName(XTCE_ARRAY_ARGUMENT_REF_ENTRY)) {
                this.skipXtceSection(XTCE_ARRAY_ARGUMENT_REF_ENTRY);
            } else if (this.isStartElementWithName(XTCE_FIXED_VALUE_ENTRY)) {
                entry = this.readFixedValueEntry(spaceSystem);
            } else {
                if (this.isEndElementWithName(XTCE_ENTRY_LIST)) {
                    return;
                }
                this.logUnknown();
            }
            if (entry == null) continue;
            container.addEntry(entry);
        }
    }

    private SequenceEntry readArrayParameterRefEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        ArrayParameterEntry parameterEntry;
        log.trace(XTCE_ARRAY_PARAMETER_REF_ENTRY);
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        ArrayParameterEntry finalpe = parameterEntry = new ArrayParameterEntry();
        NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.PARAMETER).addResolvedAction(nd -> {
            finalpe.setParameter((Parameter)nd);
            return true;
        });
        spaceSystem.addUnresolvedReference(nr);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) {
                this.readLocationInContainerInBits(parameterEntry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_REPEAT_ENTRY)) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                parameterEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName(XTCE_INCLUDE_CONDITION)) {
                parameterEntry.setIncludeCondition(this.readMatchCriteria(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_DIMENSION_LIST)) {
                parameterEntry.setSize(this.readDimensionList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_ARRAY_PARAMETER_REF_ENTRY)) {
                return parameterEntry;
            }
            this.logUnknown();
        }
    }

    private List<IntegerValue> readDimensionList(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_DIMENSION_LIST);
        this.checkStartElementPreconditions();
        ArrayList<IntegerValue> l = new ArrayList<IntegerValue>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_DIMENSION)) {
                l.add(this.readDimension(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_SIZE)) {
                l.add(this.readIntegerValue(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_DIMENSION_LIST)) {
                return l;
            }
            this.logUnknown();
        }
    }

    private IntegerValue readDimension(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_DIMENSION);
        this.checkStartElementPreconditions();
        IntegerValue endingIndex = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_STARTING_INDEX)) {
                this.skipXtceSection(XTCE_STARTING_INDEX);
                continue;
            }
            if (this.isStartElementWithName(XTCE_ENDING_INDEX)) {
                endingIndex = this.readIntegerValue(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(XTCE_DIMENSION)) {
                if (endingIndex != null && endingIndex instanceof FixedIntegerValue) {
                    long v = ((FixedIntegerValue)endingIndex).getValue();
                    return new FixedIntegerValue(v + 1L);
                }
                throw new XMLStreamException("Dimension indexes must be specified with FixedValue");
            }
            this.logUnknown();
        }
    }

    private SequenceEntry readParameterRefEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        ParameterEntry parameterEntry;
        log.trace(XTCE_PARAMETER_REF_ENTRY);
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        SequenceEntry.ReferenceLocationType locationType = SequenceEntry.ReferenceLocationType.previousEntry;
        ParameterEntry finalpe = parameterEntry = new ParameterEntry(0, locationType);
        NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.PARAMETER).addResolvedAction(nd -> {
            finalpe.setParameter((Parameter)nd);
            return true;
        });
        spaceSystem.addUnresolvedReference(nr);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) {
                this.readLocationInContainerInBits(parameterEntry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_REPEAT_ENTRY)) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                parameterEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName(XTCE_INCLUDE_CONDITION)) {
                parameterEntry.setIncludeCondition(this.readMatchCriteria(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_PARAMETER_REF_ENTRY)) {
                return parameterEntry;
            }
            this.logUnknown();
        }
    }

    private ContainerEntry readContainerRefEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_CONTAINER_REF_ENTRY);
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("containerRef", this.xmlEvent.asStartElement());
        SequenceEntry.ReferenceLocationType locationType = SequenceEntry.ReferenceLocationType.previousEntry;
        SequenceContainer container = spaceSystem.getSequenceContainer(refName);
        ContainerEntry containerEntry = null;
        if (container != null) {
            containerEntry = new ContainerEntry(0, locationType, container);
        } else {
            ContainerEntry finalce = containerEntry = new ContainerEntry(0, locationType);
            NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.SEQUENCE_CONTAINER).addResolvedAction(nd -> {
                finalce.setRefContainer((SequenceContainer)nd);
                return true;
            });
            spaceSystem.addUnresolvedReference(nr);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) {
                this.readLocationInContainerInBits(containerEntry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_REPEAT_ENTRY)) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                containerEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName(XTCE_INCLUDE_CONDITION)) {
                containerEntry.setIncludeCondition(this.readMatchCriteria(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_CONTAINER_REF_ENTRY)) {
                return containerEntry;
            }
            this.logUnknown();
        }
    }

    private Repeat readRepeatEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_REPEAT_ENTRY);
        Repeat r = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_COUNT)) {
                r = new Repeat(this.readIntegerValue(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_REPEAT_ENTRY)) break;
        }
        return r;
    }

    private IntegerValue readIntegerValue(SpaceSystem spaceSystem) throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        this.checkStartElementPreconditions();
        IntegerValue v = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_FIXED_VALUE)) {
                v = new FixedIntegerValue(this.readIntegerValue());
                continue;
            }
            if (this.isStartElementWithName(XTCE_DYNAMIC_VALUE)) {
                v = this.readDynamicValue(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(tag)) {
                return v;
            }
            this.logUnknown();
        }
    }

    private DynamicIntegerValue readDynamicValue(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_DYNAMIC_VALUE);
        this.checkStartElementPreconditions();
        DynamicIntegerValue v = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_PARAMETER_INSTANCE_REF)) {
                v = new DynamicIntegerValue(this.readParameterInstanceRef(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_DYNAMIC_VALUE)) {
                if (v == null) {
                    throw new XMLStreamException("No ParameterInstanceRef section found");
                }
                return v;
            }
            this.logUnknown();
        }
    }

    private ParameterInstanceRef readParameterInstanceRef(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_PARAMETER_INSTANCE_REF);
        String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        ParameterInstanceRef instanceRef = new ParameterInstanceRef(true);
        NameReference nr = new UnresolvedNameReference(paramRef, NameReference.Type.PARAMETER).addResolvedAction(nd -> {
            instanceRef.setParameter((Parameter)nd);
            return true;
        });
        Parameter parameter = spaceSystem.getParameter(paramRef);
        if (parameter != null) {
            if (!nr.resolved(parameter)) {
                spaceSystem.addUnresolvedReference(nr);
            }
        } else {
            spaceSystem.addUnresolvedReference(nr);
        }
        return instanceRef;
    }

    private void readLocationInContainerInBits(SequenceEntry entry) throws XMLStreamException {
        SequenceEntry.ReferenceLocationType location;
        log.trace(XTCE_LOCATION_IN_CONTAINER_IN_BITS);
        this.checkStartElementPreconditions();
        int locationInContainerInBits = 0;
        String value = this.readAttribute("referenceLocation", this.xmlEvent.asStartElement(), "previousEntry");
        if (value.equalsIgnoreCase("previousEntry")) {
            location = SequenceEntry.ReferenceLocationType.previousEntry;
        } else if (value.equalsIgnoreCase("containerStart")) {
            location = SequenceEntry.ReferenceLocationType.containerStart;
        } else {
            throw new XMLStreamException("Currently unsupported reference location: " + value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_FIXED_VALUE)) {
                locationInContainerInBits = this.readIntegerValue();
                continue;
            }
            if (this.isStartElementWithName(XTCE_DYNAMIC_VALUE)) {
                this.skipXtceSection(XTCE_DYNAMIC_VALUE);
                continue;
            }
            if (this.isStartElementWithName(XTCE_DISCRETE_LOOKUP_LIST)) {
                this.skipXtceSection(XTCE_DISCRETE_LOOKUP_LIST);
                continue;
            }
            if (this.isEndElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) {
                entry.setLocation(location, locationInContainerInBits);
                return;
            }
            this.logUnknown();
        }
    }

    private Comparison readComparison(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_COMPARISON);
        this.checkStartElementPreconditions();
        String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        String value = this.readAttribute("comparisonOperator", this.xmlEvent.asStartElement(), null);
        if (value == null) {
            value = "==";
        }
        OperatorType optype = Comparison.stringToOperator(value);
        String theValue = this.readMandatoryAttribute("value", this.xmlEvent.asStartElement());
        boolean useCalibratedValue = this.readBooleanAttribute("useCalibratedValue", this.xmlEvent.asStartElement(), true);
        ParameterInstanceRef instanceRef = new ParameterInstanceRef(useCalibratedValue);
        Comparison comparison = new Comparison(instanceRef, theValue, optype);
        UnresolvedParameterReference nr = new UnresolvedParameterReference(paramRef).addResolvedAction((nd, path) -> {
            Parameter p = (Parameter)nd;
            instanceRef.setParameter((Parameter)nd);
            instanceRef.setMemberPath(path);
            if (p.getParameterType() == null) {
                return false;
            }
            comparison.resolveValueType();
            return true;
        });
        Parameter parameter = spaceSystem.getParameter(paramRef);
        if (parameter != null) {
            if (!nr.resolved(parameter)) {
                spaceSystem.addUnresolvedReference(nr);
            }
        } else {
            spaceSystem.addUnresolvedReference(nr);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(XTCE_COMPARISON)) {
                return comparison;
            }
            this.logUnknown();
        }
    }

    private XtceNotImplemented readMessageSet() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_MESSAGE_SET);
        return null;
    }

    private XtceNotImplemented readStreamSet() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection(XTCE_STREAM_SET);
        return null;
    }

    private void readAlgorithmSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_ALGORITHM_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_MATH_ALGORITHM)) {
                this.readMathAlgorithm(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CUSTOM_ALGORITHM)) {
                this.readCustomAlgorithm(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ALGORITHM_SET)) break;
        }
    }

    private void readMathAlgorithm(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        MathAlgorithm algo = new MathAlgorithm(value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_MATH_OPERATION)) {
                this.readMathOperation(spaceSystem, algo);
                continue;
            }
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                algo.setAliasSet(this.readAliasSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                algo.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isEndElementWithName(XTCE_MATH_ALGORITHM)) {
                spaceSystem.addAlgorithm(algo);
                return;
            }
            this.logUnknown();
        }
    }

    private void readCommandMetaData(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_COMMAND_MEATA_DATA);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_PARAMETER_TYPE_SET)) {
                this.readParameterTypeSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_PARAMETER_SET)) {
                this.readParameterSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_ARGUMENT_TYPE_SET)) {
                this.readArgumentTypeSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_META_COMMAND_SET)) {
                this.readMetaCommandSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_COMMAND_CONTAINER_SET)) {
                this.readCommandContainerSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName(XTCE_MESSAGE_SET)) {
                this.readMessageSet();
                continue;
            }
            if (this.isStartElementWithName(XTCE_ALGORITHM_SET)) {
                this.readAlgorithmSet(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(XTCE_COMMAND_MEATA_DATA)) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readArgumentTypeSet(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_ARGUMENT_TYPE_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            ArgumentType argumentType = null;
            if (this.isStartElementWithName(XTCE_BOOLEAN_ARGUMENT_TYPE)) {
                argumentType = this.readBooleanArgumentType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_ENUMERATED_ARGUMENT_TYPE)) {
                argumentType = this.readEnumeratedArgumentType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_FLOAT_ARGUMENT_TYPE)) {
                argumentType = this.readFloatArgumentType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_INTEGER_ARGUMENT_TYPE)) {
                argumentType = this.readIntegerArgumentType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_BINARY_ARGUMENT_TYPE)) {
                argumentType = this.readBinaryArgumentType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_STRING_ARGUMENT_TYPE)) {
                argumentType = this.readStringArgumentType(spaceSystem);
            } else if (this.isStartElementWithName(XTCE_AGGREGATE_ARGUMENT_TYPE)) {
                argumentType = this.readAggregateArgumentType(spaceSystem);
            }
            if (argumentType != null) {
                spaceSystem.addArgumentType(argumentType);
            }
            if (this.isEndElementWithName(XTCE_ARGUMENT_TYPE_SET)) {
                return;
            }
            this.logUnknown();
        }
    }

    private BooleanArgumentType readBooleanArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_BOOLEAN_ARGUMENT_TYPE);
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        String name = this.readMandatoryAttribute("name", element);
        BooleanArgumentType boolArgType = new BooleanArgumentType(name);
        boolArgType.setOneStringValue(this.readAttribute("oneStringValue", element, "True"));
        boolArgType.setZeroStringValue(this.readAttribute("zeroStringValue", element, "False"));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                boolArgType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                boolArgType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_BOOLEAN_ARGUMENT_TYPE)) {
                return boolArgType;
            }
            this.logUnknown();
        }
    }

    private FloatArgumentType readFloatArgumentType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        FloatArgumentType floatArgType = null;
        log.trace(XTCE_FLOAT_ARGUMENT_TYPE);
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        floatArgType = new FloatArgumentType(value);
        value = this.readAttribute("sizeInBits", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            int sizeInBits = Integer.parseInt(value);
            if (sizeInBits != 32 && sizeInBits != 64) {
                throw new XMLStreamException("Float encoding " + sizeInBits + " not supported; Only 32 and 64 bits are supported", this.xmlEvent.getLocation());
            }
            floatArgType.setSizeInBits(sizeInBits);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                floatArgType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                floatArgType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_FLOAT_DATA_ENCODING)) {
                floatArgType.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_FLOAT_ARGUMENT_TYPE)) {
                return floatArgType;
            }
            this.logUnknown();
        }
    }

    private EnumeratedArgumentType readEnumeratedArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        EnumeratedArgumentType enumArgType = null;
        log.trace(XTCE_ENUMERATED_ARGUMENT_TYPE);
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        enumArgType = new EnumeratedArgumentType(value);
        value = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            enumArgType.setInitialValue(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                enumArgType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                enumArgType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_ENUMERATION_LIST)) {
                this.readEnumerationList(enumArgType);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ENUMERATED_ARGUMENT_TYPE)) break;
        }
        return enumArgType;
    }

    private ArgumentType readAggregateArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_AGGREGATE_ARGUMENT_TYPE);
        this.checkStartElementPreconditions();
        AggregateArgumentType argtype = null;
        String name = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        argtype = new AggregateArgumentType(name);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_MEMBER_LIST)) {
                argtype.addMembers(this.readMemberList(spaceSystem, false));
                continue;
            }
            if (this.isEndElementWithName(XTCE_AGGREGATE_ARGUMENT_TYPE)) {
                return argtype;
            }
            this.logUnknown();
        }
    }

    private IntegerArgumentType readIntegerArgumentType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_INTEGER_ARGUMENT_TYPE);
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        IntegerArgumentType integerArgType = new IntegerArgumentType(value);
        int sizeInBits = this.readIntAttribute("sizeInBits", this.xmlEvent.asStartElement(), 32);
        integerArgType.setSizeInBits(sizeInBits);
        value = this.readAttribute("signed", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            boolean signed = Boolean.parseBoolean(value);
            integerArgType.setSigned(signed);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                integerArgType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                integerArgType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_INTEGER_ARGUMENT_TYPE)) break;
        }
        return integerArgType;
    }

    private BinaryArgumentType readBinaryArgumentType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_BINARY_ARGUMENT_TYPE);
        this.checkStartElementPreconditions();
        BinaryArgumentType binaryParamType = null;
        String name = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        binaryParamType = new BinaryArgumentType(name);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                binaryParamType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_INTEGER_DATA_ENCODING)) {
                binaryParamType.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_BINARY_DATA_ENCODING)) {
                binaryParamType.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_BINARY_ARGUMENT_TYPE)) {
                return binaryParamType;
            }
            this.logUnknown();
        }
    }

    private StringArgumentType readStringArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_STRING_ARGUMENT_TYPE);
        this.checkStartElementPreconditions();
        StringArgumentType stringParamType = null;
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        stringParamType = new StringArgumentType(value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_UNIT_SET)) {
                stringParamType.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_STRING_DATA_ENCODING)) {
                stringParamType.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONTEXT_ALARM_LIST)) {
                this.skipXtceSection(XTCE_CONTEXT_ALARM_LIST);
                continue;
            }
            if (this.isEndElementWithName(XTCE_STRING_ARGUMENT_TYPE)) {
                return stringParamType;
            }
            this.logUnknown();
        }
    }

    private void readCommandContainerSet(SpaceSystem spaceSystem) throws XMLStreamException {
        this.skipXtceSection(XTCE_COMMAND_CONTAINER_SET);
    }

    private void readMetaCommandSet(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_META_COMMAND_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_META_COMMAND)) {
                MetaCommand mc = this.readMetaCommand(spaceSystem);
                if (this.excludedContainers.contains(mc.getName())) {
                    log.debug("Not adding '{}' to the SpaceSystem because excluded by configuration", (Object)mc.getName());
                    continue;
                }
                spaceSystem.addMetaCommand(mc);
                continue;
            }
            if (this.isEndElementWithName(XTCE_META_COMMAND_SET)) break;
        }
    }

    private MetaCommand readMetaCommand(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_META_COMMAND);
        this.checkStartElementPreconditions();
        MetaCommand mc = null;
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        mc = new MetaCommand(value);
        value = this.readAttribute("shortDescription", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            mc.setShortDescription(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                mc.setAliasSet(this.readAliasSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                mc.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_BASE_META_COMMAND)) {
                this.readBaseMetaCommand(spaceSystem, mc);
                continue;
            }
            if (this.isStartElementWithName(XTCE_COMMAND_CONTAINER)) {
                CommandContainer cc = this.readCommandContainer(spaceSystem, mc);
                mc.setCommandContainer(cc);
                spaceSystem.addCommandContainer(cc);
                continue;
            }
            if (this.isStartElementWithName(XTCE_ARGUMENT_LIST)) {
                this.readArgumentList(spaceSystem, mc);
                continue;
            }
            if (this.isStartElementWithName(XTCE_VERIFIER_SET)) {
                this.readVerifierSet(spaceSystem, mc);
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_SIGNIFICANCE)) {
                mc.setDefaultSignificance(this.readSignificance(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(XTCE_META_COMMAND)) {
                return mc;
            }
            this.logUnknown();
        }
    }

    private void readBaseMetaCommand(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace(XTCE_BASE_META_COMMAND);
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("metaCommandRef", this.xmlEvent.asStartElement());
        if (refName != null) {
            if (this.excludedContainers.contains(refName)) {
                log.debug("adding {} to the list of the excluded containers because its parent is excluded", (Object)mc.getName());
                this.excludedContainers.add(mc.getName());
            } else {
                MetaCommand baseContainer = spaceSystem.getMetaCommand(refName);
                if (baseContainer != null) {
                    mc.setBaseMetaCommand(baseContainer);
                } else {
                    MetaCommand finalmc = mc;
                    NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.META_COMMAND).addResolvedAction(nd -> {
                        finalmc.setBaseMetaCommand((MetaCommand)nd);
                        return true;
                    });
                    spaceSystem.addUnresolvedReference(nr);
                }
            }
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.isStartElementWithName(XTCE_ARGUMENT_ASSIGNMENT_LIST)) {
                    this.readArgumentAssignmentList(spaceSystem, mc);
                    continue;
                }
                if (this.isEndElementWithName(XTCE_BASE_META_COMMAND)) {
                    return;
                }
                this.logUnknown();
            }
        }
    }

    private void readArgumentAssignmentList(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace(XTCE_ARGUMENT_ASSIGNMENT_LIST);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ARGUMENT_ASSIGNMENT)) {
                ArgumentAssignment aa = this.readArgumentAssignment(spaceSystem);
                mc.addArgumentAssignment(aa);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ARGUMENT_ASSIGNMENT_LIST)) break;
        }
    }

    private ArgumentAssignment readArgumentAssignment(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_ARGUMENT_ASSIGNMENT);
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        String argumentName = this.readMandatoryAttribute("argumentName", element);
        String argumentValue = this.readMandatoryAttribute("argumentValue", element);
        this.skipToTheEnd(XTCE_ARGUMENT_ASSIGNMENT);
        return new ArgumentAssignment(argumentName, argumentValue);
    }

    private void readArgumentList(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace(XTCE_ARGUMENT_LIST);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ARGUMENT)) {
                Argument arg = this.readArgument(spaceSystem);
                mc.addArgument(arg);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ARGUMENT_LIST)) break;
        }
    }

    private Argument readArgument(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_ARGUMENT);
        this.checkStartElementPreconditions();
        Argument arg = null;
        StartElement element = this.xmlEvent.asStartElement();
        String name = this.readMandatoryAttribute("name", element);
        arg = new Argument(name);
        String initialValue = this.readAttribute("initialValue", element, null);
        arg.setInitialValue(initialValue);
        String argumentTypeRef = this.readMandatoryAttribute("argumentTypeRef", element);
        ArgumentType ptype = spaceSystem.getArgumentType(argumentTypeRef);
        if (ptype != null) {
            arg.setArgumentType(ptype);
        } else {
            Argument a = arg;
            NameReference nr = new UnresolvedNameReference(argumentTypeRef, NameReference.Type.ARGUMENT_TYPE).addResolvedAction(nd -> {
                a.setArgumentType((ArgumentType)((Object)nd));
                return true;
            });
            spaceSystem.addUnresolvedReference(nr);
        }
        arg.setShortDescription(this.readAttribute("shortDescription", element, null));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                arg.setAliasSet(this.readAliasSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                arg.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isEndElementWithName(XTCE_ARGUMENT)) {
                return arg;
            }
            this.logUnknown();
        }
    }

    private void readVerifierSet(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace(XTCE_VERIFIER_SET);
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isStartElement() && this.xmlEvent.asStartElement().getName().getLocalPart().endsWith("Verifier")) {
                CommandVerifier cmdVerifier = this.readVerifier(spaceSystem);
                if (cmdVerifier == null) continue;
                mc.addVerifier(cmdVerifier);
                continue;
            }
            if (this.isEndElementWithName(XTCE_VERIFIER_SET)) {
                return;
            }
            this.logUnknown();
        }
    }

    private CommandVerifier readVerifier(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        String stage = tag.substring(0, tag.length() - 8);
        CommandVerifier cmdVerifier = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_CONTAINER_REF)) {
                cmdVerifier = new CommandVerifier(CommandVerifier.Type.CONTAINER, stage);
                this.readContainerRef(spaceSystem, cmdVerifier);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CUSTOM_ALGORITHM)) {
                cmdVerifier = new CommandVerifier(CommandVerifier.Type.ALGORITHM, stage);
                continue;
            }
            if (this.isStartElementWithName(XTCE_CHECK_WINDOW)) {
                CheckWindow cw = this.readCheckWindow(spaceSystem);
                if (cmdVerifier == null) continue;
                cmdVerifier.setCheckWindow(cw);
                continue;
            }
            if (this.isEndElementWithName(tag)) {
                return cmdVerifier;
            }
            this.logUnknown();
        }
    }

    private void readContainerRef(SpaceSystem spaceSystem, CommandVerifier cmdVerifier) throws XMLStreamException {
        String refName = this.readMandatoryAttribute("containerRef", this.xmlEvent.asStartElement());
        SequenceContainer container = spaceSystem.getSequenceContainer(refName);
        if (container != null) {
            cmdVerifier.setContainerRef(container);
        } else {
            NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.SEQUENCE_CONTAINER).addResolvedAction(nd -> {
                cmdVerifier.setContainerRef((SequenceContainer)nd);
                return true;
            });
            spaceSystem.addUnresolvedReference(nr);
        }
        this.xmlEvent = this.xmlEventReader.nextEvent();
        if (!this.isEndElementWithName(XTCE_CONTAINER_REF)) {
            throw new IllegalStateException("ContainerRef end element expected");
        }
    }

    private CheckWindow readCheckWindow(SpaceSystem spaceSystem) throws XMLStreamException {
        CheckWindow.TimeWindowIsRelativeToType timeWindowIsRelativeTo;
        StartElement element = this.xmlEvent.asStartElement();
        String v = this.readAttribute("timeToStartChecking", element, null);
        long timeToStartChecking = v == null ? -1L : this.parseDuration(v);
        long timeToStopChecking = this.parseDuration(this.readMandatoryAttribute("timeToStopChecking", element));
        v = this.readAttribute("timeWindowIsRelativeTo", element, "timeLastVerifierPassed");
        if ("timeLastVerifierPassed".equals(v)) {
            timeWindowIsRelativeTo = CheckWindow.TimeWindowIsRelativeToType.LastVerifier;
        } else if ("commandRelease".equals(v)) {
            timeWindowIsRelativeTo = CheckWindow.TimeWindowIsRelativeToType.CommandRelease;
        } else {
            throw new XMLStreamException("Invalid value '" + v + "' for timeWindowIsRelativeTo");
        }
        return new CheckWindow(timeToStartChecking, timeToStopChecking, timeWindowIsRelativeTo);
    }

    long parseDuration(String v) {
        Duration d;
        try {
            d = DatatypeFactory.newInstance().newDuration(v);
        }
        catch (DatatypeConfigurationException e) {
            throw new ConfigurationException((Exception)e);
        }
        return d.getTimeInMillis(new Date());
    }

    private CommandContainer readCommandContainer(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace(XTCE_COMMAND_CONTAINER);
        this.checkStartElementPreconditions();
        CommandContainer cmdContainer = null;
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        cmdContainer = new CommandContainer(value);
        value = this.readAttribute("shortDescription", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            cmdContainer.setShortDescription(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALIAS_SET)) {
                cmdContainer.setAliasSet(this.readAliasSet());
                continue;
            }
            if (this.isStartElementWithName(XTCE_ENTRY_LIST)) {
                this.readEntryList(spaceSystem, cmdContainer, mc);
                continue;
            }
            if (this.isStartElementWithName(XTCE_BASE_CONTAINER)) {
                this.readBaseContainer(spaceSystem, cmdContainer);
                continue;
            }
            if (this.isStartElementWithName(XTCE_LONG_DESCRIPTION)) {
                cmdContainer.setLongDescription(this.readStringBetweenTags(XTCE_LONG_DESCRIPTION));
                continue;
            }
            if (this.isStartElementWithName(XTCE_DEFAULT_RATE_IN_STREAM)) {
                cmdContainer.setRateInStream(this.readRateInStream(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_BINARY_ENCODING)) {
                BinaryDataEncoding bde = this.readBinaryDataEncoding(spaceSystem);
                cmdContainer.setSizeInBits(bde.getSizeInBits());
                continue;
            }
            if (this.isEndElementWithName(XTCE_COMMAND_CONTAINER)) {
                return cmdContainer;
            }
            this.logUnknown();
        }
    }

    private void readBaseContainer(SpaceSystem spaceSystem, CommandContainer mcContainer) throws IllegalStateException, XMLStreamException {
        log.trace(XTCE_BASE_CONTAINER);
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("containerRef", this.xmlEvent.asStartElement());
        if (this.excludedContainers.contains(refName)) {
            log.debug("adding {} to the list of the excluded containers because its parent is excluded", (Object)mcContainer.getName());
            this.excludedContainers.add(mcContainer.getName());
        } else {
            CommandContainer baseContainer = spaceSystem.getCommandContainer(refName);
            if (baseContainer != null) {
                mcContainer.setBaseContainer(baseContainer);
            } else {
                CommandContainer finalsc = mcContainer;
                NameReference nr = new UnresolvedNameReference(refName, NameReference.Type.COMMAND_CONTAINER).addResolvedAction(nd -> {
                    finalsc.setBaseContainer((Container)nd);
                    return true;
                });
                spaceSystem.addUnresolvedReference(nr);
            }
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_RESTRICTION_CRITERIA)) {
                MatchCriteria criteria = this.readMatchCriteria(spaceSystem);
                mcContainer.setRestrictionCriteria(criteria);
                continue;
            }
            if (this.isEndElementWithName(XTCE_BASE_CONTAINER)) {
                return;
            }
            this.logUnknown();
        }
    }

    private ArgumentEntry readArgumentRefEntry(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace(XTCE_ARGUMENT_REF_ENTRY);
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("argumentRef", this.xmlEvent.asStartElement());
        Argument arg = mc.getArgument(refName);
        ArgumentEntry argumentEntry = null;
        if (arg == null) {
            throw new XMLStreamException("Undefined argument reference '" + refName + "'", this.xmlEvent.getLocation());
        }
        argumentEntry = new ArgumentEntry(arg);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) {
                this.readLocationInContainerInBits(argumentEntry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_REPEAT_ENTRY)) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                argumentEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName(XTCE_INCLUDE_CONDITION)) {
                this.skipXtceSection(XTCE_INCLUDE_CONDITION);
                continue;
            }
            if (this.isEndElementWithName(XTCE_ARGUMENT_REF_ENTRY)) {
                return argumentEntry;
            }
            this.logUnknown();
        }
    }

    private FixedValueEntry readFixedValueEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_FIXED_VALUE_ENTRY);
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String name = this.readAttribute("name", startElement, null);
        String value = this.readMandatoryAttribute("binaryValue", startElement);
        byte[] binaryValue = StringConverter.hexStringToArray((String)value);
        int sizeInBits = this.readIntAttribute("sizeInBits", startElement, binaryValue.length * 8);
        FixedValueEntry fixedValueEntry = new FixedValueEntry(name, binaryValue, sizeInBits);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_LOCATION_IN_CONTAINER_IN_BITS)) {
                this.readLocationInContainerInBits(fixedValueEntry);
                continue;
            }
            if (this.isStartElementWithName(XTCE_REPEAT_ENTRY)) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                fixedValueEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName(XTCE_INCLUDE_CONDITION)) {
                this.skipXtceSection(XTCE_INCLUDE_CONDITION);
                continue;
            }
            if (this.isEndElementWithName(XTCE_FIXED_VALUE_ENTRY)) {
                return fixedValueEntry;
            }
            this.logUnknown();
        }
    }

    private void readCustomAlgorithm(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String tag = startElement.getName().getLocalPart();
        String name = this.readMandatoryAttribute("name", startElement);
        CustomAlgorithm algo = new CustomAlgorithm(name);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_ALGORITHM_TEXT)) {
                this.readCustomAlgorithmText(algo);
                continue;
            }
            if (this.isStartElementWithName(XTCE_TRIGGER_SET)) {
                algo.setTriggerSet(this.readTriggerSet(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_OUTPUT_SET)) {
                algo.setOutputSet(this.readOutputSet(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_INPUT_SET)) {
                algo.setInputSet(this.readInputSet(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(tag)) {
                spaceSystem.addAlgorithm(algo);
                return;
            }
            this.logUnknown();
        }
    }

    private void readCustomAlgorithmText(CustomAlgorithm algo) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String tag = startElement.getName().getLocalPart();
        String language = this.readMandatoryAttribute("language", startElement);
        algo.setLanguage(language);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                algo.setAlgorithmText(this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
    }

    private List<InputParameter> readInputSet(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String tag = startElement.getName().getLocalPart();
        ArrayList<InputParameter> result = new ArrayList<InputParameter>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_INPUT_PARAMETER_INSTANCE_REF)) {
                result.add(this.readInputParameterInstanceRef(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName(XTCE_CONSTANT)) {
                throw new XMLStreamException("Constant input parameters not supported", this.xmlEvent.getLocation());
            }
            if (this.isEndElementWithName(tag)) {
                return result;
            }
            this.logUnknown();
        }
    }

    private InputParameter readInputParameterInstanceRef(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_INPUT_PARAMETER_INSTANCE_REF);
        String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        String inputName = this.readAttribute("inputName", this.xmlEvent.asStartElement(), null);
        ParameterInstanceRef instanceRef = new ParameterInstanceRef(true);
        NameReference nr = new UnresolvedNameReference(paramRef, NameReference.Type.PARAMETER).addResolvedAction(nd -> {
            instanceRef.setParameter((Parameter)nd);
            return true;
        });
        spaceSystem.addUnresolvedReference(nr);
        return new InputParameter(instanceRef, inputName);
    }

    private List<OutputParameter> readOutputSet(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String tag = startElement.getName().getLocalPart();
        ArrayList<OutputParameter> result = new ArrayList<OutputParameter>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName(XTCE_OUTPUT_PARAMETER_REF)) {
                result.add(this.readOutputParameterRef(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return result;
    }

    private Significance readSignificance(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        Significance.Levels clevel;
        log.trace(XTCE_DEFAULT_SIGNIFICANCE);
        this.checkStartElementPreconditions();
        String reason = this.readAttribute("reasonForWarning", this.xmlEvent.asStartElement(), null);
        String conseq = this.readMandatoryAttribute("consequenceLevel", this.xmlEvent.asStartElement());
        try {
            clevel = Significance.Levels.valueOf(conseq.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Invalid consiequence level '" + conseq + "'; allowed values: " + Arrays.toString((Object[])Significance.Levels.values()));
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(XTCE_DEFAULT_SIGNIFICANCE)) {
                return new Significance(clevel, reason);
            }
            this.logUnknown();
        }
    }

    private OutputParameter readOutputParameterRef(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace(XTCE_OUTPUT_PARAMETER_REF);
        String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        String outputName = this.readAttribute("outputName", this.xmlEvent.asStartElement(), null);
        OutputParameter outp = new OutputParameter();
        outp.setOutputName(outputName);
        NameReference nr = new UnresolvedNameReference(paramRef, NameReference.Type.PARAMETER).addResolvedAction(nd -> {
            outp.setParameter((Parameter)nd);
            return true;
        });
        spaceSystem.addUnresolvedReference(nr);
        return outp;
    }

    private void addToSkipStatistics(String xtceSectionName) {
        Integer count = this.xtceSkipStatistics.get(xtceSectionName);
        if (count == null) {
            this.xtceSkipStatistics.put(xtceSectionName, new Integer(1));
        } else {
            this.xtceSkipStatistics.put(xtceSectionName, count + 1);
        }
    }

    public void writeStatistics() {
        log.info("------------------");
        log.info("Statistics of skipped elements: ");
        for (Map.Entry<String, Integer> entry : this.xtceSkipStatistics.entrySet()) {
            log.info(">> {} : {} ", (Object)entry.getKey(), (Object)entry.getValue());
        }
        log.info("------------------");
    }

    private void skipXtceSection(String sectionName) throws XMLStreamException {
        log.trace(sectionName);
        this.checkStartElementPreconditions();
        this.addToSkipStatistics(sectionName);
        try {
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.isStartElementWithName(sectionName)) {
                    this.skipXtceSection(sectionName);
                    continue;
                }
                if (this.isEndElementWithName(sectionName)) break;
            }
            log.info("Section <{}> skipped", (Object)sectionName);
            return;
        }
        catch (NoSuchElementException e) {
            throw new XMLStreamException("End of section unreachable: " + sectionName, this.xmlEvent.getLocation());
        }
    }

    private void skipToTheEnd(String sectionName) throws XMLStreamException, IllegalStateException {
        log.trace(sectionName);
        this.checkStartElementPreconditions();
        try {
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.isStartElementWithName(sectionName)) {
                    this.skipXtceSection(sectionName);
                    continue;
                }
                if (this.isEndElementWithName(sectionName)) break;
            }
            return;
        }
        catch (NoSuchElementException e) {
            throw new XMLStreamException("End of section unreachable: " + sectionName, this.xmlEvent.getLocation());
        }
    }

    private XMLEventReader initEventReader(String filename) throws FileNotFoundException, XMLStreamException {
        FileInputStream in = new FileInputStream(new File(filename));
        XMLInputFactory factory = XMLInputFactory.newInstance();
        return factory.createXMLEventReader(in);
    }

    private boolean hasAttributes(StartElement element) {
        if (element == null) {
            log.info("element param is null");
            return false;
        }
        return element.getAttributes().hasNext();
    }

    private boolean isStartElementWithName(String localName) {
        return this.xmlEvent.getEventType() == 1 && this.xmlEvent.asStartElement().getName().getLocalPart().equals(localName);
    }

    private boolean isEndElementWithName(String localName) {
        return this.xmlEvent.getEventType() == 2 && this.xmlEvent.asEndElement().getName().getLocalPart().equals(localName);
    }

    private void checkStartElementPreconditions() throws IllegalStateException {
        if (this.xmlEvent == null) {
            throw new IllegalStateException("xmlEvent is null");
        }
        if (this.xmlEvent.getEventType() != 1) {
            throw new IllegalStateException("xmlEvent type is not start element");
        }
    }

    private String readMandatoryAttribute(String attName, StartElement element) throws XMLStreamException {
        Attribute attribute = element.getAttributeByName(new QName(attName));
        if (attribute != null) {
            return attribute.getValue();
        }
        throw new XMLStreamException("Mandatory attribute '" + attName + "' not defined");
    }

    private String readAttribute(String attName, StartElement element, String defaultValue) {
        Attribute attribute = element.getAttributeByName(new QName(attName));
        if (attribute != null) {
            return attribute.getValue();
        }
        return defaultValue;
    }

    private int readIntAttribute(String attName, StartElement element, int defaultValue) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to integer");
        }
    }

    private int readIntAttribute(String attName, StartElement element) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            throw new XMLStreamException("Mandatory attribute '" + attName + "' not defined");
        }
        try {
            return Integer.parseInt(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to integer");
        }
    }

    private long readLongAttribute(String attName, StartElement element) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            throw new XMLStreamException("Mandatory attribute '" + attName + "' not defined");
        }
        try {
            return Long.parseLong(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to integer");
        }
    }

    private double readDoubleAttribute(String attName, StartElement element) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            throw new XMLStreamException("Mandatory attribute '" + attName + "' not defined");
        }
        try {
            return Double.parseDouble(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to double float number");
        }
    }

    private double readDoubleAttribute(String attName, StartElement element, double defaultValue) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to double floating point number");
        }
    }

    private boolean readBooleanAttribute(String attName, StartElement element, boolean defaultValue) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(v) || "1".equals(v)) {
            return true;
        }
        if ("false".equalsIgnoreCase(v) || "0".equals(v)) {
            return false;
        }
        throw new XMLStreamException("Cannot parse '" + v + "' to boolean");
    }

    public void setExcludedContainers(Set<String> excludedContainers) {
        this.excludedContainers = excludedContainers;
    }

    private void logUnknown() {
        if (this.xmlEvent.isStartElement()) {
            StartElement element = this.xmlEvent.asStartElement();
            log.warn("Skipping unkown tag {} at {}:{}", new Object[]{element.getName().getLocalPart(), element.getLocation().getLineNumber(), element.getLocation().getColumnNumber()});
        }
    }
}

