/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.utils;

import java.io.Serializable;

public class DoubleRange
implements Serializable {
    private static final long serialVersionUID = 3L;
    final double min;
    final double max;
    final boolean minIncl;
    final boolean maxIncl;

    public DoubleRange(double min, double max, boolean minIncl, boolean maxIncl) {
        this.min = min;
        this.max = max;
        this.minIncl = minIncl;
        this.maxIncl = maxIncl;
    }

    public DoubleRange(double minInclusive, double maxInclusive) {
        this.min = minInclusive;
        this.max = maxInclusive;
        this.minIncl = true;
        this.maxIncl = true;
    }

    public DoubleRange(DoubleRange range) {
        this.min = range.min;
        this.max = range.max;
        this.minIncl = range.minIncl;
        this.maxIncl = range.maxIncl;
    }

    public static DoubleRange fromXtceComplement(double minExclusive, double maxExclusive, double minInclusive, double maxInclusive) {
        double min = minExclusive;
        double max = maxExclusive;
        boolean minIncl = false;
        boolean maxIncl = false;
        if (!Double.isNaN(minInclusive)) {
            min = minInclusive;
            minIncl = true;
        }
        if (!Double.isNaN(maxInclusive)) {
            max = maxInclusive;
            maxIncl = true;
        }
        return new DoubleRange(min, max, minIncl, maxIncl);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public boolean isMinInclusive() {
        return this.minIncl;
    }

    public boolean isMaxInclusive() {
        return this.maxIncl;
    }

    public int inRange(double v) {
        if (!Double.isNaN(this.min) && (this.minIncl && v < this.min || !this.minIncl && v <= this.min)) {
            return -1;
        }
        if (!Double.isNaN(this.max) && (this.maxIncl && v > this.max || !this.maxIncl && v >= this.max)) {
            return 1;
        }
        return 0;
    }

    public DoubleRange intersectWith(DoubleRange other) {
        double xmin = Double.NEGATIVE_INFINITY;
        boolean xminExcl = true;
        if (!Double.isNaN(this.min) && this.min > xmin) {
            xmin = this.min;
            xminExcl = this.minIncl;
        }
        if (!Double.isNaN(other.min) && (other.minIncl && other.min > xmin || other.min >= xmin)) {
            xmin = other.min;
            xminExcl = other.minIncl;
        }
        if (Double.isInfinite(xmin)) {
            xmin = Double.NaN;
        }
        double xmax = Double.POSITIVE_INFINITY;
        boolean xmaxExcl = true;
        if (!Double.isNaN(this.max) && this.max < xmax) {
            xmax = this.max;
            xmaxExcl = this.maxIncl;
        }
        if (!Double.isNaN(other.max) && (other.maxIncl && other.max < xmax || other.max <= xmax)) {
            xmax = other.max;
            xmaxExcl = other.maxIncl;
        }
        if (Double.isInfinite(xmax)) {
            xmax = Double.NaN;
        }
        return new DoubleRange(xmin, xmax, xminExcl, xmaxExcl);
    }

    public String toString() {
        return (this.minIncl ? "[" : "(") + (Double.isNaN(this.min) ? "-inf" : Double.valueOf(this.min)) + "," + (Double.isNaN(this.max) ? "+inf" : Double.valueOf(this.max)) + (this.maxIncl ? "]" : ")");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.maxIncl ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.minIncl ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleRange other = (DoubleRange)obj;
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(other.max)) {
            return false;
        }
        if (Double.doubleToLongBits(this.min) != Double.doubleToLongBits(other.min)) {
            return false;
        }
        if (this.minIncl != other.minIncl) {
            return false;
        }
        return this.maxIncl == other.maxIncl;
    }
}

