/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import org.yamcs.utils.DoubleRange;
import org.yamcs.xtce.AlarmLevels;

public class AlarmRanges
implements Serializable {
    private static final long serialVersionUID = 200706052351L;
    DoubleRange watchRange = null;
    DoubleRange warningRange = null;
    DoubleRange distressRange = null;
    DoubleRange criticalRange = null;
    DoubleRange severeRange = null;

    public void addWatchRange(DoubleRange range) {
        this.watchRange = this.watchRange == null ? range : this.watchRange.intersectWith(range);
    }

    public void addWarningRange(DoubleRange range) {
        this.warningRange = this.warningRange == null ? range : this.warningRange.intersectWith(range);
    }

    public void addDistressRange(DoubleRange range) {
        this.distressRange = this.distressRange == null ? range : this.distressRange.intersectWith(range);
    }

    public void addCriticalRange(DoubleRange range) {
        this.criticalRange = this.criticalRange == null ? range : this.criticalRange.intersectWith(range);
    }

    public void addSevereRange(DoubleRange range) {
        this.severeRange = this.severeRange == null ? range : this.severeRange.intersectWith(range);
    }

    public void addRange(DoubleRange range, AlarmLevels level) {
        switch (level) {
            case watch: {
                this.addWatchRange(range);
                break;
            }
            case warning: {
                this.addWarningRange(range);
                break;
            }
            case distress: {
                this.addDistressRange(range);
                break;
            }
            case critical: {
                this.addCriticalRange(range);
                break;
            }
            case severe: {
                this.addSevereRange(range);
                break;
            }
            default: {
                throw new RuntimeException("Level '" + (Object)((Object)level) + "' not allowed for alarm ranges");
            }
        }
    }

    public DoubleRange getWatchRange() {
        return this.watchRange;
    }

    public DoubleRange getWarningRange() {
        return this.warningRange;
    }

    public DoubleRange getDistressRange() {
        return this.distressRange;
    }

    public DoubleRange getCriticalRange() {
        return this.criticalRange;
    }

    public DoubleRange getSevereRange() {
        return this.severeRange;
    }

    public void setWarningRange(DoubleRange warningRange) {
        this.warningRange = warningRange;
    }

    public String toString() {
        return (this.watchRange != null ? " watchRange" + this.watchRange : "") + (this.warningRange != null ? " warningRange" + this.warningRange : "") + (this.distressRange != null ? " distressRange" + this.distressRange : "") + (this.criticalRange != null ? " criticalRange" + this.criticalRange : "") + (this.severeRange != null ? " severeRange" + this.severeRange : "");
    }
}

