/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.List;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.IntegerValue;
import org.yamcs.xtce.NameDescription;

public class ArrayDataType
extends NameDescription
implements DataType {
    private static final long serialVersionUID = 1L;
    List<IntegerValue> dim;
    private DataType type;
    private int numberOfDimensions;
    private Object[] initialValue;

    public ArrayDataType(Builder<?> builder) {
        super(builder);
        if (((Builder)builder).type == null) {
            throw new IllegalArgumentException("Array element type cannot be null");
        }
        this.dim = builder.dim;
        this.type = ((Builder)builder).type;
        this.numberOfDimensions = ((Builder)builder).numberOfDimensions;
        if (((Builder)builder).initialValue != null) {
            this.initialValue = ((Builder)builder).initialValue instanceof Object[] ? (Object[])((Builder)builder).initialValue : this.parseString(((Builder)builder).initialValue.toString());
        }
    }

    public ArrayDataType(String name, int numberOfDimensions) {
        super(name);
        this.numberOfDimensions = numberOfDimensions;
    }

    public ArrayDataType(ArrayDataType t) {
        super(t);
        this.type = t.type;
        this.numberOfDimensions = t.numberOfDimensions;
        this.initialValue = t.initialValue;
        this.dim = t.dim;
    }

    public DataType getElementType() {
        return this.type;
    }

    public int getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.ARRAY;
    }

    @Override
    public String getTypeAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.getName());
        for (int i = 0; i < this.numberOfDimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public List<IntegerValue> getSize() {
        return this.dim;
    }

    public Object[] parseString(String v) {
        Object[] r;
        try {
            JsonElement el = new JsonParser().parse(v);
            if (!(el instanceof JsonArray)) {
                throw new IllegalArgumentException("Expected an array but got a : " + el.getClass());
            }
            JsonArray jarr = (JsonArray)el;
            r = new Object[jarr.size()];
            for (int i = 0; i < jarr.size(); ++i) {
                r[i] = this.type.parseString(jarr.get(i).getAsString());
            }
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Cannot parse string as json: " + e.getMessage());
        }
        return r;
    }

    @Override
    public String toString(Object v) {
        if (v instanceof Object[]) {
            Object[] v1 = (Object[])v;
            String[] v2 = new String[v1.length];
            for (int i = 0; i < v1.length; ++i) {
                v2[i] = this.type.toString(v1[i]);
            }
            Gson gson = new Gson();
            return gson.toJson((Object)v2);
        }
        throw new IllegalArgumentException("Can only convert arrays not " + v.getClass());
    }

    public Object[] getInitialValue() {
        return this.initialValue;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends NameDescription.Builder<T>
    implements DataType.Builder<T> {
        List<IntegerValue> dim;
        private DataType type;
        private int numberOfDimensions;
        private Object initialValue;

        public Builder() {
        }

        public Builder(ArrayDataType dataType) {
            super(dataType);
            this.dim = dataType.dim;
            this.type = dataType.type;
            this.numberOfDimensions = dataType.numberOfDimensions;
            this.initialValue = dataType.initialValue;
        }

        public void setElementType(DataType type) {
            this.type = type;
        }

        public void setSize(List<IntegerValue> list) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Dimension sizes cannot be empty");
            }
            this.dim = list;
            this.setNumberOfDimensions(this.dim.size());
        }

        public T setNumberOfDimensions(int numberOfDimensions) {
            this.numberOfDimensions = numberOfDimensions;
            return (T)((Builder)this.self());
        }

        @Override
        public T setInitialValue(String initialValue) {
            this.initialValue = initialValue;
            return (T)((Builder)this.self());
        }

        public boolean isResolved() {
            return this.type != null;
        }
    }
}

