/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.UnitType;

public abstract class BaseDataType
extends NameDescription
implements DataType {
    private static final long serialVersionUID = 3L;
    List<UnitType> unitSet = new ArrayList<UnitType>();
    protected DataEncoding encoding;

    BaseDataType(String name) {
        super(name);
    }

    BaseDataType(Builder<?> builder) {
        super(builder);
        this.unitSet = builder.unitSet;
        if (((Builder)builder).encoding != null) {
            this.encoding = ((Builder)builder).encoding.build();
        }
        if (builder.baseType != null) {
            BaseDataType baseType = builder.baseType;
            if (this.encoding == null && baseType.encoding != null) {
                this.encoding = baseType.encoding;
            }
            if (this.unitSet == null && baseType.unitSet != null) {
                this.unitSet = baseType.unitSet;
            }
        }
    }

    protected BaseDataType(BaseDataType t) {
        super(t);
        this.unitSet = t.unitSet;
        this.encoding = t.encoding;
    }

    public DataEncoding getEncoding() {
        return this.encoding;
    }

    public List<UnitType> getUnitSet() {
        return this.unitSet;
    }

    protected void setInitialValue(Builder<?> builder) {
        if (builder.initialValue != null) {
            this.setInitialValue(builder.initialValue);
        } else if (builder.baseType != null && builder.baseType.getInitialValue() != null) {
            this.setInitialValue(builder.baseType.getInitialValue());
        }
    }

    protected abstract void setInitialValue(Object var1);

    @Override
    public abstract Object parseString(String var1);

    @Override
    public String toString(Object o) {
        return o.toString();
    }

    public Object parseStringForRawValue(String stringValue) {
        return this.encoding.parseString(stringValue);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends NameDescription.Builder<T>
    implements DataType.Builder<T> {
        List<UnitType> unitSet = new ArrayList<UnitType>();
        private DataEncoding.Builder<?> encoding;
        protected Object initialValue;
        protected BaseDataType baseType;

        public Builder() {
        }

        public Builder(BaseDataType baseType) {
            super(baseType);
            this.unitSet = baseType.unitSet;
            this.initialValue = baseType.getInitialValue();
            if (baseType.encoding != null) {
                this.encoding = baseType.encoding.toBuilder();
            }
        }

        public T setInitialValue(byte[] initialValue) {
            this.initialValue = initialValue;
            return (T)((Builder)this.self());
        }

        @Override
        public T setInitialValue(String initialValue) {
            this.initialValue = initialValue;
            return (T)((Builder)this.self());
        }

        public T setEncoding(DataEncoding.Builder<?> dataEncoding) {
            this.encoding = dataEncoding;
            if (this.baseType != null) {
                this.encoding.baseEncoding = this.baseType.encoding;
            }
            return (T)((Builder)this.self());
        }

        public T addAllUnits(Collection<UnitType> units) {
            this.unitSet.addAll(units);
            return (T)((Builder)this.self());
        }

        public T addUnit(UnitType unit) {
            this.unitSet.add(unit);
            return (T)((Builder)this.self());
        }

        public DataEncoding.Builder<?> getEncoding() {
            return this.encoding;
        }

        public void setBaseType(BaseDataType type) {
            this.baseType = type;
            if (this.encoding != null) {
                this.encoding.baseEncoding = type.encoding;
            }
        }
    }
}

