/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.BinaryDataType;
import org.yamcs.xtce.DataEncoding;

public class BinaryDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 2L;
    int sizeInBitsOfSizeTag = 16;
    private Type type = Type.FIXED_SIZE;

    public BinaryDataEncoding(BinaryDataEncoding bde) {
        super(bde);
        this.sizeInBitsOfSizeTag = bde.sizeInBitsOfSizeTag;
        this.type = bde.type;
    }

    public BinaryDataEncoding(Builder builder) {
        super(builder, -1);
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.sizeInBitsOfSizeTag != null) {
            this.sizeInBitsOfSizeTag = builder.sizeInBitsOfSizeTag;
        }
        if (builder.baseEncoding != null && builder.baseEncoding instanceof BinaryDataEncoding) {
            BinaryDataEncoding baseEncoding = (BinaryDataEncoding)builder.baseEncoding;
            if (builder.type == null) {
                this.type = baseEncoding.type;
            }
            if (builder.sizeInBitsOfSizeTag == null) {
                this.sizeInBitsOfSizeTag = baseEncoding.sizeInBitsOfSizeTag;
            }
        }
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public void setSizeType(Type sizeType) {
        this.type = sizeType;
    }

    public Type getType() {
        return this.type;
    }

    public int getSizeInBitsOfSizeTag() {
        return this.sizeInBitsOfSizeTag;
    }

    public void setSizeInBitsOfSizeTag(int sizeInBits) {
        this.sizeInBitsOfSizeTag = sizeInBits;
    }

    @Override
    public Object parseString(String stringValue) {
        return BinaryDataType.hexStringToArray(stringValue);
    }

    @Override
    public BinaryDataEncoding copy() {
        return new BinaryDataEncoding(this);
    }

    public String toString() {
        return "BinaryDataEncoding(sizeInBits:" + this.sizeInBits + ", type:" + (Object)((Object)this.type) + ")";
    }

    public static class Builder
    extends DataEncoding.Builder<Builder> {
        Integer sizeInBitsOfSizeTag;
        private Type type;

        public Builder(BinaryDataEncoding encoding) {
            super(encoding);
            this.sizeInBitsOfSizeTag = encoding.sizeInBitsOfSizeTag;
            this.type = encoding.type;
        }

        public Builder() {
        }

        @Override
        public BinaryDataEncoding build() {
            return new BinaryDataEncoding(this);
        }

        public Builder setType(Type type) {
            this.type = type;
            return (Builder)this.self();
        }

        public Builder setSizeInBitsOfSizeTag(int sizeInBitsOfSizeTag) {
            this.sizeInBitsOfSizeTag = sizeInBitsOfSizeTag;
            return (Builder)this.self();
        }
    }

    public static enum Type {
        FIXED_SIZE,
        LEADING_SIZE,
        CUSTOM;

    }
}

