/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.BaseDataType;
import org.yamcs.xtce.IntegerRange;

public class BinaryDataType
extends BaseDataType {
    private static final long serialVersionUID = 1L;
    byte[] initialValue;
    IntegerRange sizeRangeInBytes;

    protected BinaryDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        this.sizeRangeInBytes = builder.sizeRangeInBytes;
        if (builder.baseType != null && builder.baseType instanceof BinaryDataType) {
            BinaryDataType baseType = (BinaryDataType)builder.baseType;
            if (builder.sizeRangeInBytes == null && baseType.sizeRangeInBytes != null) {
                this.sizeRangeInBytes = baseType.sizeRangeInBytes;
            }
        }
        this.setInitialValue(builder);
    }

    @Override
    protected void setInitialValue(Object initialValue) {
        if (initialValue instanceof String) {
            this.initialValue = this.parseString((String)initialValue);
        } else if (initialValue instanceof byte[]) {
            this.initialValue = (byte[])initialValue;
        } else {
            throw new IllegalArgumentException("Unsupported type for initial value " + initialValue.getClass());
        }
    }

    protected BinaryDataType(BinaryDataType t) {
        super(t);
        this.sizeRangeInBytes = t.sizeRangeInBytes;
    }

    public byte[] getInitialValue() {
        return this.initialValue;
    }

    public IntegerRange getSizeRangeInBytes() {
        return this.sizeRangeInBytes;
    }

    public void setSizeRangeInBytes(IntegerRange sizeRangeInBytes) {
        this.sizeRangeInBytes = sizeRangeInBytes;
    }

    public String toString() {
        return "BinaryData encoding: " + this.encoding;
    }

    public byte[] parseString(String stringValue) {
        return BinaryDataType.hexStringToArray(stringValue);
    }

    @Override
    public String toString(Object v) {
        if (v instanceof byte[]) {
            return BinaryDataType.arrayToHexString((byte[])v);
        }
        throw new IllegalArgumentException("Can only convert byte arrays");
    }

    public static byte[] hexStringToArray(String s) {
        if ((s.length() & 1) == 1) {
            s = "0" + s;
        }
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < s.length() / 2; ++i) {
            b[i] = (byte)(Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16) & 0xFF);
        }
        return b;
    }

    public static String arrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(String.format("%02X", b[i] & 0xFF));
        }
        return sb.toString();
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.BINARY;
    }

    @Override
    public String getTypeAsString() {
        return "binary";
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        IntegerRange sizeRangeInBytes;

        public Builder() {
        }

        public Builder(BinaryDataType binaryDataType) {
            super(binaryDataType);
            this.sizeRangeInBytes = binaryDataType.sizeRangeInBytes;
        }

        public void setSizeRangeInBytes(IntegerRange sizeRangeInBytes) {
            this.sizeRangeInBytes = sizeRangeInBytes;
        }
    }
}

