/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.BaseDataType;

public class BooleanDataType
extends BaseDataType {
    private static final long serialVersionUID = 1L;
    Boolean initialValue;
    String oneStringValue = "True";
    String zeroStringValue = "False";

    protected BooleanDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        if (builder.oneStringValue != null) {
            this.oneStringValue = builder.oneStringValue;
        }
        if (builder.zeroStringValue != null) {
            this.zeroStringValue = builder.zeroStringValue;
        }
        if (builder.baseType != null && builder.baseType instanceof BooleanDataType) {
            BooleanDataType baseType = (BooleanDataType)builder.baseType;
            if (builder.oneStringValue == null && baseType.oneStringValue != null) {
                this.oneStringValue = baseType.oneStringValue;
            }
            if (builder.zeroStringValue == null && baseType.zeroStringValue != null) {
                this.zeroStringValue = baseType.zeroStringValue;
            }
        }
        this.setInitialValue(builder);
    }

    protected BooleanDataType(BooleanDataType t) {
        super(t);
    }

    @Override
    protected void setInitialValue(Object initialValue) {
        if (initialValue instanceof Boolean) {
            this.initialValue = (Boolean)initialValue;
        } else if (initialValue instanceof String) {
            this.initialValue = this.parseString((String)initialValue);
        } else {
            throw new IllegalArgumentException("Unsupported type for initial value " + initialValue.getClass());
        }
    }

    @Override
    public Boolean getInitialValue() {
        return this.initialValue;
    }

    @Override
    public Boolean parseString(String stringValue) {
        if (this.oneStringValue.equalsIgnoreCase(stringValue)) {
            return Boolean.TRUE;
        }
        if (this.zeroStringValue.equalsIgnoreCase(stringValue)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid initialValue, should be '" + this.oneStringValue + "' or '" + this.zeroStringValue + "'");
    }

    public String getOneStringValue() {
        return this.oneStringValue;
    }

    public String getZeroStringValue() {
        return this.zeroStringValue;
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.BOOLEAN;
    }

    @Override
    public String getTypeAsString() {
        return "boolean";
    }

    public String toString() {
        return "BooleanData encoding: " + this.encoding;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        String oneStringValue;
        String zeroStringValue;

        public Builder() {
        }

        public Builder(BooleanDataType dataType) {
            super(dataType);
            this.oneStringValue = dataType.oneStringValue;
            this.zeroStringValue = dataType.zeroStringValue;
        }

        public void setOneStringValue(String oneStringValue) {
            this.oneStringValue = oneStringValue;
        }

        public void setZeroStringValue(String zeroStringValue) {
            this.zeroStringValue = zeroStringValue;
        }
    }
}

