/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.HashSet;
import java.util.Set;
import org.yamcs.xtce.AggregateParameterType;
import org.yamcs.xtce.CriteriaEvaluator;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.OperatorType;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.PathElement;
import org.yamcs.xtce.util.DataTypeUtil;

public class Comparison
implements MatchCriteria {
    private static final long serialVersionUID = 9L;
    ParameterInstanceRef instanceRef;
    OperatorType comparisonOperator;
    String stringValue;
    private Object value;

    public Comparison(ParameterInstanceRef paraRef, String stringValue, OperatorType op) {
        if (stringValue == null) {
            throw new NullPointerException("stringValue");
        }
        this.instanceRef = paraRef;
        this.stringValue = stringValue;
        this.value = stringValue;
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    public Comparison(ParameterInstanceRef paraRef, int intValue, OperatorType op) {
        this.instanceRef = paraRef;
        this.value = intValue;
        this.stringValue = Integer.toString(intValue);
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    public Comparison(ParameterInstanceRef paraRef, long longValue, OperatorType op) {
        this.instanceRef = paraRef;
        this.value = longValue;
        this.stringValue = Long.toString(longValue);
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    public Comparison(ParameterInstanceRef paraRef, double doubleValue, OperatorType op) {
        this.instanceRef = paraRef;
        this.value = doubleValue;
        this.stringValue = Double.toString(doubleValue);
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    private void checkParaRef(ParameterInstanceRef paraRef) {
        if (paraRef.getInstance() != 0) {
            throw new UnsupportedOperationException("Condition on parameter values from history are not supported");
        }
    }

    @Override
    public boolean isMet(CriteriaEvaluator evaluator) {
        return evaluator.evaluate(this.comparisonOperator, this.instanceRef, this.value);
    }

    @Override
    public String toExpressionString() {
        return MatchCriteria.printExpressionReference(this.instanceRef) + " " + (Object)((Object)this.comparisonOperator) + " " + MatchCriteria.printExpressionValue(this.value);
    }

    public void resolveValueType() {
        boolean useCalibratedValue = this.instanceRef.useCalibratedValue();
        ParameterType ptype = this.instanceRef.getParameter().getParameterType();
        if (ptype instanceof AggregateParameterType) {
            if (this.instanceRef.getMemberPath() == null) {
                throw new IllegalArgumentException("Reference to an aggregate parameter type " + ptype.getName() + " without speciyfing the path");
            }
            ParameterType ptype1 = (ParameterType)DataTypeUtil.getMemberType(ptype, this.instanceRef.getMemberPath());
            if (ptype1 == null) {
                throw new IllegalArgumentException("reference " + PathElement.pathToString(this.instanceRef.getMemberPath()) + " points to a nonexistent member inside the parameter type " + ptype.getName());
            }
            ptype = ptype1;
        }
        try {
            this.value = useCalibratedValue ? ptype.parseString(this.stringValue) : ptype.parseStringForRawValue(this.stringValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot parse value required for comparing with " + this.instanceRef.getParameter().getName() + ": " + e.getMessage(), e);
        }
    }

    public ParameterInstanceRef getParameterRef() {
        return this.instanceRef;
    }

    public OperatorType getComparisonOperator() {
        return this.comparisonOperator;
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        HashSet<Parameter> pset = new HashSet<Parameter>();
        pset.add(this.instanceRef.getParameter());
        return pset;
    }

    public Parameter getParameter() {
        return this.instanceRef.getParameter();
    }

    ParameterInstanceRef getParameterInstanceRef() {
        return this.instanceRef;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String toString() {
        if (this.instanceRef.getParameter() != null) {
            return "Comparison: paraName(" + this.instanceRef.getParameter().getName() + (this.instanceRef.useCalibratedValue() ? ".eng" : ".raw") + ")" + (Object)((Object)this.comparisonOperator) + this.stringValue;
        }
        return "Comparison: paraName(unresolved)" + (Object)((Object)this.comparisonOperator) + this.stringValue;
    }
}

