/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.yamcs.xtce.Comparison;
import org.yamcs.xtce.CriteriaEvaluator;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.Parameter;

public class ComparisonList
implements MatchCriteria {
    private static final long serialVersionUID = 200805131551L;
    ArrayList<Comparison> comparisons = new ArrayList();

    public void addComparison(Comparison comparison) {
        this.comparisons.add(comparison);
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        HashSet<Parameter> pset = new HashSet<Parameter>();
        for (Comparison c : this.comparisons) {
            pset.addAll(c.getDependentParameters());
        }
        return pset;
    }

    @Override
    public boolean isMet(CriteriaEvaluator evaluator) {
        for (Comparison c : this.comparisons) {
            if (c.isMet(evaluator)) continue;
            return false;
        }
        return true;
    }

    public List<Comparison> getComparisonList() {
        return this.comparisons;
    }

    @Override
    public String toExpressionString() {
        return this.comparisons.stream().map(Comparison::toExpressionString).collect(Collectors.joining(" and "));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ComparisonList: ");
        for (Comparison c : this.comparisons) {
            sb.append(c.toString()).append(" ");
        }
        return sb.toString();
    }
}

