/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Set;
import org.yamcs.xtce.Algorithm;
import org.yamcs.xtce.Parameter;

public abstract class DataEncoding
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected int sizeInBits;
    transient ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected Algorithm fromBinaryTransformAlgorithm;
    protected Algorithm toBinaryTransformAlgorithm;

    DataEncoding(DataEncoding de) {
        this.sizeInBits = de.sizeInBits;
        this.byteOrder = de.byteOrder;
        this.fromBinaryTransformAlgorithm = de.fromBinaryTransformAlgorithm;
        this.toBinaryTransformAlgorithm = de.toBinaryTransformAlgorithm;
    }

    DataEncoding(Builder<?> builder, int defaultSizeInBits) {
        this.sizeInBits = defaultSizeInBits;
        if (builder.sizeInBits != null) {
            this.sizeInBits = builder.sizeInBits;
        }
        if (builder.byteOrder != null) {
            this.byteOrder = builder.byteOrder;
        }
        this.fromBinaryTransformAlgorithm = ((Builder)builder).fromBinaryTransformAlgorithm;
        this.toBinaryTransformAlgorithm = ((Builder)builder).toBinaryTransformAlgorithm;
        if (builder.baseEncoding != null) {
            DataEncoding baseEncoding = builder.baseEncoding;
            if (builder.sizeInBits == null) {
                this.sizeInBits = baseEncoding.sizeInBits;
            }
            if (builder.byteOrder == null) {
                this.byteOrder = baseEncoding.byteOrder;
            }
            if (((Builder)builder).fromBinaryTransformAlgorithm == null) {
                this.fromBinaryTransformAlgorithm = baseEncoding.fromBinaryTransformAlgorithm;
            }
            if (((Builder)builder).toBinaryTransformAlgorithm == null) {
                this.toBinaryTransformAlgorithm = baseEncoding.toBinaryTransformAlgorithm;
            }
        }
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public void setSizeInBits(int sizeInBits) {
        this.sizeInBits = sizeInBits;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int o = in.readInt();
        this.byteOrder = o == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public abstract Object parseString(String var1);

    public Algorithm getFromBinaryTransformAlgorithm() {
        return this.fromBinaryTransformAlgorithm;
    }

    public void setFromBinaryTransformAlgorithm(Algorithm fromBinaryTransformAlgorithm) {
        this.fromBinaryTransformAlgorithm = fromBinaryTransformAlgorithm;
    }

    public Algorithm getToBinaryTransformAlgorithm() {
        return this.toBinaryTransformAlgorithm;
    }

    public void setToBinaryTransformAlgorithm(Algorithm toBinaryTransformAlgorithm) {
        this.toBinaryTransformAlgorithm = toBinaryTransformAlgorithm;
    }

    public Set<Parameter> getDependentParameters() {
        return Collections.emptySet();
    }

    public abstract DataEncoding copy();

    public abstract Builder<?> toBuilder();

    public static abstract class Builder<T extends Builder<T>> {
        protected Integer sizeInBits;
        transient ByteOrder byteOrder = null;
        private Algorithm fromBinaryTransformAlgorithm;
        private Algorithm toBinaryTransformAlgorithm;
        DataEncoding baseEncoding;

        public Builder(DataEncoding encoding) {
            this.sizeInBits = encoding.sizeInBits;
            this.byteOrder = encoding.byteOrder;
            this.fromBinaryTransformAlgorithm = encoding.fromBinaryTransformAlgorithm;
            this.toBinaryTransformAlgorithm = encoding.toBinaryTransformAlgorithm;
        }

        public Builder() {
        }

        public T setSizeInBits(Integer sizeInBits) {
            this.sizeInBits = sizeInBits;
            return this.self();
        }

        public T setFromBinaryTransformAlgorithm(Algorithm alg) {
            this.fromBinaryTransformAlgorithm = alg;
            return this.self();
        }

        public T setToBinaryTransformAlgorithm(Algorithm alg) {
            this.toBinaryTransformAlgorithm = alg;
            return this.self();
        }

        public T setByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this.self();
        }

        protected T self() {
            return (T)this;
        }

        protected abstract DataEncoding build();

        public Integer getSizeInBits() {
            return this.sizeInBits;
        }
    }
}

