/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.ContextCalibrator;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.NumericDataEncoding;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.StringDataEncoding;

public class FloatDataEncoding
extends DataEncoding
implements NumericDataEncoding {
    private static final long serialVersionUID = 3L;
    Calibrator defaultCalibrator = null;
    private List<ContextCalibrator> contextCalibratorList = null;
    private Encoding encoding = Encoding.IEEE754_1985;
    StringDataEncoding stringEncoding = null;

    public FloatDataEncoding(Builder builder) {
        super(builder, 32);
        if (builder.encoding != null) {
            this.encoding = builder.encoding;
        }
        this.defaultCalibrator = builder.defaultCalibrator;
        this.contextCalibratorList = builder.contextCalibratorList;
        this.stringEncoding = builder.stringEncoding;
        if (builder.baseEncoding != null && builder.baseEncoding instanceof FloatDataEncoding) {
            FloatDataEncoding baseEncoding = (FloatDataEncoding)builder.baseEncoding;
            if (builder.defaultCalibrator == null) {
                this.defaultCalibrator = baseEncoding.defaultCalibrator;
            }
            if (builder.contextCalibratorList == null) {
                this.contextCalibratorList = baseEncoding.contextCalibratorList;
            }
            if (builder.encoding == null) {
                this.encoding = baseEncoding.encoding;
            }
            if (builder.stringEncoding == null) {
                this.stringEncoding = baseEncoding.stringEncoding;
            }
        }
        FloatDataEncoding.validateEncodingSizeInBits(this.encoding, this.sizeInBits);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private static void validateEncodingSizeInBits(Encoding encoding, int sizeInBits) {
        if (encoding == Encoding.IEEE754_1985) {
            if (sizeInBits != 32 && sizeInBits != 64) {
                throw new IllegalArgumentException("For IEEE754_1985 encoding sizeInBits has to be 32 or 64");
            }
        } else if (encoding == Encoding.MILSTD_1750A && sizeInBits != 32 && sizeInBits != 48) {
            throw new IllegalArgumentException("For MILSTD_1750A encoding sizeInBits has to be 32 or 48");
        }
    }

    public FloatDataEncoding(FloatDataEncoding fde) {
        super(fde);
        this.defaultCalibrator = fde.defaultCalibrator;
        this.contextCalibratorList = fde.contextCalibratorList;
        this.encoding = fde.encoding;
        this.stringEncoding = fde.stringEncoding;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public StringDataEncoding getStringDataEncoding() {
        return this.stringEncoding;
    }

    @Override
    public Calibrator getDefaultCalibrator() {
        return this.defaultCalibrator;
    }

    @Override
    public void setDefaultCalibrator(Calibrator calibrator) {
        this.defaultCalibrator = calibrator;
    }

    public String toString() {
        switch (this.getEncoding()) {
            case IEEE754_1985: 
            case MILSTD_1750A: {
                return "FloatDataEncoding(sizeInBits=" + this.sizeInBits + "" + (this.defaultCalibrator == null ? "" : ", defaultCalibrator:" + this.defaultCalibrator) + ")";
            }
            case STRING: {
                return "FloatDataEncoding(sizeInBits=" + this.sizeInBits + " StringEncoding: " + this.stringEncoding + (this.defaultCalibrator == null ? "" : ", defaultCalibrator:" + this.defaultCalibrator) + ")";
            }
        }
        return "UnknownFloatEncoding(" + (Object)((Object)this.getEncoding()) + ")";
    }

    @Override
    public Object parseString(String stringValue) {
        switch (this.getEncoding()) {
            case IEEE754_1985: 
            case MILSTD_1750A: {
                if (this.sizeInBits == 32) {
                    return Float.valueOf(Float.parseFloat(stringValue));
                }
                return Double.parseDouble(stringValue);
            }
            case STRING: {
                return stringValue;
            }
        }
        throw new IllegalStateException("Unknown encoding " + (Object)((Object)this.getEncoding()));
    }

    @Override
    public List<ContextCalibrator> getContextCalibratorList() {
        return this.contextCalibratorList;
    }

    @Override
    public void setContextCalibratorList(List<ContextCalibrator> contextCalibratorList) {
        this.contextCalibratorList = contextCalibratorList;
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        if (this.contextCalibratorList != null) {
            HashSet<Parameter> r = new HashSet<Parameter>();
            for (ContextCalibrator cc : this.contextCalibratorList) {
                r.addAll(cc.getContextMatch().getDependentParameters());
            }
            return r;
        }
        return Collections.emptySet();
    }

    @Override
    public FloatDataEncoding copy() {
        return new FloatDataEncoding(this);
    }

    public static class Builder
    extends DataEncoding.Builder<Builder>
    implements NumericDataEncoding.Builder<Builder> {
        Calibrator defaultCalibrator = null;
        List<ContextCalibrator> contextCalibratorList = null;
        Encoding encoding = null;
        StringDataEncoding stringEncoding = null;

        public Builder(FloatDataEncoding encoding) {
            super(encoding);
            this.defaultCalibrator = encoding.defaultCalibrator;
            this.contextCalibratorList = encoding.contextCalibratorList;
            this.stringEncoding = encoding.stringEncoding;
            this.encoding = encoding.encoding;
        }

        public Builder() {
        }

        @Override
        public FloatDataEncoding build() {
            return new FloatDataEncoding(this);
        }

        public Builder setFloatEncoding(Encoding floatEncoding) {
            this.encoding = floatEncoding;
            return (Builder)this.self();
        }

        @Override
        public Builder setDefaultCalibrator(Calibrator calibrator) {
            this.defaultCalibrator = calibrator;
            return (Builder)this.self();
        }

        @Override
        public Builder setContextCalibratorList(List<ContextCalibrator> list) {
            this.contextCalibratorList = list;
            return (Builder)this.self();
        }

        public Builder setStringEncoding(StringDataEncoding stringEncoding) {
            this.stringEncoding = stringEncoding;
            this.encoding = Encoding.STRING;
            this.sizeInBits = stringEncoding.sizeInBits;
            return (Builder)this.self();
        }
    }

    public static enum Encoding {
        IEEE754_1985,
        MILSTD_1750A,
        STRING;

    }
}

