/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.BaseDataType;
import org.yamcs.xtce.FloatValidRange;
import org.yamcs.xtce.NumericDataType;

public abstract class FloatDataType
extends NumericDataType {
    private static final long serialVersionUID = 1L;
    Double initialValue;
    FloatValidRange validRange;
    int sizeInBits = 32;

    protected FloatDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        this.validRange = ((Builder)builder).validRange;
        if (builder.sizeInBits != null) {
            this.sizeInBits = builder.sizeInBits;
        }
        if (builder.baseType != null && builder.baseType instanceof FloatDataType) {
            FloatDataType baseType = (FloatDataType)builder.baseType;
            if (builder.sizeInBits == null) {
                this.sizeInBits = baseType.sizeInBits;
            }
            if (((Builder)builder).validRange == null && baseType.validRange != null) {
                this.validRange = baseType.validRange;
            }
        }
        this.setInitialValue(builder);
    }

    protected FloatDataType(FloatDataType t) {
        super(t);
        this.validRange = t.validRange;
        this.sizeInBits = t.sizeInBits;
    }

    @Override
    public Double getInitialValue() {
        return this.initialValue;
    }

    @Override
    protected void setInitialValue(Object initialValue) {
        if (initialValue instanceof String) {
            this.initialValue = this.parseString((String)initialValue);
        } else if (initialValue instanceof Number) {
            this.initialValue = ((Number)initialValue).doubleValue();
        } else {
            throw new IllegalArgumentException("Invalid initialValue");
        }
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public FloatValidRange getValidRange() {
        return this.validRange;
    }

    @Override
    public Double parseString(String stringValue) {
        if (this.sizeInBits == 32) {
            return Float.parseFloat(stringValue);
        }
        return Double.parseDouble(stringValue);
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return this.sizeInBits <= 32 ? Yamcs.Value.Type.FLOAT : Yamcs.Value.Type.DOUBLE;
    }

    @Override
    public String getTypeAsString() {
        return "float";
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        private FloatValidRange validRange;
        Integer sizeInBits;

        public Builder() {
        }

        public Builder(FloatDataType dataType) {
            super(dataType);
            this.validRange = dataType.validRange;
            this.sizeInBits = dataType.sizeInBits;
        }

        public T setSizeInBits(int sizeInBits) {
            this.sizeInBits = sizeInBits;
            return (T)((Builder)this.self());
        }

        public T setValidRange(FloatValidRange validRange) {
            this.validRange = validRange;
            return (T)((Builder)this.self());
        }

        public T setInitialValue(double initialValue) {
            this.initialValue = Double.toString(initialValue);
            return (T)((Builder)this.self());
        }
    }
}

