/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;

public class History
implements Serializable,
Comparable<History> {
    private static final long serialVersionUID = 1L;
    private String version;
    private String date;
    private String message;
    private String author;

    public History(String version, String date, String message, String author) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        if (!version.matches("[0-9]+.*")) {
            throw new IllegalArgumentException("Invalid version format '" + version + "'");
        }
        this.version = version;
        this.date = date;
        this.message = message;
        this.author = author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    public String getMessage() {
        return this.message;
    }

    public String getAuthor() {
        return this.author;
    }

    public String toString() {
        return this.version + "; " + this.date + (this.message != null ? "; " + this.message : "");
    }

    @Override
    public int compareTo(History o) {
        if (o == null) {
            return 1;
        }
        String[] parts = this.version.split("\\.");
        String[] oparts = o.version.split("\\.");
        int len = Math.max(parts.length, oparts.length);
        for (int i = 0; i < len; ++i) {
            try {
                int opart;
                int part = i < parts.length ? Integer.parseInt(parts[i]) : 0;
                int n = opart = i < oparts.length ? Integer.parseInt(oparts[i]) : 0;
                if (part < opart) {
                    return -1;
                }
                if (part <= opart) continue;
                return 1;
            }
            catch (NumberFormatException e) {
                int c = parts[i].compareTo(oparts[i]);
                if (c == 0) continue;
                return c;
            }
        }
        return 0;
    }
}

