/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.ContextCalibrator;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.NumericDataEncoding;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.StringDataEncoding;

public class IntegerDataEncoding
extends DataEncoding
implements NumericDataEncoding {
    private static final long serialVersionUID = 3L;
    static Logger log = LoggerFactory.getLogger((String)IntegerDataEncoding.class.getName());
    Calibrator defaultCalibrator = null;
    private List<ContextCalibrator> contextCalibratorList = null;
    Encoding encoding = Encoding.UNSIGNED;
    StringDataEncoding stringEncoding = null;

    public IntegerDataEncoding(Builder builder) {
        super(builder, 8);
        if (builder.encoding != null) {
            this.encoding = builder.encoding;
        }
        this.defaultCalibrator = builder.defaultCalibrator;
        this.contextCalibratorList = builder.contextCalibratorList;
        this.stringEncoding = builder.stringEncoding;
        if (builder.baseEncoding != null && builder.baseEncoding instanceof IntegerDataEncoding) {
            IntegerDataEncoding baseEncoding = (IntegerDataEncoding)builder.baseEncoding;
            if (builder.defaultCalibrator == null) {
                this.defaultCalibrator = baseEncoding.defaultCalibrator;
            }
            if (builder.contextCalibratorList == null) {
                this.contextCalibratorList = baseEncoding.contextCalibratorList;
            }
            if (builder.encoding == null) {
                this.encoding = baseEncoding.encoding;
            }
            if (builder.stringEncoding == null) {
                this.stringEncoding = baseEncoding.stringEncoding;
            }
        }
    }

    public IntegerDataEncoding(IntegerDataEncoding ide) {
        super(ide);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public StringDataEncoding getStringEncoding() {
        return this.stringEncoding;
    }

    @Override
    public Calibrator getDefaultCalibrator() {
        return this.defaultCalibrator;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setDefaultCalibrator(Calibrator calibrator) {
        this.defaultCalibrator = calibrator;
    }

    @Override
    public Object parseString(String stringValue) {
        if (this.encoding == Encoding.STRING) {
            return stringValue;
        }
        if (this.sizeInBits > 32) {
            return Long.decode(stringValue);
        }
        return Long.decode(stringValue).intValue();
    }

    @Override
    public List<ContextCalibrator> getContextCalibratorList() {
        return this.contextCalibratorList;
    }

    @Override
    public void setContextCalibratorList(List<ContextCalibrator> contextCalibratorList) {
        this.contextCalibratorList = contextCalibratorList;
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        if (this.contextCalibratorList != null) {
            HashSet<Parameter> r = new HashSet<Parameter>();
            for (ContextCalibrator cc : this.contextCalibratorList) {
                r.addAll(cc.getContextMatch().getDependentParameters());
            }
            return r;
        }
        return Collections.emptySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntegerDataEncoding[sizeInBits: ").append(this.sizeInBits).append(", byteOrder: ").append(this.byteOrder);
        if (this.stringEncoding == null) {
            sb.append(", encoding:").append((Object)this.encoding);
        } else {
            sb.append(", stringEncoding: ").append(this.stringEncoding);
        }
        if (this.defaultCalibrator != null) {
            sb.append(", defaultCalibrator: ").append(this.defaultCalibrator);
        }
        if (this.contextCalibratorList != null) {
            sb.append(", contextCalibrators: ").append(this.contextCalibratorList);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public IntegerDataEncoding copy() {
        return new IntegerDataEncoding(this);
    }

    public static class Builder
    extends DataEncoding.Builder<Builder>
    implements NumericDataEncoding.Builder<Builder> {
        Calibrator defaultCalibrator = null;
        private List<ContextCalibrator> contextCalibratorList = null;
        Encoding encoding = null;
        StringDataEncoding stringEncoding = null;

        public Builder(IntegerDataEncoding encoding) {
            super(encoding);
            this.defaultCalibrator = encoding.defaultCalibrator;
            this.contextCalibratorList = encoding.contextCalibratorList;
            this.encoding = encoding.encoding;
            this.stringEncoding = encoding.stringEncoding;
        }

        public Builder() {
        }

        @Override
        public IntegerDataEncoding build() {
            return new IntegerDataEncoding(this);
        }

        public Builder setStringEncoding(StringDataEncoding stringEncoding) {
            this.stringEncoding = stringEncoding;
            this.sizeInBits = stringEncoding.sizeInBits;
            this.encoding = Encoding.STRING;
            return (Builder)this.self();
        }

        @Override
        public Builder setDefaultCalibrator(Calibrator defaultCalibrator) {
            this.defaultCalibrator = defaultCalibrator;
            return (Builder)this.self();
        }

        public Builder setEncoding(Encoding enc) {
            this.encoding = enc;
            return (Builder)this.self();
        }

        @Override
        public Builder setByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return (Builder)this.self();
        }

        @Override
        public Builder setContextCalibratorList(List<ContextCalibrator> list) {
            this.contextCalibratorList = list;
            return (Builder)this.self();
        }
    }

    public static enum Encoding {
        UNSIGNED,
        TWOS_COMPLEMENT,
        SIGN_MAGNITUDE,
        ONES_COMPLEMENT,
        STRING;

    }
}

