/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yamcs.utils.DoubleRange;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.AlarmRanges;
import org.yamcs.xtce.IntegerDataType;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.NumericAlarm;
import org.yamcs.xtce.NumericContextAlarm;
import org.yamcs.xtce.NumericParameterType;
import org.yamcs.xtce.Parameter;

public class IntegerParameterType
extends IntegerDataType
implements NumericParameterType {
    private static final long serialVersionUID = 2L;
    List<NumericContextAlarm> contextAlarmList = null;
    NumericAlarm defaultAlarm = null;

    public IntegerParameterType(Builder builder) {
        super(builder);
        this.contextAlarmList = builder.contextAlarmList;
        this.defaultAlarm = builder.defaultAlarm;
        if (builder.baseType != null && builder.baseType instanceof IntegerParameterType) {
            IntegerParameterType baseType = (IntegerParameterType)builder.baseType;
            if (builder.defaultAlarm == null && baseType.defaultAlarm != null) {
                this.defaultAlarm = baseType.defaultAlarm;
            }
            if (builder.contextAlarmList == null && baseType.contextAlarmList != null) {
                this.contextAlarmList = baseType.contextAlarmList;
            }
        }
    }

    public IntegerParameterType(IntegerParameterType t) {
        super(t);
        this.defaultAlarm = t.defaultAlarm;
        this.contextAlarmList = t.contextAlarmList;
    }

    @Override
    public NumericAlarm getDefaultAlarm() {
        return this.defaultAlarm;
    }

    public List<NumericContextAlarm> getContextAlarmList() {
        return this.contextAlarmList;
    }

    @Override
    public boolean hasAlarm() {
        return this.defaultAlarm != null || this.contextAlarmList != null && !this.contextAlarmList.isEmpty();
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        if (this.getContextAlarmList() == null) {
            return this.encoding != null ? this.encoding.getDependentParameters() : Collections.emptySet();
        }
        HashSet<Parameter> dependentParameters = new HashSet<Parameter>();
        for (NumericContextAlarm nca : this.contextAlarmList) {
            dependentParameters.addAll(nca.getContextMatch().getDependentParameters());
        }
        return dependentParameters;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "IntegerDataType name:" + this.name + " sizeInBits:" + this.sizeInBits + " signed:" + this.signed + " encoding:" + this.encoding + (this.defaultAlarm != null ? ", defaultAlarm:" + this.defaultAlarm : "") + (this.contextAlarmList != null ? ", contextAlarmList:" + this.contextAlarmList : "");
    }

    public static class Builder
    extends IntegerDataType.Builder<Builder>
    implements NumericParameterType.Builder<Builder> {
        List<NumericContextAlarm> contextAlarmList = null;
        NumericAlarm defaultAlarm = null;

        public Builder() {
        }

        public Builder(IntegerParameterType integerParameterType) {
            super(integerParameterType);
            this.contextAlarmList = integerParameterType.contextAlarmList;
            this.defaultAlarm = integerParameterType.defaultAlarm;
        }

        @Override
        public void setDefaultAlarm(NumericAlarm defaultAlarm) {
            this.defaultAlarm = defaultAlarm;
        }

        public void setNumericContextAlarmList(List<NumericContextAlarm> numericContextAlarmList) {
            this.contextAlarmList = numericContextAlarmList;
        }

        private AlarmRanges getAlarmRanges(MatchCriteria contextMatch) {
            NumericAlarm alarm = this.createOrGetAlarm(contextMatch);
            return alarm.getStaticAlarmRanges();
        }

        public void setDefaultWatchAlarmRange(DoubleRange watchRange) {
            this.getAlarmRanges(null).watchRange = watchRange;
        }

        public void setDefaultWarningAlarmRange(DoubleRange warningRange) {
            this.getAlarmRanges(null).warningRange = warningRange;
        }

        public void setDefaultDistressAlarmRange(DoubleRange distressRange) {
            this.getAlarmRanges(null).distressRange = distressRange;
        }

        public void setDefaultCriticalAlarmRange(DoubleRange criticalRange) {
            this.getAlarmRanges(null).criticalRange = criticalRange;
        }

        public void setDefaultSevereAlarmRange(DoubleRange severeRange) {
            this.getAlarmRanges(null).severeRange = severeRange;
        }

        public void addAlarmRange(MatchCriteria contextMatch, DoubleRange range, AlarmLevels level) {
            this.getAlarmRanges(contextMatch).addRange(range, level);
        }

        public void addWatchAlarmRange(MatchCriteria contextMatch, DoubleRange watchRange) {
            this.getAlarmRanges(contextMatch).addWatchRange(watchRange);
        }

        public void addWarningAlarmRange(MatchCriteria contextMatch, DoubleRange warningRange) {
            this.getAlarmRanges(contextMatch).addWarningRange(warningRange);
        }

        public void addDistressAlarmRange(MatchCriteria contextMatch, DoubleRange distressRange) {
            this.getAlarmRanges(contextMatch).addDistressRange(distressRange);
        }

        public void addCriticalAlarmRange(MatchCriteria contextMatch, DoubleRange criticalRange) {
            this.getAlarmRanges(contextMatch).addCriticalRange(criticalRange);
        }

        public void addSevereAlarmRange(MatchCriteria contextMatch, DoubleRange severeRange) {
            this.getAlarmRanges(contextMatch).addSevereRange(severeRange);
        }

        public void addContextAlarm(NumericContextAlarm nca) {
            if (this.contextAlarmList == null) {
                this.contextAlarmList = new ArrayList<NumericContextAlarm>();
            }
            this.contextAlarmList.add(nca);
        }

        public void addContextAlarms(Collection<NumericContextAlarm> ncas) {
            if (this.contextAlarmList == null) {
                this.contextAlarmList = new ArrayList<NumericContextAlarm>();
            }
            this.contextAlarmList.addAll(ncas);
        }

        public NumericContextAlarm getNumericContextAlarm(MatchCriteria context) {
            if (this.contextAlarmList == null) {
                return null;
            }
            for (NumericContextAlarm nca : this.contextAlarmList) {
                if (!nca.getContextMatch().equals(context)) continue;
                return nca;
            }
            return null;
        }

        public NumericAlarm createOrGetAlarm(MatchCriteria contextMatch) {
            if (contextMatch == null) {
                if (this.defaultAlarm == null) {
                    this.defaultAlarm = new NumericAlarm();
                }
                return this.defaultAlarm;
            }
            NumericContextAlarm nca = this.getNumericContextAlarm(contextMatch);
            if (nca == null) {
                nca = new NumericContextAlarm();
                nca.setContextMatch(contextMatch);
                this.addContextAlarm(nca);
            }
            return nca;
        }

        public NumericAlarm getDefaultAlarm() {
            return this.defaultAlarm;
        }

        @Override
        public IntegerParameterType build() {
            return new IntegerParameterType(this);
        }

        @Override
        public void setContextAlarmList(List<NumericContextAlarm> contextAlarmList) {
            this.contextAlarmList = contextAlarmList;
        }
    }
}

