/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.yamcs.xtce.ANDedConditions;
import org.yamcs.xtce.Comparison;
import org.yamcs.xtce.ComparisonList;
import org.yamcs.xtce.Condition;
import org.yamcs.xtce.CriteriaEvaluator;
import org.yamcs.xtce.ExpressionList;
import org.yamcs.xtce.ORedConditions;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterInstanceRef;

public interface MatchCriteria
extends Serializable {
    public static final MatchCriteria ALWAYS_MATCH = new MatchCriteria(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isMet(CriteriaEvaluator evaluator) {
            return true;
        }

        @Override
        public Set<Parameter> getDependentParameters() {
            return Collections.emptySet();
        }

        @Override
        public String toExpressionString() {
            return "true";
        }
    };

    public Set<Parameter> getDependentParameters();

    public boolean isMet(CriteriaEvaluator var1);

    public String toExpressionString();

    public static String printExpressionReference(ParameterInstanceRef ref) {
        if (!ref.useCalibratedValue()) {
            return "'raw://" + ref.getParameter().getQualifiedName() + "'";
        }
        return "'" + ref.getParameter().getQualifiedName() + "'";
    }

    public static String printExpressionValue(Object value) {
        if (value != null && value instanceof String) {
            String escaped = ((String)value).replace("\\", "\\\\").replace("\"", "\\\"");
            return "\"" + escaped + "\"";
        }
        return String.valueOf(value);
    }

    public static void printParsedMatchCriteria(Logger log, MatchCriteria criteria, String indent) {
        if (criteria instanceof Comparison) {
            log.fine(indent + criteria.toString());
        } else if (criteria instanceof ComparisonList) {
            log.fine(indent + "ComparisonList (");
            for (Comparison comparison : ((ComparisonList)criteria).comparisons) {
                log.fine(indent + "  " + comparison.toString());
            }
            log.fine(indent + ")");
        } else if (criteria instanceof Condition) {
            log.fine(indent + criteria.toString());
        } else if (criteria instanceof ANDedConditions) {
            log.fine(indent + "AND (");
            for (MatchCriteria matchCriteria : ((ExpressionList)criteria).expressions) {
                MatchCriteria.printParsedMatchCriteria(log, matchCriteria, indent + "  ");
            }
            log.fine(indent + ")");
        } else if (criteria instanceof ORedConditions) {
            log.fine(indent + "OR (");
            for (MatchCriteria matchCriteria : ((ExpressionList)criteria).expressions) {
                MatchCriteria.printParsedMatchCriteria(log, matchCriteria, indent + "  ");
            }
            log.fine(indent + ")");
        }
    }
}

