/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.yamcs.xtce.AncillaryData;
import org.yamcs.xtce.Container;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.SequenceEntry;

public class SequenceContainer
extends Container {
    private static final long serialVersionUID = 4L;
    List<SequenceEntry> entryList = new ArrayList<SequenceEntry>();
    private boolean useAsArchivePartition = false;

    public SequenceContainer(String name) {
        super(name);
    }

    @Override
    public void addAncillaryData(AncillaryData data) {
        super.addAncillaryData(data);
        if (this.isArchivePartition(data)) {
            this.useAsArchivePartition = true;
        }
    }

    @Override
    public void setAncillaryData(List<AncillaryData> ancillaryData) {
        super.setAncillaryData(ancillaryData);
        Optional<AncillaryData> o = ancillaryData.stream().filter(ad -> this.isArchivePartition((AncillaryData)ad)).findAny();
        if (o.isPresent()) {
            this.useAsArchivePartition = true;
        }
    }

    private boolean isArchivePartition(AncillaryData ad) {
        return "Yamcs".equalsIgnoreCase(ad.getName()) && "UseAsArchivingPartition".equalsIgnoreCase(ad.getValue());
    }

    @Override
    public SequenceContainer getBaseContainer() {
        return (SequenceContainer)this.baseContainer;
    }

    @Override
    public void setBaseContainer(Container baseContainer) {
        if (!(baseContainer instanceof SequenceContainer)) {
            throw new IllegalArgumentException("The SequenceContainer expects a SequenceContainer as base container");
        }
        this.baseContainer = (SequenceContainer)baseContainer;
    }

    @Override
    public MatchCriteria getRestrictionCriteria() {
        return this.restrictionCriteria;
    }

    @Override
    public void addEntry(SequenceEntry entry) {
        this.entryList.add(entry);
        entry.setIndex(this.entryList.size() - 1);
        entry.setContainer(this);
    }

    public void insertEntry(int idx, SequenceEntry entry) {
        this.entryList.add(idx, entry);
        for (int i = idx; i < this.entryList.size(); ++i) {
            SequenceEntry se = this.entryList.get(i);
            se.setIndex(i);
            se.setContainer(this);
        }
    }

    public void setEntryList(List<SequenceEntry> entryList) {
        this.entryList = entryList;
        for (int i = 0; i < entryList.size(); ++i) {
            SequenceEntry entry = entryList.get(i);
            entry.setIndex(i);
            entry.setContainer(this);
        }
    }

    @Override
    public List<SequenceEntry> getEntryList() {
        return Collections.unmodifiableList(this.entryList);
    }

    public boolean useAsArchivePartition() {
        return this.useAsArchivePartition;
    }

    public void useAsArchivePartition(boolean useAsArchivePartition) {
        this.useAsArchivePartition = useAsArchivePartition;
        if (this.ancillaryData != null) {
            this.ancillaryData.removeIf(ad -> this.isArchivePartition((AncillaryData)ad));
        }
        if (useAsArchivePartition) {
            this.addAncillaryData(new AncillaryData("Yamcs", "UseAsArchivingPartition"));
        }
    }

    public void print(PrintStream out) {
        out.print("SequenceContainer name: " + this.name + (this.sizeInBits > -1 ? ", sizeInBits: " + this.sizeInBits : ""));
        if (this.getAliasSet() != null) {
            out.print(", aliases: " + this.getAliasSet());
        }
        out.print(", useAsArchivePartition:" + this.useAsArchivePartition);
        if (this.rate != null) {
            out.print(", rateInStream: " + this.rate);
        }
        out.println();
        if (this.baseContainer != null) {
            out.print("\tbaseContainer: '" + this.baseContainer.getQualifiedName());
            out.println("', restrictionCriteria: " + this.restrictionCriteria);
        }
        for (SequenceEntry se : this.getEntryList()) {
            out.println("\t\t" + se);
        }
    }

    public String toString() {
        return "SequenceContainer(name=" + this.name + ")";
    }
}

