/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import org.yamcs.xtce.Container;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.Repeat;
import org.yamcs.xtce.SequenceContainer;

public abstract class SequenceEntry
implements Serializable,
Comparable<SequenceEntry> {
    private static final long serialVersionUID = 3L;
    protected Container container;
    protected int locationInContainerInBits = 0;
    int index;
    ReferenceLocationType referenceLocation = ReferenceLocationType.PREVIOUS_ENTRY;
    Repeat repeatEntry = null;
    private MatchCriteria includeCondition = null;

    public SequenceEntry() {
    }

    public SequenceEntry(int locationInContainerInBits, ReferenceLocationType location) {
        this.locationInContainerInBits = locationInContainerInBits;
        this.referenceLocation = location;
    }

    void setContainer(Container container) {
        this.container = container;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public Container getContainer() {
        return this.container;
    }

    public SequenceContainer getSequenceContainer() {
        if (this.container instanceof SequenceContainer) {
            return (SequenceContainer)this.container;
        }
        return null;
    }

    public void setLocationInContainerInBits(int locationInBits) {
        this.locationInContainerInBits = locationInBits;
    }

    public int getLocationInContainerInBits() {
        return this.locationInContainerInBits;
    }

    public void setReferenceLocation(ReferenceLocationType type) {
        this.referenceLocation = type;
    }

    public void setLocation(ReferenceLocationType type, int locationInBits) {
        this.referenceLocation = type;
        this.locationInContainerInBits = locationInBits;
    }

    @Override
    public int compareTo(SequenceEntry se) {
        return this.index - se.index;
    }

    public ReferenceLocationType getReferenceLocation() {
        return this.referenceLocation;
    }

    public int getIndex() {
        return this.index;
    }

    public Repeat getRepeatEntry() {
        return this.repeatEntry;
    }

    public void setRepeatEntry(Repeat repeat) {
        this.repeatEntry = repeat;
    }

    public MatchCriteria getIncludeCondition() {
        return this.includeCondition;
    }

    public void setIncludeCondition(MatchCriteria includeCondition) {
        this.includeCondition = includeCondition;
    }

    public static enum ReferenceLocationType {
        CONTAINER_START("containerStart"),
        PREVIOUS_ENTRY("previousEntry");

        final String xtceName;

        private ReferenceLocationType(String xtceName) {
            this.xtceName = xtceName;
        }

        String xtceName() {
            return this.xtceName;
        }
    }
}

