/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.xtce.Algorithm;
import org.yamcs.xtce.ArgumentType;
import org.yamcs.xtce.CommandContainer;
import org.yamcs.xtce.Header;
import org.yamcs.xtce.MetaCommand;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.NonStandardData;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.SequenceContainer;
import org.yamcs.xtce.util.NameReference;
import org.yamcs.xtce.xml.XtceAliasSet;

public class SpaceSystem
extends NameDescription {
    private static final long serialVersionUID = 6L;
    private SequenceContainer rootSequenceContainer;
    Header header;
    private Map<String, SequenceContainer> containers = new LinkedHashMap<String, SequenceContainer>();
    private Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
    private HashMap<String, ParameterType> parameterTypes = new HashMap();
    private HashMap<String, Algorithm> algorithms = new HashMap();
    private HashMap<String, MetaCommand> commands = new HashMap();
    private HashMap<Class<?>, NonStandardData> nonStandardDatas = new HashMap();
    private Map<String, CommandContainer> cmdContainers = new LinkedHashMap<String, CommandContainer>();
    private Map<String, SpaceSystem> subsystems = new LinkedHashMap<String, SpaceSystem>();
    static Logger log = LoggerFactory.getLogger((String)SpaceSystem.class.getName());
    private HashMap<String, ArgumentType> argumentTypes = new HashMap();
    transient List<NameReference> unresolvedReferences = new ArrayList<NameReference>();
    SpaceSystem parent;

    public SpaceSystem(String name) {
        super(name);
    }

    public void setHeader(Header h) {
        this.header = h;
    }

    public void addSequenceContainer(SequenceContainer container) {
        if (this.containers.containsKey(container.getName())) {
            throw new IllegalArgumentException("there is already a container with name " + container.getName());
        }
        this.containers.put(container.getName(), container);
    }

    public void addParameter(Parameter parameter) throws IllegalArgumentException {
        if (this.parameters.containsKey(parameter.getName())) {
            throw new IllegalArgumentException("there is already a parameter with name " + parameter.getName() + " in space system " + (this.qualifiedName == null ? this.name : this.qualifiedName));
        }
        this.parameters.put(parameter.getName(), parameter);
    }

    public void addParameterType(ParameterType parameterType) {
        String ptn = ((NameDescription)((Object)parameterType)).getName();
        if (this.parameterTypes.containsKey(ptn)) {
            throw new IllegalArgumentException("there is already a parameter type with name '" + ptn + "'");
        }
        this.parameterTypes.put(ptn, parameterType);
    }

    public boolean removeParameterType(ParameterType ptype) {
        return this.parameterTypes.remove(ptype.getName(), ptype);
    }

    public void addArgumentType(ArgumentType argumentType) {
        String atn = ((NameDescription)((Object)argumentType)).getName();
        if (this.argumentTypes.containsKey(atn)) {
            throw new IllegalArgumentException("there is already a argument type with name '" + atn + "'");
        }
        this.argumentTypes.put(atn, argumentType);
    }

    public void addAlgorithm(Algorithm algorithm) {
        if (this.algorithms.containsKey(algorithm.getName())) {
            throw new IllegalArgumentException("there is already an algorithm with name " + algorithm.getName());
        }
        this.algorithms.put(algorithm.getName(), algorithm);
    }

    public void addMetaCommand(MetaCommand command) {
        if (this.commands.containsKey(command.getName())) {
            throw new IllegalArgumentException("there is already a command with name " + command.getName());
        }
        this.commands.put(command.getName(), command);
    }

    public MetaCommand getMetaCommand(String refName) {
        return this.commands.get(refName);
    }

    public ParameterType getParameterType(String typeName) {
        return this.parameterTypes.get(typeName);
    }

    public ArgumentType getArgumentType(String typeName) {
        return this.argumentTypes.get(typeName);
    }

    public SequenceContainer getSequenceContainer(String refName) {
        return this.containers.get(refName);
    }

    public void addCommandContainer(CommandContainer cmdContainer) {
        if (this.cmdContainers.containsKey(cmdContainer.getName())) {
            throw new IllegalArgumentException("there is already a command container with name " + cmdContainer.getName());
        }
        this.cmdContainers.put(cmdContainer.getName(), cmdContainer);
    }

    public CommandContainer getCommandContainer(String name) {
        return this.cmdContainers.get(name);
    }

    public Algorithm getAlgorithm(String algoName) {
        return this.algorithms.get(algoName);
    }

    public Parameter getParameter(String refName) {
        return this.parameters.get(refName);
    }

    public void addSpaceSystem(SpaceSystem ss) throws IllegalArgumentException {
        if (this.subsystems.containsKey(ss.getName())) {
            throw new IllegalArgumentException("there is already a subsystem with name " + ss.getName());
        }
        this.subsystems.put(ss.getName(), ss);
        ss.setParent(this);
    }

    public void addUnresolvedReference(NameReference nr) {
        boolean resolved = false;
        NameDescription nd = null;
        switch (nr.getType()) {
            case PARAMETER: {
                nd = this.getParameter(nr.getReference());
                break;
            }
            case ALGORITHM: {
                nd = this.getAlgorithm(nr.getReference());
                break;
            }
            case COMMAND_CONTAINER: {
                nd = this.getCommandContainer(nr.getReference());
                break;
            }
            case META_COMMAND: {
                nd = this.getMetaCommand(nr.getReference());
                break;
            }
            case SEQUENCE_CONTAINER: {
                nd = this.getSequenceContainer(nr.getReference());
                break;
            }
        }
        if (nd != null) {
            resolved = nr.tryResolve(nd);
        }
        if (!resolved) {
            this.unresolvedReferences.add(nr);
        }
    }

    public Collection<SequenceContainer> getSequenceContainers() {
        return this.containers.values();
    }

    public Collection<CommandContainer> getCommandContainers() {
        return this.cmdContainers.values();
    }

    public int getSequenceContainerCount(boolean recurse) {
        if (!recurse) {
            return this.containers.size();
        }
        int total = this.containers.size();
        for (SpaceSystem sub : this.getSubSystems()) {
            total += sub.getSequenceContainerCount(recurse);
        }
        return total;
    }

    public Collection<Parameter> getParameters() {
        return this.parameters.values();
    }

    public Collection<Parameter> getParameters(boolean recurse) {
        if (!recurse) {
            return this.getParameters();
        }
        ArrayList<Parameter> res = new ArrayList<Parameter>();
        res.addAll(this.parameters.values());
        for (SpaceSystem sub : this.getSubSystems()) {
            res.addAll(sub.getParameters(recurse));
        }
        return res;
    }

    public int getParameterCount(boolean recurse) {
        if (!recurse) {
            return this.parameters.size();
        }
        int total = this.parameters.size();
        for (SpaceSystem sub : this.getSubSystems()) {
            total += sub.getParameterCount(recurse);
        }
        return total;
    }

    public Collection<ParameterType> getParameterTypes() {
        return this.parameterTypes.values();
    }

    public Collection<ArgumentType> getArgumentTypes() {
        return this.argumentTypes.values();
    }

    public Collection<SpaceSystem> getSubSystems() {
        return this.subsystems.values();
    }

    public Collection<Algorithm> getAlgorithms() {
        return this.algorithms.values();
    }

    public int getAlgorithmCount(boolean recurse) {
        if (!recurse) {
            return this.algorithms.size();
        }
        int total = this.algorithms.size();
        for (SpaceSystem sub : this.getSubSystems()) {
            total += sub.getAlgorithmCount(recurse);
        }
        return total;
    }

    public Collection<MetaCommand> getMetaCommands() {
        return this.commands.values();
    }

    public void removeParameter(Parameter p) {
        this.parameters.remove(p.getName());
    }

    public int getMetaCommandCount(boolean recurse) {
        if (!recurse) {
            return this.commands.size();
        }
        int total = this.commands.size();
        for (SpaceSystem sub : this.getSubSystems()) {
            total += sub.getMetaCommandCount(recurse);
        }
        return total;
    }

    public List<NameReference> getUnresolvedReferences() {
        return this.unresolvedReferences;
    }

    public void setParent(SpaceSystem parent) {
        this.parent = parent;
    }

    public SpaceSystem getParent() {
        return this.parent;
    }

    public SpaceSystem getSubsystem(String sname) {
        return this.subsystems.get(sname);
    }

    public SequenceContainer getRootSequenceContainer() {
        return this.rootSequenceContainer;
    }

    public void setRootSequenceContainer(SequenceContainer sc) {
        this.rootSequenceContainer = sc;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addNonStandardData(NonStandardData data) {
        if (this.nonStandardDatas.containsKey(data.getClass())) {
            throw new IllegalArgumentException("there is already non-standard data of type " + data.getClass());
        }
        this.nonStandardDatas.put(data.getClass(), data);
    }

    public <T extends NonStandardData> T getNonStandardDataOfType(Class<T> clazz) {
        if (this.nonStandardDatas.containsKey(clazz)) {
            return (T)this.nonStandardDatas.get(clazz);
        }
        return null;
    }

    public Collection<NonStandardData> getNonStandardData() {
        return this.nonStandardDatas.values();
    }

    public String toString() {
        return "SpaceSystem[" + this.getName() + "]";
    }

    public List<Parameter> getParameterByAlias(String alias) {
        return SpaceSystem.getObjectByAlias(alias, this.parameters.values());
    }

    public List<SequenceContainer> getSequenceContainerByAlias(String alias) {
        return SpaceSystem.getObjectByAlias(alias, this.containers.values());
    }

    public List<MetaCommand> getMetaCommandByAlias(String alias) {
        return SpaceSystem.getObjectByAlias(alias, this.commands.values());
    }

    private static <T extends NameDescription> List<T> getObjectByAlias(String alias, Collection<T> ndObjects) {
        ArrayList<NameDescription> l = new ArrayList<NameDescription>(1);
        for (NameDescription nd : ndObjects) {
            XtceAliasSet aliasSet = nd.getAliasSet();
            if (aliasSet == null) continue;
            for (Map.Entry<String, String> m : nd.getAliasSet().getAliases().entrySet()) {
                if (!m.getValue().equals(alias)) continue;
                l.add(nd);
            }
        }
        return l;
    }
}

