/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.nio.charset.Charset;
import org.yamcs.xtce.DataEncoding;

public class StringDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 1L;
    private SizeType sizeType;
    private byte terminationChar = 0;
    int sizeInBitsOfSizeTag = 16;
    private String encoding = "UTF-8";

    public StringDataEncoding(Builder builder) {
        super(builder, -1);
        this.sizeType = builder.sizeType;
        if (builder.terminationChar != null) {
            this.terminationChar = builder.terminationChar;
        }
        if (builder.sizeInBitsOfSizeTag != null) {
            this.sizeInBitsOfSizeTag = builder.sizeInBitsOfSizeTag;
        }
        if (builder.encoding != null) {
            this.encoding = builder.encoding;
        }
        if (builder.baseEncoding != null && builder.baseEncoding instanceof StringDataEncoding) {
            StringDataEncoding baseEncoding = (StringDataEncoding)builder.baseEncoding;
            if (builder.sizeType == null) {
                this.sizeType = baseEncoding.sizeType;
            }
            if (builder.terminationChar == null) {
                this.terminationChar = baseEncoding.terminationChar;
            }
            if (builder.sizeInBitsOfSizeTag == null) {
                this.sizeInBitsOfSizeTag = baseEncoding.sizeInBitsOfSizeTag;
            }
            if (builder.encoding == null) {
                this.encoding = baseEncoding.encoding;
            }
        }
    }

    StringDataEncoding(StringDataEncoding sde) {
        super(sde);
        this.sizeType = sde.sizeType;
        this.terminationChar = sde.terminationChar;
        this.sizeInBitsOfSizeTag = sde.sizeInBitsOfSizeTag;
        this.encoding = sde.encoding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public void setSizeType(SizeType sizeType) {
        this.sizeType = sizeType;
    }

    public SizeType getSizeType() {
        return this.sizeType;
    }

    public int getSizeInBitsOfSizeTag() {
        return this.sizeInBitsOfSizeTag;
    }

    public void setSizeInBitsOfSizeTag(int sizeInBits) {
        this.sizeInBitsOfSizeTag = sizeInBits;
    }

    public byte getTerminationChar() {
        return this.terminationChar;
    }

    public void setTerminationChar(byte tc) {
        this.terminationChar = tc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StringDataEncoding size: ");
        sb.append((Object)this.getSizeType()).append("(");
        switch (this.getSizeType()) {
            case FIXED: {
                sb.append("fixedSizeInBits=" + this.getSizeInBits());
                break;
            }
            case LEADING_SIZE: {
                sb.append("sizeInBitsOfSizeTag=" + this.getSizeInBitsOfSizeTag());
                if (this.getSizeInBits() == -1) break;
                sb.append(", sizeInBits=" + this.getSizeInBits());
                break;
            }
            case TERMINATION_CHAR: {
                sb.append("terminationChar=" + this.getTerminationChar());
                if (this.getSizeInBits() == -1) break;
                sb.append(", sizeInBits=" + this.getSizeInBits());
                break;
            }
            case CUSTOM: {
                sb.append(this.getFromBinaryTransformAlgorithm());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Object parseString(String stringValue) {
        return stringValue;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        Charset.forName(encoding);
        this.encoding = encoding;
    }

    @Override
    public StringDataEncoding copy() {
        return new StringDataEncoding(this);
    }

    public static class Builder
    extends DataEncoding.Builder<Builder> {
        private SizeType sizeType;
        private Byte terminationChar = null;
        Integer sizeInBitsOfSizeTag = null;
        private String encoding = "UTF-8";

        public Builder(StringDataEncoding encoding) {
            super(encoding);
            this.sizeType = encoding.sizeType;
            this.terminationChar = encoding.terminationChar;
            this.sizeInBitsOfSizeTag = encoding.sizeInBitsOfSizeTag;
        }

        public Builder() {
        }

        @Override
        public StringDataEncoding build() {
            return new StringDataEncoding(this);
        }

        public Builder setSizeType(SizeType sizeType) {
            this.sizeType = sizeType;
            return (Builder)this.self();
        }

        public Builder setTerminationChar(byte terminationChar) {
            this.terminationChar = terminationChar;
            return (Builder)this.self();
        }

        public Builder setSizeInBitsOfSizeTag(int size) {
            this.sizeInBitsOfSizeTag = size;
            return (Builder)this.self();
        }

        public Builder setEncoding(String stringEncoding) {
            this.encoding = stringEncoding;
            return (Builder)this.self();
        }

        public SizeType getSizeType() {
            return this.sizeType;
        }
    }

    public static enum SizeType {
        FIXED,
        TERMINATION_CHAR,
        LEADING_SIZE,
        CUSTOM;

    }
}

