/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.Algorithm;
import org.yamcs.xtce.ContainerEntry;
import org.yamcs.xtce.IndirectParameterRefEntry;
import org.yamcs.xtce.InputParameter;
import org.yamcs.xtce.MetaCommand;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.NamedDescriptionIndex;
import org.yamcs.xtce.NonStandardData;
import org.yamcs.xtce.OutputParameter;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterEntry;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.SequenceContainer;
import org.yamcs.xtce.SequenceEntry;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.SystemParameter;
import org.yamcs.xtce.xml.XtceAliasSet;

public class XtceDb
implements Serializable {
    private static final long serialVersionUID = 57L;
    final SpaceSystem rootSystem;
    ReadWriteLock rwLock = new ReentrantReadWriteLock();
    public static final String YAMCS_SPACESYSTEM_NAME = "/yamcs";
    public static final String YAMCS_CMD_SPACESYSTEM_NAME = "/yamcs/cmd";
    public static final String YAMCS_CMDHIST_SPACESYSTEM_NAME = "/yamcs/cmdHist";
    static transient Logger log = LoggerFactory.getLogger(XtceDb.class);
    private HashMap<String, SpaceSystem> spaceSystems = new HashMap();
    private Map<String, SequenceContainer> sequenceContainers = new LinkedHashMap<String, SequenceContainer>();
    private Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
    private Map<String, ParameterType> parameterTypes = new LinkedHashMap<String, ParameterType>();
    private HashMap<String, Algorithm> algorithms = new HashMap();
    private HashMap<String, MetaCommand> commands = new HashMap();
    private HashMap<Class<?>, NonStandardData> nonStandardDatas = new HashMap();
    private NamedDescriptionIndex<SpaceSystem> spaceSystemAliases = new NamedDescriptionIndex();
    private NamedDescriptionIndex<Parameter> parameterAliases = new NamedDescriptionIndex();
    private NamedDescriptionIndex<NameDescription> parameterTypeAliases = new NamedDescriptionIndex();
    private NamedDescriptionIndex<SequenceContainer> sequenceContainerAliases = new NamedDescriptionIndex();
    private NamedDescriptionIndex<Algorithm> algorithmAliases = new NamedDescriptionIndex();
    private NamedDescriptionIndex<MetaCommand> commandAliases = new NamedDescriptionIndex();
    private Map<String, List<IndirectParameterRefEntry>> indirectParameterRefEntries = new HashMap<String, List<IndirectParameterRefEntry>>();
    private Set<String> namespaces = new HashSet<String>();
    SequenceContainer rootSequenceContainer;
    private HashMap<Parameter, ArrayList<ParameterEntry>> parameter2ParameterEntryMap;
    private HashMap<SequenceContainer, ArrayList<ContainerEntry>> sequenceContainer2ContainerEntryMap;
    private HashMap<SequenceContainer, ArrayList<SequenceContainer>> sequenceContainer2InheritingContainerMap;

    public XtceDb(SpaceSystem spaceSystem) {
        this.rootSystem = spaceSystem;
    }

    public SequenceContainer getSequenceContainer(String qualifiedName) {
        return this.sequenceContainers.get(qualifiedName);
    }

    public SequenceContainer getSequenceContainer(String namespace, String name) {
        return this.sequenceContainerAliases.get(namespace, name);
    }

    public SequenceContainer getSequenceContainer(Yamcs.NamedObjectId id) {
        if (id.hasNamespace()) {
            return this.sequenceContainerAliases.get(id.getNamespace(), id.getName());
        }
        return this.sequenceContainerAliases.get(id.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getParameter(String qualifiedName) {
        this.rwLock.readLock().lock();
        try {
            int idx = qualifiedName.indexOf(47);
            if (idx == 0) {
                Parameter parameter = this.parameters.get(qualifiedName);
                return parameter;
            }
            if (idx > 0) {
                String namespace = qualifiedName.substring(0, idx);
                String name = qualifiedName.substring(idx + 1);
                Parameter parameter = this.getParameter(namespace, name);
                return parameter;
            }
            Parameter parameter = null;
            return parameter;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public static Yamcs.NamedObjectId toNamedObjectId(String qualifiedName) {
        int idx = qualifiedName.indexOf(47);
        if (idx == 0) {
            return Yamcs.NamedObjectId.newBuilder().setName(qualifiedName).build();
        }
        if (idx > 0) {
            return Yamcs.NamedObjectId.newBuilder().setNamespace(qualifiedName.substring(0, idx)).setName(qualifiedName.substring(idx + 1)).build();
        }
        throw new IllegalArgumentException("Invalid parameter id " + qualifiedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getParameter(String namespace, String name) {
        this.rwLock.readLock().lock();
        try {
            Parameter parameter = this.parameterAliases.get(namespace, name);
            return parameter;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Parameter getParameter(Yamcs.NamedObjectId id) {
        this.rwLock.readLock().lock();
        try {
            if (id.hasNamespace()) {
                Parameter parameter = this.parameterAliases.get(id.getNamespace(), id.getName());
                return parameter;
            }
            Parameter parameter = this.parameterAliases.get(id.getName());
            return parameter;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public ParameterType getParameterType(String qualifiedName) {
        return this.parameterTypes.get(qualifiedName);
    }

    public ParameterType getParameterType(String namespace, String name) {
        return (ParameterType)((Object)this.parameterTypeAliases.get(namespace, name));
    }

    public ParameterType getParameterType(Yamcs.NamedObjectId id) {
        if (id.hasNamespace()) {
            return (ParameterType)((Object)this.parameterTypeAliases.get(id.getNamespace(), id.getName()));
        }
        return (ParameterType)((Object)this.parameterTypeAliases.get(id.getName()));
    }

    public SequenceContainer getRootSequenceContainer() {
        return this.rootSequenceContainer;
    }

    public void setRootSequenceContainer(SequenceContainer sc) {
        this.rootSequenceContainer = sc;
    }

    public Algorithm getAlgorithm(String qualifiedName) {
        return this.algorithmAliases.get(qualifiedName);
    }

    public Algorithm getAlgorithm(String namespace, String name) {
        return this.algorithmAliases.get(namespace, name);
    }

    public Algorithm getAlgorithm(Yamcs.NamedObjectId id) {
        if (id.hasNamespace()) {
            return this.algorithmAliases.get(id.getNamespace(), id.getName());
        }
        return this.algorithmAliases.get(id.getName());
    }

    public Collection<Algorithm> getAlgorithms() {
        return this.algorithms.values();
    }

    public Collection<Parameter> getParameters() {
        this.rwLock.readLock().lock();
        try {
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>(this.parameters.values());
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Collection<ParameterType> getParameterTypes() {
        return this.parameterTypes.values();
    }

    public boolean containsNamespace(String namespace) {
        return this.namespaces.contains(namespace);
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    public MetaCommand getMetaCommand(String qualifiedName) {
        this.rwLock.readLock().lock();
        try {
            MetaCommand metaCommand = this.commandAliases.get(qualifiedName);
            return metaCommand;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaCommand getMetaCommand(String namespace, String name) {
        this.rwLock.readLock().lock();
        try {
            MetaCommand metaCommand = this.commandAliases.get(namespace, name);
            return metaCommand;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public MetaCommand getMetaCommand(Yamcs.NamedObjectId id) {
        this.rwLock.readLock().lock();
        try {
            if (id.hasNamespace()) {
                MetaCommand metaCommand = this.commandAliases.get(id.getNamespace(), id.getName());
                return metaCommand;
            }
            MetaCommand metaCommand = this.commandAliases.get(id.getName());
            return metaCommand;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Collection<MetaCommand> getMetaCommands() {
        this.rwLock.readLock().lock();
        try {
            Collection<MetaCommand> collection = this.commands.values();
            return collection;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public SpaceSystem getRootSpaceSystem() {
        return this.rootSystem;
    }

    public SpaceSystem getSpaceSystem(String qualifiedName) {
        this.rwLock.readLock().lock();
        try {
            SpaceSystem spaceSystem = this.spaceSystemAliases.get(qualifiedName);
            return spaceSystem;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpaceSystem getSpaceSystem(String namespace, String name) {
        this.rwLock.readLock().lock();
        try {
            SpaceSystem spaceSystem = this.spaceSystemAliases.get(namespace, name);
            return spaceSystem;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public SpaceSystem getSpaceSystem(Yamcs.NamedObjectId id) {
        this.rwLock.readLock().lock();
        try {
            if (id.hasNamespace()) {
                SpaceSystem spaceSystem = this.spaceSystemAliases.get(id.getNamespace(), id.getName());
                return spaceSystem;
            }
            SpaceSystem spaceSystem = this.spaceSystemAliases.get(id.getName());
            return spaceSystem;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Collection<SequenceContainer> getSequenceContainers() {
        return this.sequenceContainers.values();
    }

    public List<ParameterEntry> getParameterEntries(Parameter p) {
        return this.parameter2ParameterEntryMap.get(p);
    }

    public List<ContainerEntry> getContainerEntries(SequenceContainer sc) {
        return this.sequenceContainer2ContainerEntryMap.get(sc);
    }

    public Collection<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public <T extends NonStandardData<T>> T getNonStandardDataOfType(Class<T> clazz) {
        if (this.nonStandardDatas.containsKey(clazz)) {
            return (T)this.nonStandardDatas.get(clazz);
        }
        return null;
    }

    public Collection<NonStandardData> getNonStandardData() {
        return this.nonStandardDatas.values();
    }

    public void buildIndexMaps() {
        XtceAliasSet aliases;
        this.buildSpaceSystemsMap(this.rootSystem);
        this.buildParameterMap(this.rootSystem);
        this.buildParameterTypeMap(this.rootSystem);
        this.buildSequenceContainerMap(this.rootSystem);
        this.buildAlgorithmMap(this.rootSystem);
        this.buildMetaCommandMap(this.rootSystem);
        this.buildNonStandardDataMap(this.rootSystem);
        this.parameter2ParameterEntryMap = new HashMap();
        this.sequenceContainer2ContainerEntryMap = new HashMap();
        this.sequenceContainer2InheritingContainerMap = new HashMap();
        for (SequenceContainer sc : this.sequenceContainers.values()) {
            for (SequenceEntry se : sc.getEntryList()) {
                if (se instanceof ParameterEntry) {
                    ParameterEntry pe = (ParameterEntry)se;
                    Parameter param = pe.getParameter();
                    ArrayList al = this.parameter2ParameterEntryMap.computeIfAbsent(param, k -> new ArrayList());
                    al.add(pe);
                    continue;
                }
                if (se instanceof ContainerEntry) {
                    ContainerEntry ce = (ContainerEntry)se;
                    ArrayList al = this.sequenceContainer2ContainerEntryMap.computeIfAbsent(ce.getRefContainer(), k -> new ArrayList());
                    al.add(ce);
                    continue;
                }
                if (!(se instanceof IndirectParameterRefEntry)) continue;
                IndirectParameterRefEntry ipe = (IndirectParameterRefEntry)se;
                List l = this.indirectParameterRefEntries.computeIfAbsent(ipe.getAliasNameSpace(), k -> new ArrayList());
                l.add(ipe);
            }
            if (sc.baseContainer == null) continue;
            ArrayList<SequenceContainer> al_sc = this.sequenceContainer2InheritingContainerMap.get(sc.baseContainer);
            if (al_sc == null) {
                al_sc = new ArrayList();
                this.sequenceContainer2InheritingContainerMap.put(sc.getBaseContainer(), al_sc);
            }
            al_sc.add(sc);
        }
        for (SpaceSystem ss : this.spaceSystems.values()) {
            this.spaceSystemAliases.add(ss);
            aliases = ss.getAliasSet();
            if (aliases == null) continue;
            aliases.getNamespaces().forEach(ns -> this.namespaces.add((String)ns));
        }
        for (SequenceContainer sc : this.sequenceContainers.values()) {
            this.sequenceContainerAliases.add(sc);
            aliases = sc.getAliasSet();
            if (aliases == null) continue;
            aliases.getNamespaces().forEach(ns -> this.namespaces.add((String)ns));
        }
        for (Parameter p : this.parameters.values()) {
            this.parameterAliases.add(p);
            aliases = p.getAliasSet();
            if (aliases == null) continue;
            aliases.getNamespaces().forEach(ns -> this.namespaces.add((String)ns));
        }
        for (ParameterType t : this.parameterTypes.values()) {
            this.parameterTypeAliases.add((NameDescription)((Object)t));
            aliases = ((NameDescription)((Object)t)).getAliasSet();
            if (aliases == null) continue;
            aliases.getNamespaces().forEach(ns -> this.namespaces.add((String)ns));
        }
        for (Algorithm a : this.algorithms.values()) {
            this.algorithmAliases.add(a);
            aliases = a.getAliasSet();
            if (aliases == null) continue;
            aliases.getNamespaces().forEach(ns -> this.namespaces.add((String)ns));
        }
        for (MetaCommand mc : this.commands.values()) {
            this.commandAliases.add(mc);
            aliases = mc.getAliasSet();
            if (aliases == null) continue;
            aliases.getNamespaces().forEach(ns -> this.namespaces.add((String)ns));
        }
    }

    private void buildSpaceSystemsMap(SpaceSystem ss) {
        this.spaceSystems.put(ss.getQualifiedName(), ss);
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            this.buildSpaceSystemsMap(ss1);
        }
    }

    private void buildParameterMap(SpaceSystem ss) {
        for (Parameter p : ss.getParameters()) {
            this.parameters.put(p.getQualifiedName(), p);
        }
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            this.buildParameterMap(ss1);
        }
    }

    private void buildParameterTypeMap(SpaceSystem ss) {
        for (ParameterType t : ss.getParameterTypes()) {
            String qualifiedName = ((NameDescription)((Object)t)).getQualifiedName();
            this.parameterTypes.put(qualifiedName, t);
        }
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            this.buildParameterTypeMap(ss1);
        }
    }

    private void buildSequenceContainerMap(SpaceSystem ss) {
        for (SequenceContainer sc : ss.getSequenceContainers()) {
            this.sequenceContainers.put(sc.getQualifiedName(), sc);
        }
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            this.buildSequenceContainerMap(ss1);
        }
    }

    private void buildAlgorithmMap(SpaceSystem ss) {
        for (Algorithm a : ss.getAlgorithms()) {
            this.algorithms.put(a.getQualifiedName(), a);
        }
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            this.buildAlgorithmMap(ss1);
        }
    }

    private void buildMetaCommandMap(SpaceSystem ss) {
        for (MetaCommand mc : ss.getMetaCommands()) {
            this.commands.put(mc.getQualifiedName(), mc);
        }
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            this.buildMetaCommandMap(ss1);
        }
    }

    private void buildNonStandardDataMap(SpaceSystem ss) {
        for (NonStandardData data : ss.getNonStandardData()) {
            if (this.nonStandardDatas.containsKey(data.getClass())) {
                NonStandardData mergeResult = this.nonStandardDatas.get(data.getClass()).mergeWithChild(data);
                this.nonStandardDatas.put(data.getClass(), mergeResult);
                continue;
            }
            this.nonStandardDatas.put(data.getClass(), data);
        }
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            this.buildNonStandardDataMap(ss1);
        }
    }

    public List<SequenceContainer> getInheritingContainers(SequenceContainer container) {
        return this.sequenceContainer2InheritingContainerMap.get(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(Parameter p, boolean createSpaceSystem) {
        log.debug("Adding parameter {} , createSpaceSystem: {}", (Object)p.getQualifiedName(), (Object)createSpaceSystem);
        this.rwLock.writeLock().lock();
        try {
            if (this.parameters.containsKey(p.getQualifiedName())) {
                throw new IllegalArgumentException("There is already a parameter with qualified name '" + p.getQualifiedName() + "'");
            }
            String ssname = p.getSubsystemName();
            SpaceSystem ss = this.spaceSystems.get(ssname);
            if (ss == null) {
                if (!createSpaceSystem) {
                    throw new IllegalArgumentException("No SpaceSystem by name '" + ssname + "'");
                }
                this.createAllSpaceSystems(ssname);
            }
            ss = this.spaceSystems.get(ssname);
            ss.addParameter(p);
            this.parameters.put(p.getQualifiedName(), p);
            this.parameterAliases.add(p);
            XtceAliasSet aliases = p.getAliasSet();
            if (aliases != null) {
                aliases.getNamespaces().forEach(ns -> this.namespaces.add((String)ns));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemParameter createSystemParameter(String parameterQualifiedNamed) {
        this.rwLock.writeLock().lock();
        try {
            if (!parameterQualifiedNamed.startsWith(YAMCS_SPACESYSTEM_NAME)) {
                throw new IllegalArgumentException("The parameter qualified name must start with /yamcs");
            }
            SystemParameter p = (SystemParameter)this.parameters.get(parameterQualifiedNamed);
            if (p == null) {
                p = SystemParameter.getForFullyQualifiedName(parameterQualifiedNamed);
                this.addParameter(p, true);
            }
            SystemParameter systemParameter = p;
            return systemParameter;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void createAllSpaceSystems(String ssname) {
        String[] a = ssname.split("/");
        String qn = "";
        for (String name : a) {
            if (name.isEmpty() || this.getSpaceSystem(qn = qn + "/" + name) != null) continue;
            SpaceSystem ss = new SpaceSystem(name);
            ss.setQualifiedName(qn);
            this.addSpaceSystem(ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetaCommand(MetaCommand c) {
        this.rwLock.writeLock().lock();
        try {
            String ssname = c.getSubsystemName();
            SpaceSystem ss = this.spaceSystems.get(ssname);
            if (ss == null) {
                throw new IllegalArgumentException("No SpaceSystem by name '" + ssname + "'");
            }
            ss.addMetaCommand(c);
            this.commands.put(c.getQualifiedName(), c);
            this.commandAliases.add(c);
            XtceAliasSet aliases = c.getAliasSet();
            if (aliases != null) {
                this.namespaces.addAll(aliases.getNamespaces());
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpaceSystem(SpaceSystem system) {
        this.rwLock.writeLock().lock();
        try {
            if (system.getParent() != null) {
                throw new IllegalArgumentException("The parent of the space system has to be null (it will be set by this method");
            }
            if (!(system.getParameters().isEmpty() && system.getSequenceContainers().isEmpty() && system.getAlgorithms().isEmpty() && system.getMetaCommands().isEmpty() && system.getSubSystems().isEmpty())) {
                throw new IllegalArgumentException("The space system must be empty (no parameters, containers, commands, algorithms, subsystems)");
            }
            String parentName = system.getSubsystemName();
            SpaceSystem parent = this.spaceSystems.get(parentName);
            if (parent == null) {
                throw new IllegalArgumentException("The parent subsystem '" + parentName + "' does not exist");
            }
            parent.addSpaceSystem(system);
            system.setParent(parent);
            this.spaceSystems.put(system.getQualifiedName(), system);
            this.spaceSystemAliases.add(system);
            XtceAliasSet aliases = system.getAliasSet();
            if (aliases != null) {
                aliases.getNamespaces().forEach(ns -> this.namespaces.add((String)ns));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public static boolean isSystemParameter(Yamcs.NamedObjectId id) {
        boolean result = !id.hasNamespace() ? id.getName().startsWith(YAMCS_SPACESYSTEM_NAME) : id.getNamespace().startsWith(YAMCS_SPACESYSTEM_NAME);
        return result;
    }

    public static boolean isSystemParameter(String fqn) {
        return fqn.startsWith(YAMCS_SPACESYSTEM_NAME);
    }

    public Collection<SpaceSystem> getSpaceSystems() {
        return this.spaceSystems.values();
    }

    public Collection<IndirectParameterRefEntry> getIndirectParameterRefEntries(String namespace) {
        return this.indirectParameterRefEntries.get(namespace);
    }

    private void print(SpaceSystem ss, PrintStream out) {
        if (ss.getHeader() != null) {
            out.println("=========SpaceSystem " + ss.getQualifiedName() + " version: " + ss.getHeader().getVersion() + " date: " + ss.getHeader().getDate() + "=========");
        } else {
            out.println("=========SpaceSystem " + ss.getQualifiedName() + " (no header information)=========");
        }
        Comparator comparator = (o1, o2) -> o1.getName().compareTo(o2.getName());
        SequenceContainer[] sca = ss.getSequenceContainers().toArray(new SequenceContainer[0]);
        Arrays.sort(sca, comparator);
        for (SequenceContainer sc : sca) {
            sc.print(out);
        }
        Algorithm[] aa = ss.getAlgorithms().toArray(new Algorithm[0]);
        Arrays.sort(aa, comparator);
        for (Algorithm a : aa) {
            a.print(out);
        }
        MetaCommand[] mca = ss.getMetaCommands().toArray(new MetaCommand[0]);
        Arrays.sort(mca, comparator);
        for (MetaCommand mc : mca) {
            mc.print(out);
        }
        ArrayList<SystemParameter> systemVariables = new ArrayList<SystemParameter>();
        for (Parameter p : ss.getParameters()) {
            if (!(p instanceof SystemParameter)) continue;
            systemVariables.add((SystemParameter)p);
        }
        if (!systemVariables.isEmpty()) {
            out.println("System Parameters: ");
            SystemParameter[] sva = systemVariables.toArray(new SystemParameter[0]);
            Arrays.sort(sva, comparator);
            SystemParameter[] systemParameterArray = sva;
            int n = systemParameterArray.length;
            for (int i = 0; i < n; ++i) {
                SystemParameter sv = systemParameterArray[i];
                out.println("\t" + sv.getName());
            }
        }
        SpaceSystem[] ssa = ss.getSubSystems().toArray(new SpaceSystem[0]);
        Arrays.sort(ssa, comparator);
        for (SpaceSystem ss1 : ssa) {
            this.print(ss1, out);
        }
    }

    public void print(PrintStream out) {
        this.print(this.rootSystem, out);
        HashSet<Parameter> orphanedParameters = new HashSet<Parameter>();
        orphanedParameters.addAll(this.parameters.values());
        XtceDb.removeNonOrphaned(this.rootSystem, orphanedParameters);
        orphanedParameters.removeAll(this.parameter2ParameterEntryMap.keySet());
        if (!orphanedParameters.isEmpty()) {
            out.println("================ Orphaned parameters (not referenced in any container or algorithm):");
            for (Parameter p : orphanedParameters) {
                String namespaces = "";
                if (p.getAliasSet() != null) {
                    namespaces = ", aliases: " + p.getAliasSet();
                }
                out.println(p.getQualifiedName() + ", datasource: " + (Object)((Object)p.getDataSource()) + namespaces + " type: " + p.getParameterType());
            }
        }
    }

    private static void removeNonOrphaned(SpaceSystem ss, Set<Parameter> orphanedParameters) {
        for (Algorithm a : ss.getAlgorithms()) {
            for (InputParameter inputParameter : a.getInputSet()) {
                orphanedParameters.remove(inputParameter.getParameterInstance().getParameter());
            }
            for (OutputParameter outputParameter : a.getOutputSet()) {
                orphanedParameters.remove(outputParameter.getParameter());
            }
        }
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            XtceDb.removeNonOrphaned(ss1, orphanedParameters);
        }
    }
}

