/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.yamcs.xtce.AggregateParameterType;
import org.yamcs.xtce.Container;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.Member;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.PathElement;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.util.NameReference;

public class ReferenceFinder {
    Consumer<String> logger;

    public ReferenceFinder(Consumer<String> logger) {
        this.logger = logger;
    }

    public FoundReference findReference(SpaceSystem rootSs, NameReference nr, SpaceSystem ss) {
        String ref = nr.getReference();
        boolean absolute = false;
        SpaceSystem startSs = null;
        if (ref.startsWith("/")) {
            absolute = true;
            startSs = rootSs;
        } else if (ref.startsWith("./") || ref.startsWith("..")) {
            absolute = true;
            startSs = ss;
        }
        if (absolute) {
            return ReferenceFinder.findReference(startSs, nr);
        }
        FoundReference rr = null;
        for (startSs = ss; (rr = ReferenceFinder.findReference(startSs, nr)) == null && startSs != rootSs; startSs = startSs.getParent()) {
        }
        return rr;
    }

    private FoundReference findAliasReference(SpaceSystem ss, NameReference nr) {
        List<NameDescription> l;
        String alias = nr.getReference();
        switch (nr.getType()) {
            case PARAMETER: {
                l = ss.getParameterByAlias(alias);
                break;
            }
            case SEQUENCE_CONTAINER: {
                l = ss.getSequenceContainerByAlias(alias);
                break;
            }
            case META_COMMAND: {
                l = ss.getMetaCommandByAlias(alias);
                break;
            }
            default: {
                return null;
            }
        }
        if (l == null || l.isEmpty()) {
            return null;
        }
        if (l.size() > 1) {
            this.logger.accept("When looking for aliases '" + nr + "' found multiple matches: " + l);
        }
        return new FoundReference(l.get(0));
    }

    public FoundReference findAliasReference(SpaceSystem rootSs, NameReference nr, SpaceSystem startSs) {
        FoundReference nd = null;
        for (SpaceSystem ss = startSs; (nd = this.findAliasReference(ss, nr)) == null && ss != rootSs; ss = ss.getParent()) {
        }
        return nd;
    }

    private static FoundReference findReference(SpaceSystem startSs, NameReference nr) {
        String[] path = nr.getReference().split("/");
        SpaceSystem ss = startSs;
        for (int i = 0; i < path.length - 1; ++i) {
            if (".".equals(path[i]) || "".equals(path[i])) continue;
            if ("..".equals(path[i])) {
                if ((ss = ss.getParent()) != null) continue;
                break;
            }
            if (i == path.length - 1) break;
            SpaceSystem ss1 = ss.getSubsystem(path[i]);
            if (ss1 == null && nr.getType() == NameReference.Type.PARAMETER) {
                PathElement[] aggregateMemberPath;
                Parameter p = ss.getParameter(path[i]);
                if (p == null || !(p.getParameterType() instanceof AggregateParameterType) || !ReferenceFinder.checkReferenceToAggregateMember(p, aggregateMemberPath = ReferenceFinder.getAggregateMemberPath(Arrays.copyOfRange(path, i + 1, path.length)))) break;
                return new FoundReference(p, aggregateMemberPath);
            }
            if (ss1 == null) break;
            ss = ss1;
        }
        if (ss == null) {
            return null;
        }
        String name = path[path.length - 1];
        switch (nr.getType()) {
            case PARAMETER: {
                return ReferenceFinder.getSimpleReference(ss.getParameter(name));
            }
            case PARAMETER_TYPE: {
                return ReferenceFinder.getSimpleReference((NameDescription)((Object)ss.getParameterType(name)));
            }
            case SEQUENCE_CONTAINER: {
                return ReferenceFinder.getSimpleReference(ss.getSequenceContainer(name));
            }
            case COMMAND_CONTAINER: {
                Container c = ss.getCommandContainer(name);
                if (c == null) {
                    c = ss.getSequenceContainer(name);
                }
                return ReferenceFinder.getSimpleReference(c);
            }
            case META_COMMAND: {
                return ReferenceFinder.getSimpleReference(ss.getMetaCommand(name));
            }
            case ALGORITHM: {
                return ReferenceFinder.getSimpleReference(ss.getAlgorithm(name));
            }
            case ARGUMENT_TYPE: {
                return ReferenceFinder.getSimpleReference((NameDescription)((Object)ss.getArgumentType(name)));
            }
        }
        return null;
    }

    private static boolean checkReferenceToAggregateMember(Parameter p, PathElement[] path) {
        AggregateParameterType apt = (AggregateParameterType)p.getParameterType();
        for (int i = 0; i < path.length; ++i) {
            Member m = apt.getMember(path[i].getName());
            if (m == null) {
                return false;
            }
            if (i == path.length - 1) {
                return true;
            }
            DataType ptype = m.getType();
            if (ptype instanceof AggregateParameterType) continue;
            return false;
        }
        return false;
    }

    private static FoundReference getSimpleReference(NameDescription nd) {
        if (nd == null) {
            return null;
        }
        return new FoundReference(nd);
    }

    private static PathElement[] getAggregateMemberPath(String[] path) {
        PathElement[] pea = new PathElement[path.length];
        for (int i = 0; i < path.length; ++i) {
            pea[i] = PathElement.fromString(path[i]);
        }
        return pea;
    }

    public static class FoundReference {
        private final NameDescription nd;
        private final PathElement[] aggregateMemberPath;

        public FoundReference(NameDescription nd, PathElement[] aggregateMemberPath) {
            if (nd == null) {
                throw new NullPointerException("nd cannot be null");
            }
            this.nd = nd;
            this.aggregateMemberPath = aggregateMemberPath;
        }

        public FoundReference(NameDescription nd) {
            if (nd == null) {
                throw new NullPointerException("nd cannot be null");
            }
            this.nd = nd;
            this.aggregateMemberPath = null;
        }

        public NameDescription getNameDescription() {
            return this.nd;
        }

        public PathElement[] getAggregateMemberPath() {
            return this.aggregateMemberPath;
        }

        public String toString() {
            return this.nd.getName() + (this.aggregateMemberPath == null ? "" : "." + Arrays.toString(this.aggregateMemberPath));
        }
    }
}

