/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.Member;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.util.AggregateMemberNames;

public class AggregateDataType
extends NameDescription
implements DataType {
    private static final long serialVersionUID = 1L;
    List<Member> memberList = new ArrayList<Member>();
    transient AggregateMemberNames memberNames;

    public AggregateDataType(Builder<?> builder) {
        super(builder);
        this.memberList = builder.memberList;
    }

    protected AggregateDataType(AggregateDataType t) {
        super(t);
        this.memberList = t.memberList;
        this.memberNames = t.memberNames;
    }

    @Override
    public String getTypeAsString() {
        return "aggregate";
    }

    public Member getMember(String name) {
        for (Member m : this.memberList) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public List<Member> getMemberList() {
        return this.memberList;
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.AGGREGATE;
    }

    public Member getMember(String[] path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("path cannot be empty");
        }
        DataType ptype = this;
        Member m = null;
        for (int i = 0; i < path.length; ++i) {
            if (ptype instanceof AggregateDataType) {
                m = ptype.getMember(path[i]);
                if (m == null) {
                    return null;
                }
            } else {
                return null;
            }
            ptype = m.getType();
        }
        return m;
    }

    public AggregateMemberNames getMemberNames() {
        if (this.memberNames == null) {
            String[] n = (String[])this.memberList.stream().map(m -> m.getName()).toArray(String[]::new);
            this.memberNames = AggregateMemberNames.get(n);
        }
        return this.memberNames;
    }

    public int numMembers() {
        return this.memberList.size();
    }

    public Member getMember(int idx) {
        return this.memberList.get(idx);
    }

    @Override
    public Map<String, Object> convertType(Object value) {
        if (value instanceof String) {
            try {
                JsonElement je = JsonParser.parseString((String)((String)value));
                if (je instanceof JsonObject) {
                    return this.fromJson((JsonObject)je);
                }
                throw new IllegalArgumentException("Expected JSON object but found " + je.getClass());
            }
            catch (JsonParseException jpe) {
                throw new IllegalArgumentException(jpe.toString());
            }
        }
        if (value instanceof Map) {
            return this.fromMap((Map)value);
        }
        throw new IllegalArgumentException("Cannot convert value of type '" + value.getClass() + "'");
    }

    private Map<String, Object> fromJson(JsonObject jobj) {
        JsonObject input = jobj.deepCopy();
        HashMap<String, Object> r = new HashMap<String, Object>();
        for (Member memb : this.memberList) {
            if (input.has(memb.getName())) {
                JsonElement jsel = input.remove(memb.getName());
                String v = jsel.isJsonPrimitive() && jsel.getAsJsonPrimitive().isString() ? jsel.getAsString() : jsel.toString();
                r.put(memb.getName(), memb.getType().convertType(v));
                continue;
            }
            Object v = memb.getInitialValue();
            if (v == null) {
                v = memb.getType().getInitialValue();
            }
            if (v == null) {
                throw new IllegalArgumentException("No value could be determined for member '" + memb.getName() + "' (its corresponding type does not have an initial value)");
            }
            r.put(memb.getName(), v);
        }
        if (input.size() > 0) {
            throw new IllegalArgumentException("Unknown members " + input.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList()));
        }
        return r;
    }

    private Map<String, Object> fromMap(Map<String, Object> map) {
        HashMap<String, Object> input = new HashMap<String, Object>(map);
        HashMap<String, Object> r = new HashMap<String, Object>(input.size());
        for (Member memb : this.memberList) {
            if (input.containsKey(memb.getName())) {
                Object el = input.remove(memb.getName());
                r.put(memb.getName(), memb.getType().convertType(el));
                continue;
            }
            Object v = memb.getInitialValue();
            if (v == null) {
                v = memb.getType().getInitialValue();
            }
            if (v == null) {
                throw new IllegalArgumentException("No value could be determined for member '" + memb.getName() + "' (its corresponding type does not have an initial value)");
            }
            r.put(memb.getName(), v);
        }
        if (input.size() > 0) {
            throw new IllegalArgumentException("Unknown members: " + input.keySet());
        }
        return r;
    }

    @Override
    public Map<String, Object> parseStringForRawValue(String stringValue) {
        try {
            JsonElement je = JsonParser.parseString((String)stringValue);
            if (je instanceof JsonObject) {
                return this.fromJsonRaw((JsonObject)je);
            }
            throw new IllegalArgumentException("Expected JSON object but found " + je.getClass());
        }
        catch (JsonParseException jpe) {
            throw new IllegalArgumentException(jpe.toString());
        }
    }

    private Map<String, Object> fromJsonRaw(JsonObject jobj) {
        JsonObject input = jobj.deepCopy();
        HashMap<String, Object> r = new HashMap<String, Object>();
        for (Member memb : this.memberList) {
            if (input.has(memb.getName())) {
                JsonElement jsel = input.remove(memb.getName());
                String v = jsel.isJsonPrimitive() && jsel.getAsJsonPrimitive().isString() ? jsel.getAsString() : jsel.toString();
                r.put(memb.getName(), memb.getType().parseStringForRawValue(v));
                continue;
            }
            throw new IllegalArgumentException("No value for member '" + memb.getName() + "'");
        }
        if (input.size() > 0) {
            throw new IllegalArgumentException("Unknown members " + input.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.joining(",", "[", "]")));
        }
        return r;
    }

    @Override
    public Map<String, Object> getInitialValue() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        for (Member memb : this.memberList) {
            DataType dt;
            Object v = memb.getInitialValue();
            if (v == null && (dt = memb.getType()) != null) {
                v = dt.getInitialValue();
            }
            if (v == null) {
                return null;
            }
            r.put(memb.getName(), v);
        }
        return r;
    }

    @Override
    public String toString(Object v) {
        Gson gson = new Gson();
        return gson.toJson(this.getMapStr(v));
    }

    private Map<String, Object> getMapStr(Object v) {
        if (!(v instanceof Map)) {
            throw new IllegalArgumentException("Can only convert maps; got: " + v);
        }
        HashMap m = new HashMap((Map)v);
        HashMap<String, Object> r = new HashMap<String, Object>();
        for (Member memb : this.memberList) {
            Object v1 = m.remove(memb.getName());
            if (v1 == null) {
                if (memb.getInitialValue() != null) continue;
                throw new IllegalArgumentException("no value provided for member '" + memb.getName() + "'");
            }
            DataType dt = memb.getType();
            if (dt instanceof AggregateDataType) {
                r.put(memb.getName(), ((AggregateDataType)dt).getMapStr(v1));
                continue;
            }
            dt.toString(v1);
            r.put(memb.getName(), v1);
        }
        if (!m.isEmpty()) {
            throw new IllegalArgumentException("Unknown members " + m.keySet());
        }
        return r;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends NameDescription.Builder<T>
    implements DataType.Builder<T> {
        List<Member> memberList = new ArrayList<Member>();

        public Builder() {
        }

        public Builder(AggregateDataType dataType) {
            super(dataType);
            this.memberList = dataType.memberList;
        }

        @Override
        public T setInitialValue(String initialValue) {
            throw new UnsupportedOperationException("Cannot set initial value; please send individual initial values for the members");
        }

        public T addMember(Member member) {
            this.memberList.add(member);
            return (T)((Builder)this.self());
        }

        public T addMembers(List<Member> memberList) {
            this.memberList.addAll(memberList);
            return (T)((Builder)this.self());
        }

        public List<Member> getMemberList() {
            return this.memberList;
        }
    }
}

