/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.util.DoubleRange;

public class AlarmRanges
implements Serializable {
    private static final long serialVersionUID = 200706052351L;
    DoubleRange watchRange = null;
    DoubleRange warningRange = null;
    DoubleRange distressRange = null;
    DoubleRange criticalRange = null;
    DoubleRange severeRange = null;

    public void addWatchRange(DoubleRange range) {
        this.watchRange = this.watchRange == null ? range : this.watchRange.intersectWith(range);
    }

    public void addWarningRange(DoubleRange range) {
        this.warningRange = this.warningRange == null ? range : this.warningRange.intersectWith(range);
    }

    public void addDistressRange(DoubleRange range) {
        this.distressRange = this.distressRange == null ? range : this.distressRange.intersectWith(range);
    }

    public void addCriticalRange(DoubleRange range) {
        this.criticalRange = this.criticalRange == null ? range : this.criticalRange.intersectWith(range);
    }

    public void addSevereRange(DoubleRange range) {
        this.severeRange = this.severeRange == null ? range : this.severeRange.intersectWith(range);
    }

    public void addRange(DoubleRange range, AlarmLevels level) {
        switch (level) {
            case WATCH: {
                this.addWatchRange(range);
                break;
            }
            case WARNING: {
                this.addWarningRange(range);
                break;
            }
            case DISTRESS: {
                this.addDistressRange(range);
                break;
            }
            case CRITICAL: {
                this.addCriticalRange(range);
                break;
            }
            case SEVERE: {
                this.addSevereRange(range);
                break;
            }
            default: {
                throw new IllegalArgumentException("Level '" + level + "' not allowed for alarm ranges");
            }
        }
    }

    public DoubleRange getWatchRange() {
        return this.watchRange;
    }

    public DoubleRange getWarningRange() {
        return this.warningRange;
    }

    public DoubleRange getDistressRange() {
        return this.distressRange;
    }

    public DoubleRange getCriticalRange() {
        return this.criticalRange;
    }

    public DoubleRange getSevereRange() {
        return this.severeRange;
    }

    public void setWarningRange(DoubleRange warningRange) {
        this.warningRange = warningRange;
    }

    public String toString() {
        return (String)(this.watchRange != null ? " watchRange" + this.watchRange : "") + (String)(this.warningRange != null ? " warningRange" + this.warningRange : "") + (String)(this.distressRange != null ? " distressRange" + this.distressRange : "") + (String)(this.criticalRange != null ? " criticalRange" + this.criticalRange : "") + (String)(this.severeRange != null ? " severeRange" + this.severeRange : "");
    }
}

